#!/usr/bin/tclsh

package require fileutil

if {[llength $argv]<1} {
    puts stderr {extract sourceDir [translationFile]}
    exit 1
}

set sourceDir [lindex $argv 0]
set translationFile [lindex $argv 1]

# Read all tcl file from sourceDir
set tclFileList [::fileutil::findByPattern $sourceDir -glob -- *tcl]
foreach filename $tclFileList {
    set fd [open $filename]

    while {-1 < [gets $fd line]} {
        # Search: [::msgcat "translation key"
        if {[regexp -- {\[::msgcat::mc[ \t\r\n]+\"([^\"]*)\"} $line whole key]} {
            if {![info exists keyHash($filename)]} {
                set keyHash($filename) [list]
            }
            if {[lsearch -exact $keyHash($filename) $key]<0} {
                # key doesn't exist for this file
                lappend keyHash($filename) $key
            }
        }
    }
    close $fd
}

# Remove duplicated keys
set fileList [array names keyHash]
for {set i 0} {$i < [llength $fileList]} {incr i} {
    for {set j [expr $i + 1]} {$j < [llength $fileList]} {incr j} {
        foreach k $keyHash([lindex $fileList $i]) {
            set J [lindex $fileList $j]
            set ix [lsearch -exact $keyHash($J) $k]
            if {-1 < $ix} {
                set keyHash($J) [lreplace $keyHash($J) $ix $ix]
            }
        }
    }
}

if {1 < [llength $argv]} {
    # Read translation file
    set fd [open $translationFile]
    set translated [list]

    while {-1 < [gets $fd line]} {
        # Search: ::msgcat::mcset lang "translation key"
        if {[regexp -- {::msgcat::mcset [a-zA-Z]+[ \t\r\n]+\"([^\"]*)\"} $line whole key]} {
            lappend translated $key
            #puts $key
        }
    }
    close $fd

    # Remove translated keys
    foreach f [array names keyHash] {
        foreach k $keyHash($f) {
            if {-1 < [lsearch -exact $translated $k]} {
                set ix [lsearch -exact $keyHash($f) $k]
                set keyHash($f) [lreplace $keyHash($f) $ix $ix]
            }
        }
    }
}

# Print result
foreach f [array names keyHash] {
    if {0 < [llength $keyHash($f)]} {
        puts "# $f"
        foreach k $keyHash($f) {
            puts "\"$k\""
        }
        puts ""
    }
}
