# $Id: default.tcl,v 1.5 2003/09/20 18:42:57 aleksey Exp $

set font "fixed"

proc define_fonts {args} {
    global font font_bold font_italic font_bold_italic

    if {![info exists font_bold]} {
	set font_bold [eval font create [font actual $font]]
	font configure $font_bold -weight bold
    }
    if {![info exists font_italic]} {
	set font_italic [eval font create [font actual $font]]
	font configure $font_italic -slant italic
    }
    if {![info exists font_bold_italic]} {
	set font_bold_italic [eval font create [font actual $font]]
	font configure $font_bold_italic -weight bold -slant italic
    }
}

hook::add postload_hook define_fonts

set loginconf(user) ""
set loginconf(password) ""
set loginconf(resource) tkabber
set loginconf(server) localhost
set loginconf(usealtserver) 0
set loginconf(altserver) ""
set loginconf(port) 5222
set loginconf(priority) 8
set loginconf(usedigest) 0
set loginconf(usessl) 0
set loginconf(sslport) 5223
set loginconf(useproxy) 0
set loginconf(httpproxy) localhost
set loginconf(httpproxyport) 3128
set loginconf(httplogin) ""
set loginconf(httppassword) ""

set usetabbar 1
set raise_new_tab 1
set pixmaps_theme default

proc postload {} {}

proc menuload {menudesc} { return $menudesc }

proc finload  {} {}


#option readfile ermine.xrdb userDefault
#option readfile examples/teopetuk.xrdb userDefault

option add *Entry.font $font widgetDefault
#option add *Entry.background White
#option add *Text.background White


proc browseurl {url} {
    global env tcl_platform

    set_status $url
    update

    switch -- $tcl_platform(platform) {
        windows {
            switch -- $tcl_platform(os) {
                "Windows NT" {
		    exec "c:/program files/internet explorer/iexplore.exe" \
			-nohome $url &
#                   exec $env(COMSPEC) /c start $url &
                }

                default {
                    exec start $url &
                }
            }
        }

        macintosh {
            if {![info exists env(BROWSER)]} {
                set env(BROWSER) "Browse the Internet"
                AppleScript execute \
                "tell application \"env(BROWSER)\"\nopen url \"$url\"\nend tell\n"
            }
        }

        default {
            if {![info exists env(BROWSER)]} {
                foreach b [list galeon konqueror mozilla netscape iexplorer \
                                opera] {
                    if {[llength [set e [auto_execok $b]]] > 0} {
                        set env(BROWSER) [lindex $e 0]
                        break
                    }
                }
                if {![info exists env(BROWSER)]} {
                    MessageDlg .browse_err -aspect 50000 -icon info \
                        -message {Please define $BROWSER} -type user \
			-buttons ok -default 0 -cancel 0
                    return
                }
            }

            if {[catch { exec $env(BROWSER) -remote $url }]} {
                exec $env(BROWSER) $url &
            }
        }
    }

    set_status ""
}


