# $Id: iface.tcl,v 1.68 2003/12/02 20:14:32 aleksey Exp $

custom::defgroup IFace \
    [::msgcat::mc "Options for main interface."] \
    -group Tkabber -tag "Main Interface"

custom::defvar raise_new_tab 1 \
    [::msgcat::mc "Raise new tab."] \
    -group IFace -type boolean

custom::defvar message_numbers_in_tabs 1 \
    [::msgcat::mc "Show number of unread messages in tab titles."] \
    -group IFace -type boolean

custom::defvar update_title_delay 600 \
    [::msgcat::mc "Delay between getting focus and updating window or tab title in milliseconds."] \
    -group IFace -type integer


option add *errorForeground red widgetDefault

set xselection ""

proc EncodeTextSelection {txt offset len} {
    set elided ""
    if {[lcontain [$txt tag names] emphasized] && [$txt tag cget emphasized -elide]} {
	set elided emphasized
    } elseif {[lcontain [$txt tag names] nonemphasized] && [$txt tag cget nonemphasized -elide]} {
	set elided nonemphasized
    }
    if {[cequal $elided ""]} {
	set ::xselection [eval $txt get [$txt tag ranges sel]]
    } else {
	lassign [$txt tag ranges sel] selstart selstop
	set sel $selstart
	set ::xselection ""
	while {![cequal [set range [$txt tag nextrange $elided $sel $selstop]] ""]} {
	    append ::xselection [$txt get $sel [lindex $range 0]]
	    set sel [lindex $range 1]
	}
	append ::xselection [$txt get $sel $selstop]
    }
    encoding convertto [crange $::xselection $offset [expr $offset + $len - 1]]
}

proc EncodeEntrySelection {txt offset len} {
    if [$txt selection present] {
	set idx1 [$txt index sel.first]	
	set idx2 [$txt index sel.last]
	set ::xselection [string range [$txt get] $idx1 $idx2]
	encoding convertto \
	    [crange $::xselection $offset [expr $offset + $len - 1]]
    } else {
	set ::xselection ""
    }
}

if {[cequal $tcl_platform(platform) unix]} {
    proc ::tk::GetSelection {w {sel PRIMARY}} {
        if {![catch {selection get -displayof $w \
			-selection $sel -type UTF8_STRING} txt]} {
	    return $txt
	} elseif {![catch {selection get -displayof $w -selection $sel} txt]} {
	    if {[selection own] == ""} {
		return [encoding convertfrom $txt]
	    } else {
		return $::xselection
	    }
	} else {
	    return -code error "could not find default selection"
	}
    }

    bind Text  <Map> { selection handle %W "EncodeTextSelection %W" }
    bind Entry <Map> { selection handle %W "EncodeEntrySelection %W" }
    
    if {[info tclversion] < 8.4} {
	bind Text <ButtonRelease-2> {
	    if {![catch {::tk::GetSelection %W} sel]} {
		%W insert current $sel
	    }
	}
	bind Entry <ButtonRelease-2> {
	    if {![catch {::tk::GetSelection %W} sel]} {
		%W insert insert $sel
	    }
	}
    }
}
###############################################################################

set w {}
set ::main_window_title "Tkabber"
wm title . $::main_window_title
wm iconname . $::main_window_title
wm group . .


set toolbaricon(groupchat) [Bitmap::get [pixmap tkabber glade-groupchat.gif]]
set toolbaricon(newuser)   [Bitmap::get [pixmap tkabber glade-new-user.gif]]
set toolbaricon(jb)        [Bitmap::get [pixmap tkabber jb.gif]]
set toolbaricon(online)    [Bitmap::get [pixmap tkabber glade-online.gif]]
set toolbaricon(offline)   [Bitmap::get [pixmap tkabber glade-offline.gif]]

set searchicon(case)	[Bitmap::get [pixmap tkabber search_case.gif]]
set searchicon(exact)	[Bitmap::get [pixmap tkabber search_exact.gif]]
set searchicon(back)	[Bitmap::get [pixmap tkabber search_bk.gif]]
set searchicon(forward)	[Bitmap::get [pixmap tkabber search_fw.gif]]

set descmenu [list \
		  "&Tkabber" {} {} 1 \
		  [list \
		       [list cascad [::msgcat::mc "Presence"] {} presence 1 \
			    [list \
				 [list command [::msgcat::mc "Online"] {} {} {} \
				      -command {set userstatus available}] \
				 [list command [::msgcat::mc "Free to chat"] {} {} {} \
				      -command {set userstatus chat}] \
				 [list command [::msgcat::mc "Away"] {} {} {} \
				      -command {set userstatus away}] \
				 [list command [::msgcat::mc "Extended away"] {} {} {} \
				      -command {set userstatus xa}] \
				 [list command [::msgcat::mc "Do not disturb"] {} {} {} \
				      -command {set userstatus dnd}] \
				 [list command [::msgcat::mc "Invisible"] {} {} {} \
				      -command {set userstatus invisible}] \
				 {separator} \
				 [list command [::msgcat::mc "Change priority..."] {} {} {} \
				      -command {change_priority_dialog}]]] \
		       [list command [::msgcat::mc "Log in..."] {} {} {Ctrl l} \
			    -command {show_login_dialog}] \
		       [list command [::msgcat::mc "Log out"] {} {} {Ctrl j} \
			    -command {logout_dialog}] \
		       [list command [::msgcat::mc "Log out with reason..."] {} {} {} \
			    -command {show_logout_dialog}] \
		       {separator} \
		       [list command [::msgcat::mc "Customize"] {} {} {} \
			    -command {custom::open_window Tkabber}] \
		       {separator} \
		       [list command [::msgcat::mc "Profile on"] {} {} {} -command {
			   profile -commands -eval on
		       }] \
		       [list command [::msgcat::mc "Profile report"] {} {} {} -command {
			   profile off profil
			   profrep profil real profresults
		       }] \
		       {separator} \
		       [list command [::msgcat::mc "Quit"] {} {} {} \
			    -command {quit}] \
		      ] \
		  "&[::msgcat::mc Services]" {} {} 1 \
		  [list \
		       [list command [::msgcat::mc "Send message..."] {} {} {} \
			    -command {message::send_dialog}] \
		       $roster_main_menu \
		       [list command [::msgcat::mc "Browser"] {} {} {} \
			    -command {browser::open}] \
		       [list command [::msgcat::mc "Discovery"] {} {} {} \
			    -command {disco::browser::open_win}] \
		       [list command [::msgcat::mc "Join group..."] {} {} {}\
			    -command {join_group_dialog}] \
		       [list cascad [::msgcat::mc "Sound"] {} {} 1 \
			         [list \
				      [list checkbutton [::msgcat::mc "Mute"] {} {} {} \
				           -variable sound::options(mute)]]] \
		       [list cascad [::msgcat::mc "Chats"] {} {} 1 \
			    [list \
				 [list checkbutton \
				      [::msgcat::mc \
					   "Generate event messages"] \
				      {} {} {} \
				      -variable muc::options(gen_events)] \
				 [list checkbutton [::msgcat::mc "Smart autoscroll"] {} {} {} \
				      -variable chat::options(smart_scroll)] \
				 [list checkbutton [::msgcat::mc "Stop autoscroll"] {} {} {} \
				      -variable chat::options(stop_scroll)] \
				 [list checkbutton [::msgcat::mc "Emphasize"] {} {} {} \
				      -variable chat::options(emphasize)]]] \
		       [list command [::msgcat::mc "Filters..."] {} {} {} \
			    -command {filters::open}] \
		       [list command [::msgcat::mc "Privacy rules..."] {} {} {} \
			    -command {privacy::request_lists}] \
		       [list command [::msgcat::mc "Change password..."] {} {} {} \
			    -command {change_password_dialog}] \
		       [list command [::msgcat::mc "Message archive"] {} {} {} \
			    -command {message_archive::show_archive}] \
		       [list command [::msgcat::mc "Show user info..."] {} {} {} \
			    -command {userinfo::show_info_dialog}] \
		       [list command [::msgcat::mc "Edit my info..."] {} {} {} \
			    -command {userinfo::open ${loginconf(user)}@$loginconf(server)/$loginconf(resource) -editable 1}] \
		       [list cascad [::msgcat::mc "Avatar"] {} {} 1 \
			    [list \
				 [list checkbutton [::msgcat::mc "Announce"] {} {} {} \
				      -variable avatar::options(announce)] \
				 [list checkbutton [::msgcat::mc "Allow downloading"] {} {} {} \
				      -variable avatar::options(share)] \
				 [list command [::msgcat::mc "Send to server"] {} {} {} \
				      -command {avatar::store_on_server}]]] \
		       [list cascad [::msgcat::mc "Jidlink"] \
			    {} jidlink 1 {}] \
		       {separator} \
		       [list cascad [::msgcat::mc "Admin tools"] {} admin 1 \
			    [list \
				 [list command [::msgcat::mc "Send broadcast message..."] {} {} {} \
				-command {eval {message::send_dialog \
						    "$loginconf(server)/announce/online" \
						}}] \
				 [list command [::msgcat::mc "Send message of the day..."] {} {} {} \
				-command {eval {message::send_dialog \
						    "$loginconf(server)/announce/motd" \
						}}] \
				 [list command [::msgcat::mc "Update message of the day..."] {} {} {} \
				-command {eval {message::send_dialog \
						    "$loginconf(server)/announce/motd/update" \
						}}] \
				 [list command [::msgcat::mc "Delete message of the day"] {} {} {} \
				-command {eval {message::send_msg \
						    "$loginconf(server)/announce/motd/delete" -type normal \
						}}]]]] \
		  "&[::msgcat::mc Help]" {} {} 1 \
		  [list \
		       [list command [::msgcat::mc "Quick help..."] {} {} {} \
			    -command {
				help_window [::msgcat::mc "Quick Help"] \
				    "\n[::msgcat::mc {Main window:}]
    Ctrl-L\t\t\t[::msgcat::mc {Log in}]
    Ctrl-J\t\t\t[::msgcat::mc {Log out}]
\n[::msgcat::mc Tabs:]
    Ctrl-F4\t\t\t[::msgcat::mc {Close tab}]
    Ctrl-PgUp/Down\t\t[::msgcat::mc {Previous/Next tab}]
    Ctrl-Alt-PgUp/Down\t[::msgcat::mc {Move tab left/right}]
    Alt-\[1-9,0\]\t\t[::msgcat::mc {Switch to tab number 1-9,10}]
    Ctrl-R\t\t\t[::msgcat::mc {Hide/Show roster}]
\n[::msgcat::mc Chats:]
    TAB\t\t\t[::msgcat::mc {Complete nickname}]
    Ctrl-Up/Down\t\t[::msgcat::mc {Previous/Next history message}]
    Alt-E\t\t\t[::msgcat::mc {Show emoticons}]
    Ctrl-Z\t\t\t[::msgcat::mc {Undo}]
    Ctrl-Shift-Z\t\t[::msgcat::mc {Redo}]
    Alt-PgUp/Down\t\t[::msgcat::mc {Scroll chat window up/down}]
    [::msgcat::mc {Right mouse	}]\t[::msgcat::mc {Correct word}]
"
			    }] \
		       [list command [::msgcat::mc "About..."] {} {} {} \
			    -command about_window] \
		      ] \
		 ]



if {[clength [info commands profile]] == 0} {
    set tmpmenu {}
    set eatP 0
    foreach menu [lindex $descmenu 4] {
        if {[::msgcat::mc "Profile on"] == [lindex $menu 1] || \
		[::msgcat::mc "Profile report"] == [lindex $menu 1]} {
	    set eatP 1
	} elseif {$eatP} {
	    set eatP 0
	} else {
            lappend tmpmenu $menu
        }
    }
    set descmenu [lreplace $descmenu 4 4 $tmpmenu]
}

proc about_window {} {
    global version
    help_window [::msgcat::mc "About"] "
Tkabber $version

Copyright \u00a9 2002, 2003 [::msgcat::mc {Alexey Shchepin}]
\n[::msgcat::mc Authors:]
    [::msgcat::mc {Alexey Shchepin}]
    [::msgcat::mc {Marshall T. Rose}]
    [::msgcat::mc {Sergei Golovan}]
    [::msgcat::mc {Michail Litvak}]

http://tkabber.jabberstudio.org/"
}

proc help_window {title message} {
    
    set mainlogo [Bitmap::get [pixmap tkabber mainlogo.gif]]
    Dialog .m -anchor e -separator yes -title $title -image $mainlogo \
	    -side bottom -modal local -cancel 0
    .m add -text [::msgcat::mc "OK"]
    set frame [.m getframe]
    message $frame.msg -text $message
    pack $frame.msg -side left
    .m setfocus 0
    .m draw
    destroy .m
}

set descmenu [menuload $descmenu]

set mf [MainFrame .mainframe -menu $descmenu -textvariable status]
if {$use_tls} {
    $mf addindicator -text "SSL" -state disabled
    set ssl_ind [$mf getindicator 0]
    $ssl_ind configure -relief flat
    DynamicHelp::register $ssl_ind balloon [::msgcat::mc "Disconnected"]
    bind $ssl_ind <1> show_ssl_status
}

proc pack_sslinfo_entry {connid g row name text var} {
    global font

    label $g.l$name -text $text
    entry $g.$name -textvariable $var -font $font -width 0
    set bgcolor [$g cget -background]
    if {[info tclversion] >= 8.4} {
	$g.$name configure -state readonly -highlightcolor $bgcolor -takefocus 0
    } else {
	$g.$name configure -state disabled -background $bgcolor
    }

    grid $g.l$name -row $row -column 0 -sticky e
    grid $g.$name  -row $row -column 1 -sticky we
    grid columnconfig $g 1 -weight 1 -minsize 0
}

array set ssl_certificate_fields [list \
    subject   [::msgcat::mc "Subject"] \
    issuer    [::msgcat::mc "Issuer"] \
    notBefore [::msgcat::mc "Begin date"] \
    notAfter  [::msgcat::mc "Expiry date"] \
    serial    [::msgcat::mc "Serial number"] \
    cipher    [::msgcat::mc "Cipher"]]

proc show_ssl_status {} {
    global ssl_certificate_fields

    if {[winfo exists .ssl_info]} {
	destroy .ssl_info
    }

    if {[llength [set conns [jlib::connections]]]} {
	if {[info tclversion] >= 8.4} {
	    set state readonly
	} else {
	    set state disabled
	}
	set server_list {}
	foreach connid $conns {
	    if {[info exists ::jlib::lib($connid,sck)]} {
		if {![catch { tls::status $::jlib::lib($connid,sck) } status]} {
		    global ssl_info_$connid
		    if {![winfo exists .ssl_info]} {
			Dialog .ssl_info -title [::msgcat::mc "SSL Info"] -separator 1 -anchor e \
			        -default 0 -cancel 0 -modal none
			.ssl_info add -text [::msgcat::mc "Close"] -command "destroy .ssl_info"
			set fr [.ssl_info getframe]
		    }
		    set server [server_from_jid [jlib::connection_jid $connid]]
		    if {[lcontain $server_list $server]} {
			continue
		    } else {
			lappend server_list $server
		    }
		    if {[llength $server_list] > 1} {
			if {![winfo exists $fr.nb]} {
			    set nb [NoteBook $fr.nb]
			    pack $nb -expand yes -fill both -padx 0m -pady 0m
			    set firstpage [$nb insert end page -text [lindex $server_list 0]]
			    pack $fr.page -expand yes -fill both -in $firstpage
			    raise $fr.page
			    $nb raise page
			}
			set page [$nb insert end page$connid -text $server]
		    } else {
			set page [frame $fr.page]
		    }
		    label $page.title -text [format [::msgcat::mc "%s SSL Certificate Info"] $server]
		    grid $page.title -row 0 -column 0 -sticky ew
		    set info {}
		    foreach {k v} $status {
		        if {![cequal $ ""] && [info exists ssl_certificate_fields($k)]} {
			    append info \
				[format "%s: %s\n" $ssl_certificate_fields($k) $v]
			}
		    }
		    grid [message $page.info -aspect 50000 -text [string trim $info]] \
			-row 1 -column 0 -sticky ew
		}
	    }
	}
	if {[winfo exists .ssl_info]} {
	    if {[winfo exists $fr.nb]} {
		$fr.nb compute_size
	    } else {
		pack $fr.page -expand yes -fill both -padx 1m -pady 1m
	    }
	    .ssl_info draw
	}
    }
}

proc update_ssl_ind {} {
    global ssl_ind use_ssl
    global tls_warning_info

    set state disabled
    set len [llength [set conns [jlib::connections]]]
    label .fake_label
    set fg [.fake_label cget -foreground]
    destroy .fake_label
    if {$len} {
	set balloon ""
	foreach connid $conns {
	    if {$len > 1} {
		append balloon "[jlib::connection_jid $connid]: "
	    }
	    if {[info exists use_ssl($connid)] && $use_ssl($connid) && \
		    [info exists ::jlib::lib($connid,sck)]} {
		set sock $::jlib::lib($connid,sck)
		if {![info exists tls_warning_info($sock)] ||
			 [cequal $tls_warning_info($sock) ""]} {
		    append balloon [::msgcat::mc "Enabled\n"]
		} else {
		    append balloon $tls_warning_info($sock)
		    set fg [option get $ssl_ind errorForeground Label]
		}
		set state normal
	    } else {
		append balloon [::msgcat::mc "Disabled\n"]
	    }
	}
    } else {
	set balloon [::msgcat::mc "Disconnected"]
    }
    $ssl_ind configure -state $state
    if {[cequal $state normal]} {
	$ssl_ind configure -foreground $fg
    }
    DynamicHelp::register $ssl_ind balloon [string trim $balloon]
}

pack $mf -expand yes -fill both
unset descmenu

bind $mf <Destroy> {
    jlib::disconnect
    quit
}

set bbox [ButtonBox [$mf addtoolbar].bbox -spacing 0 -padx 1 -pady 1]

$bbox add -image $toolbaricon(newuser) \
    -highlightthickness 0 -takefocus 0 -relief link -borderwidth 1 \
    -padx 1 -pady 1 -command message::send_subscribe_dialog \
    -helptext [::msgcat::mc "Add new user..."]
$bbox add -image $toolbaricon(jb) \
    -highlightthickness 0 -takefocus 0 -relief link -borderwidth 1 \
    -padx 1 -pady 1 -command {browser::open} \
    -helptext [::msgcat::mc "Jabber Browser"]
$bbox add -image $toolbaricon(groupchat) \
    -highlightthickness 0 -takefocus 0 -relief link -borderwidth 1 \
    -padx 1 -pady 1 -command {join_group_dialog} \
    -helptext [::msgcat::mc "Join group..."]
if {$roster::show_only_online} {
    set button_image $toolbaricon(online)
} else {
    set button_image $toolbaricon(offline)
}
$bbox add -image $button_image \
    -highlightthickness 0 -takefocus 0 -relief link -borderwidth 1 \
    -padx 1 -pady 1 -command {roster::switch_only_online} \
    -helptext [::msgcat::mc "Toggle showing offline users"]
unset button_image
if {![cequal [info commands ::ssj::sign:toggleP] ""]} {
    set b $bbox.b[llength [winfo children $bbox]]
    $bbox add -image [message::signed:icon]			\
	-highlightthickness 0 -takefocus 0 -relief link		\
	-borderwidth 1 -padx 1 -pady 1 -helptype balloon	\
	-helptext [::msgcat::mc "Toggle signing"]		\
	-command ssj::sign:toggleP
    ssj::signed:trace "$b configure -image \[message::signed:icon\]"
    unset b
}
if {![cequal [info commands ::ssj::encrypt:toggleP] ""]} {
    set b $bbox.b[llength [winfo children $bbox]]
    $bbox add -image [message::encrypted:icon]				\
	-highlightthickness 0 -takefocus 0 -relief link			\
	-borderwidth 1 -padx 1 -pady 1 -helptype balloon		\
	-helptext [::msgcat::mc "Toggle encryption (when possible)"]    \
	-command ssj::encrypt:toggleP
    ssj::encrypted:trace "$b configure -image \[message::encrypted:icon\]"
    unset b
}
pack $bbox -side left -anchor w


set ww 0
foreach str [list [::msgcat::mc "Online"] \
	[::msgcat::mc "Free to chat"] \
	[::msgcat::mc "Away"] \
	[::msgcat::mc "Extended Away"] \
	[::msgcat::mc "Do not disturb"] \
	[::msgcat::mc "Invisible"] \
	[::msgcat::mc "Not logged in"]] {
    if {[string length $str] > $ww} {
	set ww [string length $str]
    }
}

frame .presence
menubutton .presence.button -menu .presence.button.menu -relief raised \
    -textvariable userstatusdesc -direction above -width $ww
unset str ww
bind [entry .presence.status -textvariable textstatus] \
        <Return> {set userstatus $userstatus}
if {$usetabbar} {
    # pack .presence.button -side left -padx 2m
    pack .presence.button -side left
    pack .presence.status -side left -fill x -expand yes
} else {
    # pack .presence.button -side top -padx 2m -anchor w
    pack .presence.button -side top -anchor w
    pack .presence.status -side top -fill x -expand yes -anchor w
}
pack .presence -side bottom -anchor w -in [$mf getframe] -fill x

if {[winfo exists [set m $w.presence.button.menu]]} {
    destroy $m
}
menu $m
$m add command -label [::msgcat::mc "Online"] \
    -command {set userstatus available}
$m add command -label [::msgcat::mc "Free to chat"] \
    -command {set userstatus chat}
$m add command -label [::msgcat::mc "Away"] \
    -command {set userstatus away}
$m add command -label [::msgcat::mc "Extended Away"] \
    -command {set userstatus xa}
$m add command -label [::msgcat::mc "Do not disturb"] \
    -command {set userstatus dnd}
$m add command -label [::msgcat::mc "Invisible"] \
    -command {set userstatus invisible}

set rosterwidth [option get . mainRosterWidth [winfo class .]]
if {$rosterwidth == ""} {
    set rosterwidth [winfo pixels . 4c]
}

if {$usetabbar} {
    set pw [PanedWin [$mf getframe].pw -side bottom -pad 2 -width 8]
    pack $pw -fill both -expand yes
    set rw [$pw add -minsize 0 -weight 0]
    set nw [$pw add -minsize 32 -weight 1]

    roster::create $w.roster -width $rosterwidth -height 300 \
	-popup roster::popup_menu \
	-grouppopup roster::group_popup_menu
    pack $w.roster -expand yes -fill both -side left -in $rw

    NoteBook .nb -width 400
    pack .nb -side right -in $nw -fill both -expand yes
    [winfo parent $rw] configure -width $rosterwidth

    bind . <Control-Key-r> {collapse_roster}
    bind . <Control-Prior> {tab_move .nb -1}
    bind . <Control-Next> {tab_move .nb 1}
    bind . <Control-Meta-Prior> {current_tab_move .nb -1}
    bind . <Control-Alt-Prior>  {current_tab_move .nb -1}
    bind . <Control-Meta-Next>  {current_tab_move .nb  1}
    bind . <Control-Alt-Next>   {current_tab_move .nb  1}
    bind . <Control-Key-F4> {
	if {[.nb raise] != ""} {
	    eval destroy [pack slaves [.nb getframe [.nb raise]]]
	    .nb delete [.nb raise] 1
	    tab_move .nb 0
	}
    }

    for {set i 1} {$i < 10} {incr i} {
	bind . <Meta-Key-$i> [list tab_raise_by_number .nb $i]
	bind . <Alt-Key-$i> [list tab_raise_by_number .nb $i]
    }
    unset i
    bind . <Meta-Key-0> [list tab_raise_by_number .nb 10]
    bind . <Alt-Key-0> [list tab_raise_by_number .nb 10]

    set m [menu .tabsmenu -tearoff 0]
    $m add command -label [::msgcat::mc "Close"] -accelerator Ctrl-F4 \
	-command {
	    if {[.nb raise] != ""} {
		eval destroy [pack slaves [.nb getframe $curmenutab]]
		.nb delete $curmenutab 1
		tab_move .nb 0
	    }
	}
    $m add command -label [::msgcat::mc "Close other tabs"] \
	-command {
	    foreach tab [.nb pages] {
		if {$tab != $curmenutab} {
		    eval destroy [pack slaves [.nb getframe $tab]]
		    .nb delete $tab 1
		}
	    }
	    tab_move .nb 0
	}
    $m add command -label [::msgcat::mc "Close all tabs"] \
	-command {
	    foreach tab [.nb pages] {
		eval destroy [pack slaves [.nb getframe $tab]]
		.nb delete $tab 1
	    }
	}

    .nb bindtabs <3> {tab_menu %X %Y}

    set geometry [option get . geometry [winfo class .]]
    if {$geometry == ""} {
	set geometry 788x550
    }

    unset pw m
} else {
    roster::create $w.roster -width $rosterwidth -height 300 \
	-popup roster::popup_menu \
	-grouppopup roster::group_popup_menu
    pack $w.roster -expand yes -fill both -side left -in [$mf getframe]
    set geometry [option get . geometry [winfo class .]]
    if {$geometry == ""} {
	set geometry 200x350
    }
}

wm geometry . $geometry

unset mf

if {$usetabbar} {
    bind . <FocusIn> [list ::get_focus .]
    bind . <FocusOut> [list ::loose_focus .]
}

proc nbpage {path} {
    return [crange [win_id tab $path] 1 end]
}

proc update_chat_title {chatid} {
    global usetabbar
    global message_numbers_in_tabs

    set cw $chat::opened($chatid)
    set messages $chat::chats(messages,$chatid)
    if {$usetabbar} {
	set page [nbpage $cw]
	set tabtitlename $chat::chats(tabtitlename,$chatid)
	if {$messages && $message_numbers_in_tabs} {
	    append tabtitlename " ($messages)"
	}
	.nb itemconfigure $page -text $tabtitlename
    } else {
	set star ""
	if {$chat::chats(messagestome,$chatid)} {
	    set star "*"
	}
	if {$messages} {
	    set title "($messages$star) $chat::chats(titlename,$chatid)"
	} else {
	    set title $chat::chats(titlename,$chatid)
	}
	wm title $cw $title
	wm iconname $cw $title
    }
}

proc update_chat_titles {} {
    global usetabbar

    if {![info exists chat::chats(opened)]} return

    foreach chatid $chat::chats(opened) {
	lassign [chat::window_titles $chatid] chat::chats(tabtitlename,$chatid) \
	    chat::chats(titlename,$chatid)
	update_chat_title $chatid
    }
}

proc update_main_window_title {} {
    if {![info exists chat::chats(opened)]} return

    set star ""
    set messages 0
    foreach chatid $chat::chats(opened) {
	incr messages $chat::chats(messages,$chatid)
	if {$chat::chats(messagestome,$chatid)} {
	    set star "*"
	}
    }
    if {$messages} {
	set title "($messages$star) $::main_window_title"
    } else {
	set title $::main_window_title
    }
    wm title . $title
    wm iconname . $title
}

proc add_win {path args} {
    global usetabbar raise_new_tab

    set title ""
    set tabtitle ""
    set class ""
    set raisecmd ""
    set type ""

    foreach {attr val} $args {
	switch -- $attr {
	    -title    {set title    $val}
	    -tabtitle {set tabtitle $val}
	    -class    {set class    $val}
	    -raisecmd {set raisecmd $val}
	    -type     {set type     $val}
	    default {error "Unknown option $attr"}
	}
    }

    if {$usetabbar} {
	set page [nbpage $path]
	set f [.nb insert end $page -text $tabtitle -raisecmd $raisecmd]
	frame $path -class $class
	pack $path -expand yes -fill both -in $f
	#tkwait visibility $path
	set ::tabcolors($page) ""
	if {$raise_new_tab || [llength [.nb pages]] == 1} {
	    after idle [list catch [list .nb raise $page]]
	}
    } else {
	toplevel $path -class $class -relief flat -bd 2m
	wm title $path $title
	wm iconname $path $title
	set geometry [option get $path ${type}geometry $class]
	if {$geometry != ""} {
	    wm geometry $path $geometry
	}
	bind $path <FocusIn> [list ::get_focus $path]
	bind $path <FocusOut> [list ::loose_focus $path]
    }
}

set focused {}
set after_focused_id {}

proc get_focus {path} {
    global focused after_focused_id update_title_delay

    if {![winfo exists $path]} return
    if {[winfo toplevel $path] != $path} return
    if {![cequal $path .] && ![info exists chat::chat_id($path)]} return

    if {$focused != $path} {
	if {$after_focused_id != {}} {
	    after cancel $after_focused_id
	}
	set after_focused_id \
	    [after $update_title_delay [list ::set_title $path]]
	set focused $path
    }
}

proc set_title {path} {
    global usetabbar
    if {![winfo exists $path]} return
    
    if {$usetabbar} {
	if {[set p [.nb raise]] != ""} {
	    tab_set_updated $p
	}
	update_main_window_title
    } else {
	if {[info exists chat::chat_id($path)]} {
	    set chat::chats(messages,$chat::chat_id($path)) 0
	    set chat::chats(messagestome,$chat::chat_id($path)) 0
	    update_chat_title $chat::chat_id($path)
	}
    }
}

proc loose_focus {path} {
    global focused after_focused_id

    if {![winfo exists $path]} return
    if {[winfo toplevel $path] != $path} return

    if {($focused == $path) && ($after_focused_id != {})} {
	after cancel $after_focused_id
	set after_focused_id {}
    }
    set focused {}
    balloon::destroy
}

proc add_number_of_messages_to_title {chatid from type body extras} {
    global usetabbar
    global focused

    set cw [chat::winid $chatid]
    set w [winfo toplevel $cw]
    
    if {[cequal $w $focused] && \
	(!$usetabbar || ([cequal [.nb raise] [nbpage $cw]]))} return

    incr chat::chats(messages,$chatid)
    if {$type == "chat"} {
	set chat::chats(messagestome,$chatid) 1
    } elseif {$type == "groupchat"} {
	set myjid [chat::our_jid $chatid]
	set mynick [chat::get_nick $myjid $type]
	if {[lindex [check_message $mynick $body] 0]} {
	    set chat::chats(messagestome,$chatid) 1
	}
    }
    update_chat_title $chatid
    if {$usetabbar} {
	update_main_window_title
    }
}

hook::add draw_message_hook ::add_number_of_messages_to_title 18

proc tab_move {nb shift} {
    set len [llength [$nb pages]]

    if {$len > 0} {
	set newidx [expr [$nb index [$nb raise]] + $shift]

	if {$newidx < 0} {
	    set newidx [expr $len - 1]
	} elseif {$newidx >= $len} {
	    set newidx 0
	}

	$nb see [lindex [$nb pages] $newidx]
	$nb raise [lindex [$nb pages] $newidx]
    }
}

proc current_tab_move {nb shift} {
    set len [llength [$nb pages]]

    if {$len > 0} {
	set newidx [expr [$nb index [$nb raise]] + $shift]

	if {$newidx < 0} {
	    set newidx [expr $len - 1]
	} elseif {$newidx >= $len} {
	    set newidx 0
	}

	$nb move [$nb raise] $newidx
	$nb see [$nb raise]
    }
}

proc tab_raise_by_number {nb num} {
    set pages [$nb pages]
    incr num -1
    set page [lindex $pages $num]
    if {$page != ""} {
	$nb raise $page
    }
}

if {$usetabbar} {
    array set alert_lvls {info 1 error 1 server 1 message 2 mesg_to_user 3}

    option add *NoteBook.alertColor0 Black widgetDefault
    option add *NoteBook.alertColor1 DarkBlue widgetDefault
    option add *NoteBook.alertColor2 Blue widgetDefault
    option add *NoteBook.alertColor3 Red widgetDefault

    set alert_colors [list \
			  [option get .nb alertColor0 NoteBook] \
			  [option get .nb alertColor1 NoteBook] \
			  [option get .nb alertColor2 NoteBook] \
			  [option get .nb alertColor3 NoteBook]]
    custom::defvar alert_colors [list \
				     [option get .nb alertColor0 NoteBook] \
				     [option get .nb alertColor1 NoteBook] \
				     [option get .nb alertColor2 NoteBook] \
				     [option get .nb alertColor3 NoteBook]] \
	[::msgcat::mc "Colors for tab alert levels."] \
	-group IFace -type string
}

proc tab_set_updated {path {updated 0} {level ""}} {
    global usetabbar
    global tabcolors
    global alert_lvls alert_colors
    global focused

    if {$usetabbar} {
	set page [nbpage $path]
	if {[.nb index $page] < 0} {
	    set page $path
	    set path [pack slaves [.nb getframe $page]]
	}

	set st [wm state .]
	if {(![cequal $st normal] && ![cequal $st zoomed]) \
		|| ([cequal [focus -displayof .] ""])} {
	    set backgroundP 1
	} else {
	    set backgroundP 0
	}
        if {(!$updated) && $backgroundP} {
	    set updated 1
	    set level message
	}

	if {$updated \
		&& (($page != [.nb raise]) \
			&& ([info exists alert_lvls($level)])
		    || $backgroundP)} {
	    set lvlnum $alert_lvls($level)
	} else {
	    set lvlnum 0
	}

	if {!$updated || $tabcolors($page) < $lvlnum} {
	    set color [lindex $alert_colors $lvlnum]
	    .nb itemconfigure $page -foreground $color
	    set tabcolors($page) $lvlnum
	}
	if {[info exists chat::chat_id($path)]} {
	    if {!$updated || ($lvlnum == 0)} {
		set chat::chats(messages,$chat::chat_id($path)) 0
		set chat::chats(messagestome,$chat::chat_id($path)) 0
		update_chat_title $chat::chat_id($path)
		if {$usetabbar} {
		    update_main_window_title
		}
	    }
	}

	#debugmsg iface "$path $updated $page $tabcolors($page) [.nb raise]"
    }
}

proc tab_menu {x y page} {
    global curmenutab
    set curmenutab $page
    tk_popup .tabsmenu $x $y    
}

###############################################################################

proc collapse_roster {} {
    global rw nw
    global rosterwidth
    set r [[winfo parent $rw] cget -width]
    set n [[winfo parent $nw] cget -width]
    if {$r > 0} {
	set rosterwidth $r
	[winfo parent $rw] configure -width 0
	[winfo parent $nw] configure -width [expr {$r + $n}]
    } else {
	[winfo parent $rw] configure -width $rosterwidth
	[winfo parent $nw] configure -width [expr {$r + $n - $rosterwidth}]
    }
}

###############################################################################

set status_afterid ""

proc client:status {text} {
    set_status $text
}

proc set_status {text} {
    global status
    global status_afterid

    after cancel $status_afterid
    set status $text
    set status_afterid [after 5000 clear_status]
}

proc clear_status {} {
    global status

    set status ""
}



