# $Id: iq.tcl,v 1.8 2003/06/29 18:00:17 aleksey Exp $

namespace eval iq {}


proc iq::register_handler {type tag xmlns h} {
    variable handler
    variable supported_ns

    set handler($type,$tag,$xmlns) $h
    lappend supported_ns $xmlns
    set supported_ns [lrmdups $supported_ns]
}

proc iq::process_iq {connid from useid id type child} {
    variable handler

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    set xmlns [jlib::wrapper:getattr $vars xmlns]

    if {[info exists handler($type,$tag,$xmlns)]} {
	set h $handler($type,$tag,$xmlns)
    } elseif {[info exists handler($type,,$xmlns)]} {
	set h $handler($type,,$xmlns)
    }

    if {[info exists h]} {
	set res [$h $connid $from $child]

	if {$res != {}} {
	    switch -- [lindex $res 0] {
		result {
		    debugmsg iq "IQREPLY: SENDING RESULT: $from; $useid; $id; $child"
		    jlib::send_iq result [lindex $res 1] \
			-to $from \
			-connection $connid \
			-id $id
		}
		error {
		    debugmsg iq "IQREPLY: SENDING ERROR: $from; $useid; $id; $child"
		    jlib::send_iq error \
			[eval jlib::error [lrange $res 1 end] -xml {$child}] \
			-to $from \
			-connection $connid \
			-id $id
		}
	    }
	}
    } else {
	debugmsg iq "IQREPLY: SENDING 501: $from; $useid; $id; $child"
	jlib::send_iq error \
	    [jlib::error cancel feature-not-implemented -xml $child] \
	    -to $from \
	    -connection $connid \
	    -id $id
    }
}

proc client:iqreply {connid from useid id type child} {
    debugmsg iq "IQREPLY: $from; $useid; $id; $type; $child"

    iq::process_iq $connid $from $useid $id $type $child
}


plugins::load [file join plugins iq]

