# $Id: privacy.tcl,v 1.7 2003/08/18 19:18:01 aleksey Exp $

namespace eval privacy {}

set ::NS(privacy) jabber:iq:privacy


proc privacy::request_lists {} {
    jlib::send_iq get \
	[jlib::wrapper:createtag query \
	     -vars [list xmlns $::NS(privacy)]] \
	-command [list [namespace current]::open_dialog]
}


proc privacy::open_dialog {res child} {
    variable rf

    if {![cequal $res OK]} {
	MessageDlg .privacy_err -aspect 50000 -icon error \
	    -message [format [::msgcat::mc "Requesting privacy rules: %s"] \
			  [error_to_string $child]] \
	    -type user -buttons ok -default 0 -cancel 0
	return
    }

    set w .privacy

    if {[winfo exists $w]} {
	destroy $w
    }


    Dialog $w -title [::msgcat::mc "Zebra lists"] \
	-separator 1 -anchor e \
	-default 0 -cancel 1

    set f [$w getframe]

    set sw [ScrolledWindow $w.sw]
    set sf [ScrollableFrame $w.fields -constrainedwidth yes]
    pack $sw -side top -expand yes -fill both
    set lf [$sf getframe]
    $sw setwidget $sf

    #set lf1 [frame $lf.lists]
    #pack $lf1 -side top -fill both -expand yes

    jlib::wrapper:splitxml $child tag vars isempty chdata childrens
    fill_lists $lf $childrens

    set tools [frame $f.tools]
    pack $tools -side top -fill x
    
    set addlist [button $tools.addlist \
		     -text [::msgcat::mc "Add list"] \
		     -command [list [namespace current]::add_list $lf "" {}]]
    pack $addlist -side left

    set default [radiobutton $tools.default \
		     -text [::msgcat::mc "No default list"] \
		     -variable [namespace current]::data(default) \
		     -value ""]
    pack $default -side left

    set active [radiobutton $tools.active \
		    -text [::msgcat::mc "No active list"] \
		    -variable [namespace current]::data(active) \
		    -value ""]
    pack $active -side left

    $w add -text [::msgcat::mc "Send"] \
	-command [list [namespace current]::send_lists $w]
    $w add -text [::msgcat::mc "Cancel"] -command [list destroy $w]

    after 1 [list $sw setwidget $sf]
    $w draw
}

proc privacy::fill_lists {f items} {
    variable data

    set data(active) ""
    set data(default) ""
    set data(nlists) 0
    set i 0
    foreach item $items {
	jlib::wrapper:splitxml $item tag vars isempty chdata childrens
	switch -- x$tag {
	    xdefault {
		set data(default) [jlib::wrapper:getattr $vars name]
	    }
	    xactive {
		set data(active) [jlib::wrapper:getattr $vars name]
	    }
	    xlist {
		set name [jlib::wrapper:getattr $vars name]

		add_list $f $name $childrens
	    }
	}
    }
}

proc privacy::fill_list {f ln items} {
    variable data

    set data(nitems,$ln) 0

    label $f.ltype   -text [::msgcat::mc "Type:"]
    label $f.lvalue  -text [::msgcat::mc "Value:"]
    label $f.laction -text [::msgcat::mc "Action:"]
    grid $f.ltype   -row 0 -column 0 -sticky w
    grid $f.lvalue  -row 0 -column 1 -sticky w
    grid $f.laction -row 0 -column 2 -sticky w
    grid columnconfig $f 1 -weight 1

    foreach item $items {
	jlib::wrapper:splitxml $item tag vars isempty chdata childrens

	set type   [jlib::wrapper:getattr $vars type]
	set value  [jlib::wrapper:getattr $vars value]
	set action [jlib::wrapper:getattr $vars action]
	set order  [jlib::wrapper:getattr $vars order]

	add_item $f $ln $type $value $action
    }
}


proc privacy::remove_list {tf ln} {
    variable data

    destroy $tf
    set data(nitems,$ln) 0
    set data(newname,$ln) ""
}

proc privacy::add_list {f name childrens} {
    variable data

    set i $data(nlists)

    if {$name == ""} {
	set name "list$i"
    }

    set data(name,$i) $name
    set data(newname,$i) $name

    set tf [TitleFrame $f.list$i \
		-text [format [::msgcat::mc "Zebra list: %s"] $name] \
		-borderwidth 2 \
		-relief groove]
    pack $tf -side top -fill x
    set lf [$tf getframe]
    #set itemsf [frame $lf.items]
    #pack $itemsf -side bottom -fill both -expand yes
    #fill_list $itemsf $i $childrens

    set active [radiobutton $lf.active \
		    -text [::msgcat::mc "Active"] \
		    -variable [namespace current]::data(active) \
		    -value $name]
    pack $active -side top -anchor w
    
    set default [radiobutton $lf.default \
		     -text [::msgcat::mc "Default"] \
		     -variable [namespace current]::data(default) \
		     -value $name]
    pack $default -side top -anchor w
    
    set edit [button $lf.edit \
		  -text [::msgcat::mc "Edit list"] \
		  -command [list [namespace current]::edit_list $tf $i]]
    pack $edit -side top -anchor w
    
    set remove [button $lf.remove \
		    -text [::msgcat::mc "Remove list"] \
		    -command \
		    [list [namespace current]::remove_list \
			 $tf $i]]
    pack $remove -side top -anchor w
    
    incr data(nlists)
}


proc privacy::edit_list {tf ln} {
    variable data

    set name $data(name,$ln)

    jlib::send_iq get \
	[jlib::wrapper:createtag query \
	     -vars [list xmlns $::NS(privacy)] \
	     -subtags [list [jlib::wrapper:createtag list \
				 -vars [list name $name]]]] \
	-command [list [namespace current]::edit_list_dialog $name]
}


proc privacy::edit_list_dialog {name res child} {
    variable rf

    if {![cequal $res OK]} {
	MessageDlg .privacy_list_err -aspect 50000 -icon error \
	    -message [format [::msgcat::mc "Requesting privacy list: %s"] \
			  [error_to_string $child]] \
	    -type user -buttons ok -default 0 -cancel 0
	set child [jlib::wrapper:createtag query \
		       -vars [list xmlns $::NS(privacy)] \
		       -subtags [list [jlib::wrapper:createtag list \
					   -vars [list name $name]]]]
    }

    set w .privacy_list

    if {[winfo exists $w]} {
	destroy $w
    }


    Dialog $w -title [::msgcat::mc "Zebra lists"] \
	-separator 1 -anchor e \
	-default 0 -cancel 1

    set f [$w getframe]

    set sw [ScrolledWindow $w.sw]
    set sf [ScrollableFrame $w.fields -constrainedwidth yes]
    set lf [$sf getframe]
    pack $sw -side top -expand yes -fill both
    $sw setwidget $sf

    #set lf1 [frame $lf.lists]
    #pack $lf1 -side top -fill both -expand yes

    jlib::wrapper:splitxml $child tag vars isempty chdata childrens
    fill_edit_lists $lf $childrens

    $w add -text [::msgcat::mc "Send"] \
	-command [list [namespace current]::send_list $w]
    $w add -text [::msgcat::mc "Cancel"] -command [list destroy $w]

    after 1 [list $sw setwidget $sf]
    $w draw
}



proc privacy::fill_edit_lists {f items} {
    variable data

    set i 0
    set item [lindex $items 0]
    if {$item != ""} {
	jlib::wrapper:splitxml $item tag vars isempty chdata childrens
	if {$tag == "list"} {
	    set name [jlib::wrapper:getattr $vars name]
	    add_edit_list $f $name $childrens
	}
    }
}

proc privacy::add_edit_list {f name childrens} {
    variable data

    set data(listname) $name
    set data(listnewname) $name

    set tf [TitleFrame $f.list \
		-text [format [::msgcat::mc "Zebra list: %s"] $name] \
		-borderwidth 2 \
		-relief groove]
    pack $tf -side top -fill x
    set lf [$tf getframe]
    set itemsf [frame $lf.items]
    pack $itemsf -side bottom -fill both -expand yes
    fill_edit_list $itemsf $childrens

    set additem [button $lf.aditem \
		     -text [::msgcat::mc "Add item"] \
		     -command \
		     [list [namespace current]::add_item \
			  $itemsf "none" "" "allow"]]
    pack $additem -side top -anchor w
    
    label $lf.lname -text [string trimright [::msgcat::mc "Name: "]]
    entry $lf.name \
	-textvariable [namespace current]::data(listnewname)
    pack $lf.lname -side left -anchor w
    pack $lf.name -side left -fill x -expand yes
}

proc privacy::fill_edit_list {f items} {
    variable data

    set data(listnitems) 0

    label $f.ltype   -text [::msgcat::mc "Type:"]
    label $f.lvalue  -text [::msgcat::mc "Value:"]
    label $f.laction -text [::msgcat::mc "Action:"]
    grid $f.ltype   -row 0 -column 0 -sticky w
    grid $f.lvalue  -row 0 -column 1 -sticky w
    grid $f.laction -row 0 -column 2 -sticky w
    grid columnconfig $f 1 -weight 1

    foreach item $items {
	jlib::wrapper:splitxml $item tag vars isempty chdata childrens

	set type   [jlib::wrapper:getattr $vars type]
	set value  [jlib::wrapper:getattr $vars value]
	set action [jlib::wrapper:getattr $vars action]
	set order  [jlib::wrapper:getattr $vars order]

	add_item $f $type $value $action
    }
}


proc privacy::add_item {f type value action} {
    variable data

    set i $data(listnitems)

    set data(type,$i)   $type
    set data(value,$i)  $value
    set data(action,$i) $action

    entry $f.value$i \
	-textvariable [namespace current]::data(value,$i)
    tk_optionMenu $f.type$i \
	[namespace current]::data(type,$i) \
	none jid group subscription
    tk_optionMenu $f.action$i \
	[namespace current]::data(action,$i) \
	allow deny
    button $f.remove$i -text [::msgcat::mc "Remove"] \
	-command [list [namespace current]::remove_item $f $i]

    set row [expr {$i + 1}]
    grid $f.type$i   -row $row -column 0 -sticky ew
    grid $f.value$i  -row $row -column 1 -sticky ew
    grid $f.action$i -row $row -column 2 -sticky ew
    grid $f.remove$i -row $row -column 3 -sticky ew

    incr data(listnitems)
}

proc privacy::remove_item {f i} {
    variable data

    destroy $f.type$i
    destroy $f.value$i
    destroy $f.action$i
    destroy $f.remove$i

    set data(type,$i) remove
    set data(value,$i) ""
    set data(action,$i) allow
}


proc privacy::send_list {w} {
    variable data

    set name $data(listnewname)
    set litems [list_items]
    set items [list [jlib::wrapper:createtag list \
			 -vars [list name $name] \
			 -subtags $litems]]
    jlib::send_iq set \
	[jlib::wrapper:createtag query \
	     -vars [list xmlns $::NS(privacy)] \
	     -subtags $items]

    if {$name != $data(listname)} {
	if {$data(default) == $data(listname)} {
	    set items [list [jlib::wrapper:createtag default \
				 -vars [list name $name]]]
	    jlib::send_iq set \
		[jlib::wrapper:createtag query \
		     -vars [list xmlns $::NS(privacy)] \
		     -subtags $items]
	}

	set items [list [jlib::wrapper:createtag list \
			     -vars [list name $data(listname)]]]
	jlib::send_iq set \
	    [jlib::wrapper:createtag query \
		 -vars [list xmlns $::NS(privacy)] \
		 -subtags $items]
    }
    

    destroy $w
}


proc privacy::send_lists {w} {
    variable data

    for {set i 0} {$i < $data(nlists)} {incr i} {
        if {$data(newname,$i) == ""} {
            set items [list [jlib::wrapper:createtag list \
                                 -vars [list name $data(name,$i)]]]
            jlib::send_iq set \
                [jlib::wrapper:createtag query \
                     -vars [list xmlns $::NS(privacy)] \
                     -subtags $items]
        }
    }

    if {$data(active) != ""} {
	set items [list [jlib::wrapper:createtag active \
			     -vars [list name $data(active)]]]
    } else {
	set items [list [jlib::wrapper:createtag active]]
    }
    jlib::send_iq set \
	[jlib::wrapper:createtag query \
	     -vars [list xmlns $::NS(privacy)] \
	     -subtags $items]

    if {$data(default) != ""} {
	set items [list [jlib::wrapper:createtag default \
			     -vars [list name $data(default)]]]
    } else {
	set items [list [jlib::wrapper:createtag default]]
    }
    jlib::send_iq set \
	[jlib::wrapper:createtag query \
	     -vars [list xmlns $::NS(privacy)] \
	     -subtags $items]
    destroy $w
}

proc privacy::list_items {} {
    variable data

    set items {}
    for {set i 0} {$i < $data(listnitems)} {incr i} {
	if {$data(type,$i) == "remove"} continue

	set vars [list action $data(action,$i) order $i]
	if {$data(type,$i) != "none"} {
	    lappend vars type $data(type,$i) value $data(value,$i)
	}
	lappend items [jlib::wrapper:createtag item \
			   -vars $vars]
    }
    return $items
}

