# $Id: ilogin.tcl,v 1.12 2005/06/22 02:56:27 aleksey Exp $

proc update_login_entries {l {i 0}} {
    global ltmp

    if {$i} {
        array set ltmp [array get ::loginconf$i]
    }
    foreach ent {username server port password resource priority \
            altserver sslport httpproxy httpproxyport httplogin httppassword \
            sslcertfile pollurl} {
        if {[winfo exists $l.$ent]} {
            catch { $l.$ent icursor end }
        }
    }
    foreach {check enable disable} { \
            usehttppoll {lpollurl pollurl usepollkeys} \
			{dontusessl legacyssl starttls sslport lsslport \
			 sslcertfile lsslcertfile bsslcertfile} \
            usealtserver {altserver laltserver} {} \
            useproxy {httpproxy httpproxyport httplogin httppassword \
            lhttpproxy lhttpproxyport lhttplogin lhttppassword} {} \
            usesasl {allowsaslplain} {} \
	    } {
        if {![info exists ltmp($check)] || ![winfo exists $l.$check]} {
            continue
        }

        if {$ltmp($check) && ![cequal [$l.$check cget -state] disabled]} {
            set state1 normal
            set state2 disabled
        } else {
            set state1 disabled
            set state2 normal
        }
        foreach ent $enable {
            if {[winfo exists $l.$ent]} {
                $l.$ent configure -state $state1
                if {[cequal [focus] $l.$ent] && [cequal $state1 "disabled"]} {
                    focus [Widget::focusPrev $l.$ent]
                }
            }
        }
        foreach ent $disable {
            if {[winfo exists $l.$ent]} {
                $l.$ent configure -state $state2
                if {[cequal [focus] $l.$ent] && [cequal $state2 "disabled"]} {
                    focus [Widget::focusPrev $l.$ent]
                }
	    }
	}
    }
    catch {
	if {$ltmp(usessl) == 1 && \
		![cequal [$l.starttls cget -state] disabled]} {
	    $l.sslport configure -state normal
	    $l.lsslport configure -state normal
	} else {
	    $l.sslport configure -state disabled
	    $l.lsslport configure -state disabled
	    if {[cequal [focus] $l.sslport]} {
		focus [Widget::focusPrev $l.sslport]
	    }
	}
	if {$ltmp(usessl) != 0} {
	    $l.sslcertfile configure -state normal
	    $l.lsslcertfile configure -state normal
	    $l.bsslcertfile configure -state normal
	} else {
	    $l.sslcertfile configure -state disabled
	    $l.lsslcertfile configure -state disabled
	    $l.bsslcertfile configure -state disabled
	    if {[cequal [focus] $l.sslcertfile] || \
		    [cequal [focus] $l.bsslcertfile]} {
		focus [Widget::focusPrev $l.sslcertfile]
	    }
	}
    }
}

proc login_dialog {} {
    global loginconf
    global ltmp
    global use_tls have_sasl have_http_poll have_proxy

    if {[winfo exists .login]} {
	focus -force .login
	return
    }

    array set ltmp [array get loginconf]

    Dialog .login -title [::msgcat::mc "Login"] \
	-separator 1 -anchor e -default 0 -cancel 1

    wm resizable .login 0 0

    set l [.login getframe]

    set n 1
    while {[info exists ::loginconf$n]} {incr n}
    incr n -1

    if {$n} {
	menubutton $l.profiles -text [::msgcat::mc "Profiles"] \
	    -relief $::tk_relief -menu $l.profiles.menu
	set m [menu $l.profiles.menu -tearoff 0]
	for {set i 1} {$i <= $n} {incr i} {
	    if {[info exists ::loginconf${i}(profile)]} {
		set lab [set ::loginconf${i}(profile)]
	    } else {
		set lab "[::msgcat::mc Profile] $i"
	    }
	    if {$i <= 10} {
		set j [expr {$i % 10}]
		$m add command -label $lab -accelerator "$::tk_modify-$j" \
		    -command [list [namespace current]::update_login_entries $l $i]
		bind .login <Control-Key-$j> \
		    [list [namespace current]::update_login_entries $l $i]
	    } else {
		$m add command -label $lab \
		    -command [list [namespace current]::update_login_entries $l $i]
	    }
	}

	grid $l.profiles -row 0 -column 0 -sticky e
    }

    set nb [NoteBook $l.nb]

    set account_page [$nb insert end account_page -text [::msgcat::mc "Account"]]

    label $l.lusername -text [::msgcat::mc "Username:"]
    entry $l.username -textvariable ltmp(user)
    label $l.lserver -text [::msgcat::mc "Server:"]
    entry $l.server -textvariable ltmp(server)
    label $l.lpassword -text [::msgcat::mc "Password:"]
    entry $l.password -show * -textvariable ltmp(password)
    checkbutton $l.usedigest -text [::msgcat::mc "Use hashed password"] \
	-variable ltmp(usedigest)
    label $l.lresource -text [::msgcat::mc "Resource:"]
    entry $l.resource -textvariable ltmp(resource)
    label $l.lpriority -text [::msgcat::mc "Priority:"]
    Spinbox $l.priority -1000 1000 1 ltmp(priority)

    grid $l.lusername -row 0 -column 0 -sticky e -in $account_page
    grid $l.username  -row 0 -column 1 -sticky ew -in $account_page
    grid $l.lserver   -row 0 -column 2 -sticky e -in $account_page
    grid $l.server    -row 0 -column 3 -sticky ew -in $account_page
    grid $l.lpassword -row 1 -column 0 -sticky e -in $account_page
    grid $l.password  -row 1 -column 1 -sticky ew -in $account_page
    grid $l.usedigest -row 1 -column 3 -sticky w -in $account_page
    grid $l.lresource -row 2 -column 0 -sticky e -in $account_page
    grid $l.resource  -row 2 -column 1 -sticky ew -in $account_page
    grid $l.lpriority -row 2 -column 2 -sticky e -in $account_page
    grid $l.priority  -row 2 -column 3 -sticky ew -in $account_page

    grid columnconfigure $account_page 1 -weight 3
    grid columnconfigure $account_page 2 -weight 1
    grid columnconfigure $account_page 3 -weight 3

    set connection_page [$nb insert end connection_page -text [::msgcat::mc "Connection"]]

    label $l.lport -text [::msgcat::mc "Server Port:"]
    Spinbox $l.port 0 65535 1 ltmp(port)
    checkbutton $l.usealtserver -text [::msgcat::mc "Connect via alternate server"] \
	-variable ltmp(usealtserver) \
	-command [list [namespace current]::update_login_entries $l]
    label $l.laltserver -text [::msgcat::mc "Server:"]
    entry $l.altserver -textvariable ltmp(altserver)

    grid $l.lport     -row 0 -column 0 -sticky e -in $connection_page
    grid $l.port      -row 0 -column 1 -sticky w -in $connection_page
    grid $l.usealtserver -row 1 -column 0 -sticky w -columnspan 2 -in $connection_page
    grid $l.laltserver -row 1 -column 2 -sticky e -in $connection_page
    grid $l.altserver -row 1 -column 3 -sticky ew -in $connection_page

    checkbutton $l.replace -text [::msgcat::mc "Replace opened connections"] \
	-variable ltmp(replace_opened)
    grid $l.replace   -row 3 -column 0 -sticky w -columnspan 3 -in $connection_page

    grid columnconfigure $connection_page 1 -weight 1
    grid columnconfigure $connection_page 3 -weight 2

    if {$use_tls} {
	set ssl_page [$nb insert end ssl_page -text [::msgcat::mc "SSL"]]

	radiobutton $l.dontusessl -text [::msgcat::mc "Don't use SSL"] \
	    -variable ltmp(usessl) -value 0 \
	    -command [list [namespace current]::update_login_entries $l]
	radiobutton $l.legacyssl -text [::msgcat::mc "Use legacy SSL"] \
	    -variable ltmp(usessl) -value 1 \
	    -command [list [namespace current]::update_login_entries $l]
	radiobutton $l.starttls -text [::msgcat::mc "Use STARTTLS"] \
	    -variable ltmp(usessl) -value 2 \
	    -command [list [namespace current]::update_login_entries $l]
	label $l.lsslport -text [::msgcat::mc "SSL Port:"]
	Spinbox $l.sslport 0 65535 1 ltmp(sslport)
	label $l.lsslcertfile -text [::msgcat::mc "SSL Certificate:"]
	entry $l.sslcertfile -textvariable ltmp(sslcertfile)
	button $l.bsslcertfile -text [::msgcat::mc "Browse..."] \
	    -command [list eval set ltmp(sslcertfile) {[tk_getOpenFile]}]


	grid $l.dontusessl   -row 0 -column 0 -sticky w -in $ssl_page
	grid $l.legacyssl    -row 0 -column 1 -sticky w -in $ssl_page
	grid $l.starttls     -row 0 -column 2 -sticky w -in $ssl_page
	grid $l.lsslport     -row 1 -column 0 -sticky e -in $ssl_page
	grid $l.sslport      -row 1 -column 1 -sticky w -in $ssl_page
	grid $l.lsslcertfile -row 2 -column 0 -sticky e -in $ssl_page
	grid $l.sslcertfile  -row 2 -column 1 -sticky ew -columnspan 2 -in $ssl_page
	grid $l.bsslcertfile -row 2 -column 3 -sticky w -in $ssl_page

	grid columnconfigure $ssl_page 0 -weight 1
	grid columnconfigure $ssl_page 1 -weight 6
	grid columnconfigure $ssl_page 2 -weight 6
	grid columnconfigure $ssl_page 3 -weight 1
    }

    if {$have_proxy} {
	set proxy_page [$nb insert end proxy_page -text [::msgcat::mc "Proxy"]]

	checkbutton $l.useproxy -text [::msgcat::mc "Use Proxy"] \
	    -variable ltmp(useproxy) \
	    -command [list [namespace current]::update_login_entries $l]
	grid $l.useproxy -row 0 -column 0 -sticky w -columnspan 3 -in $proxy_page

	label $l.lhttpproxy -text [::msgcat::mc "Proxy Server:"]
	entry $l.httpproxy -textvariable ltmp(httpproxy)
	label $l.lhttpproxyport -text [::msgcat::mc "Proxy Port:"]
	Spinbox $l.httpproxyport 0 65535 1 ltmp(httpproxyport)

	grid $l.lhttpproxy     -row 1 -column 0 -sticky e -in $proxy_page
	grid $l.httpproxy      -row 1 -column 1 -sticky ew -in $proxy_page
	grid $l.lhttpproxyport -row 1 -column 2 -sticky e -in $proxy_page
	grid $l.httpproxyport  -row 1 -column 3 -sticky ew -in $proxy_page

	label $l.lhttplogin -text [::msgcat::mc "Proxy Login:"]
	ecursor_entry [entry $l.httplogin -textvariable ltmp(httplogin)]
	label $l.lhttppassword -text [::msgcat::mc "Proxy Password:"]
	ecursor_entry [entry $l.httppassword -show * -textvariable ltmp(httppassword)]

	grid $l.lhttplogin    -row 2 -column 0 -sticky e -in $proxy_page
	grid $l.httplogin     -row 2 -column 1 -sticky ew -in $proxy_page
	grid $l.lhttppassword -row 2 -column 2 -sticky e -in $proxy_page
	grid $l.httppassword  -row 2 -column 3 -sticky ew -in $proxy_page
    }

    if {$have_http_poll} {
	set httppoll_page [$nb insert end httpoll_page -text [::msgcat::mc "HTTP Poll"]]

	checkbutton $l.usehttppoll -text [::msgcat::mc "Connect via HTTP polling"] \
	    -variable ltmp(usehttppoll) \
	    -command [list [namespace current]::update_login_entries $l]
	label $l.lpollurl -text [::msgcat::mc "URL to poll:"]
	entry $l.pollurl -textvariable ltmp(pollurl)
	checkbutton $l.usepollkeys -text [::msgcat::mc "Use client security keys"] \
	    -state disabled \
	    -variable ltmp(usepollkeys) \
	    -command [list [namespace current]::update_login_entries $l]
    
	grid $l.usehttppoll -row 0 -column 0 -sticky w -columnspan 3 -in $httppoll_page
	grid $l.lpollurl -row 1 -column 0 -sticky e -in $httppoll_page
	grid $l.pollurl -row 1 -column 1 -sticky ew -in $httppoll_page
	grid $l.usepollkeys -row 2 -column 0 -sticky w -columnspan 3 -in $httppoll_page

	grid columnconfigure $httppoll_page 1 -weight 1
    }
    
    if {$have_sasl} {
	set sasl_page [$nb insert end sasl_page -text [::msgcat::mc "SASL"]]

	checkbutton $l.usesasl \
	    -text [::msgcat::mc "Use SASL authentication"] \
	    -variable ltmp(usesasl) \
	    -command [list [namespace current]::update_login_entries $l]
	checkbutton $l.allowsaslplain \
	    -text [::msgcat::mc "Allow plaintext SASL mechanisms"] \
	    -variable ltmp(allowsaslplain) \
	    -command [list [namespace current]::update_login_entries $l]
	#label $l.lsaslport -text [::msgcat::mc "SASL Port:"]
	#Spinbox $l.saslport 0 65535 1 ltmp(saslport)
	#label $l.lsaslcertfile -text [::msgcat::mc "SASL Certificate:"] -state disabled
	#entry $l.saslcertfile -textvariable ltmp(saslcertfile) -state disabled
	#button $l.bsaslcertfile -text [::msgcat::mc "Browse..."] -state disabled \
	#    -command [list eval set ltmp(saslcertfile) {[tk_getOpenFile]}]


	grid $l.usesasl        -row 0 -column 0 -sticky w -columnspan 3 -in $sasl_page
	grid $l.allowsaslplain -row 1 -column 0 -sticky w -columnspan 3 -in $sasl_page
	#grid $l.lsaslport     -row 1 -column 0 -sticky e -in $sasl_page
	#grid $l.saslport      -row 1 -column 1 -sticky w -in $sasl_page
	#grid $l.lsaslcertfile -row 2 -column 0 -sticky e -in $sasl_page
	#grid $l.saslcertfile  -row 2 -column 1 -sticky ew -in $sasl_page
	#grid $l.bsaslcertfile -row 2 -column 2 -sticky w -in $sasl_page

	grid columnconfigure $sasl_page 0 -weight 1
	grid columnconfigure $sasl_page 1 -weight 6
	grid columnconfigure $sasl_page 2 -weight 1
    }

    $nb compute_size
    $nb raise account_page
    bind .login <Control-Prior> [list [namespace current]::tab_move $nb -1]
    bind .login <Control-Next> [list [namespace current]::tab_move $nb 1]
    grid $nb -row 1 -column 0

    .login add -text [::msgcat::mc "Log in"] -command {
	array set loginconf [array get ltmp]
	destroy .login
	if {$loginconf(replace_opened)} {
	    logout
	}
	update 
	login [array get loginconf]
    }
    .login add -text [::msgcat::mc "Cancel"] -command {destroy .login}

    update_login_entries $l

    if {[cequal $ltmp(user) ""]} {
	.login draw $l.username
    } elseif {[cequal $ltmp(password) ""]} {
	.login draw $l.password
    } else {
	.login draw $l.resource
    }
}

hook::add finload_hook {
    if {(![info exist ::autologin]) || ($::autologin == 0)} {
        ifacetk::login_dialog
    } elseif {$::autologin > 0} {
	logout
	update
	login [array get ::loginconf]
    }
} 9999

proc logout_dialog {} {
    global logout_conn
    
    set w .logout
    if {[winfo exists $w]} {
	destroy $w
    }

    switch -- [llength [jlib::connections]] {
	0 {
	    return
	}
	1 {
	    logout
	    return
	}
    }

    set lnames {}
    foreach connid [jlib::connections] {
	lappend lnames $connid [jlib::connection_jid $connid]
    }

    if {[CbDialog $w [::msgcat::mc "Logout"] \
	    [list [::msgcat::mc "Log out"] [list $w enddialog 0] \
		  [::msgcat::mc "Cancel"] [list $w enddialog 1]] \
	    logout_conn $lnames {} -modal local] != 0} {
	return
    }

    foreach connid [array names logout_conn] {
	if {[lcontain [jlib::connections] $connid] && $logout_conn($connid)} {
	    logout $connid
	}
    }
}

# TODO
proc change_password_dialog {} {
    global oldpassword newpassword password

    set oldpassword ""
    set newpassword ""
    set password ""

    if {[winfo exists .passwordchange]} {
	destroy .passwordchange
    }
    
    Dialog .passwordchange -title [::msgcat::mc "Change password"] \
	-separator 1 -anchor e -default 0 -cancel 1

    .passwordchange add -text [::msgcat::mc "OK"] -command {
	destroy .passwordchange
	send_change_password
    }
    .passwordchange add -text [::msgcat::mc "Cancel"] -command [list destroy .passwordchange]


    set p [.passwordchange getframe]
    
    label $p.loldpass -text [::msgcat::mc "Old password:"]
    ecursor_entry [entry $p.oldpass -show * -textvariable oldpassword]
    label $p.lnewpass -text [::msgcat::mc "New password:"]
    ecursor_entry [entry $p.newpass -show * -textvariable newpassword]
    label $p.lpassword -text [::msgcat::mc "Repeat new password:"]
    ecursor_entry [entry $p.password -show * -textvariable password]

    grid $p.loldpass  -row 0 -column 0 -sticky e
    grid $p.oldpass   -row 0 -column 1 -sticky ew
    grid $p.lnewpass  -row 1 -column 0 -sticky e
    grid $p.newpass   -row 1 -column 1 -sticky ew
    grid $p.lpassword -row 2 -column 0 -sticky e
    grid $p.password  -row 2 -column 1 -sticky ew

    focus $p.oldpass
    .passwordchange draw

}

