# $Id: plugins.tcl,v 1.8 2005/03/03 01:55:50 aleksey Exp $

namespace eval plugins {}

proc plugins::load {dir args} {
    set dir [fullpath $dir]
    set uplev 0
    foreach {attr val} $args {
	switch -- $attr {
	    -uplevel {set uplev $val}
	}
    }

    foreach file [glob -nocomplain $dir/*.tcl] {
	debugmsg plugins "Loading plugin from $file"
	if {$uplev} {
	    uplevel [list source $file]
	} else {
	    source $file
	}
    }
}

proc plugins::load_dir {plugins_dir} {
    foreach dir [lsort [glob -nocomplain [file join $plugins_dir *]]] {
	set file [file join $dir [file tail $dir].tcl]
	debugmsg plugins "Loading plugin from $file"
	source $file
    }
}

