# $Id: irc_commands.tcl,v 1.9 2005/03/12 22:03:04 aleksey Exp $

namespace eval irc {}

proc irc::handle_irc_commands {chatid user body type} {

    set body [string trim $body]
    if {[cequal [crange $body 0 6] "/topic "]} {
	set command subject
	set subject [string trim [crange $body 7 end]]
    } elseif {[cequal [crange $body 0 8] "/subject "]} {
	set command subject
	set subject [string trim [crange $body 9 end]]
    } elseif {[cequal $body "/topic"] || [cequal $body "/subject"]} {
	set command show_subject
    } elseif {[cequal [crange $body 0 5] "/nick "]} {
	set command nick
	set nick [string trim [crange $body 6 end]]
    } elseif {[cequal [crange $body 0 7] "/invite "]} {
	set command invite
	set arg [string trim [crange $body 8 end]]
    } elseif {[cequal [crange $body 0 5] "/join "]} {
	set command join
	set room [string trim [crange $body 6 end]]
    } elseif {[cequal $body "/join"]} {
	set command join
	set room ""
    } elseif {[cequal [crange $body 0 4] "/msg "]} {
	set command msg
	set arg [string trim [crange $body 5 end]]
	set ind [string first " " $arg]
	if {$ind < 0} {
	    return stop
	} else {
	    set to [crange $arg 0 [expr {$ind - 1}]]
	    set text [string trim [crange $arg $ind end]]
	}
    } elseif {[cequal $body "/nick"] || [cequal $body "/msg"] || \
		  [cequal $body "/invite"]} {
	return stop
    } elseif {[cequal [crange $body 0 5] "/part "]} {
	set command leave
	set status [string trim [crange $body 6 end]]
    } elseif {[cequal [crange $body 0 6] "/leave "]} {
	set command leave
	set status [string trim [crange $body 7 end]]
    } elseif {[cequal $body "/part"] || [cequal $body "/leave"]} {
	set command leave
	set status ""
    } elseif {[cequal $body "/clear"]} {
	set command clear
    } else {
	return
    }

    set connid [chat::get_connid $chatid]
    set jid [chat::get_jid $chatid]

    switch -- $command {
	nick {
	    if {![cequal $type groupchat]} return
	    muc::change_nick $chatid $nick
	    debugmsg plugins "NICK: $nick"
	}
	subject {
	    if {![cequal $type groupchat]} return
	    message::send_msg $jid -connection $connid \
		-type groupchat -subject $subject
	    debugmsg plugins "SUBJECT: $subject"
	}
	show_subject {
	    chat::add_message $chatid $jid info \
		"[::msgcat::mc Subject:] $chat::chats(subject,$chatid)" {}
	}
	# TODO
	invite {
	}
	join {
	    if {[cequal $type groupchat]} {
		if {[cequal $room ""]} {
		    set room $jid
		} elseif {[string first @ $room] < 0} {
		    set room $room@[server_from_jid $jid]
		}
	    }
	    join_group $room \
		-nick [get_group_nick $room [get_our_groupchat_nick $chatid]] \
		-connection $connid
	    debugmsg plugins "JOIN: $room"
	}
	msg {
	    if {![cequal $type groupchat]} return
	    chat::open_to_user $connid $jid/$to -message $text
	    debugmsg plugins "MSG: $to: $text"
	}
	leave {
	    set chat::chats(exit_status,$chatid) $status
	    after idle [list ifacetk::destroy_win [chat::winid $chatid]]
	    debugmsg plugins "LEAVE: $jid $status"
	}
	clear {
	    set chatw [chat::chat_win $chatid]
	    $chatw configure -state normal
	    $chatw delete 0.0 end
	    $chatw configure -state disabled
	}
    }
    return stop
}

hook::add chat_send_message_hook [namespace current]::irc::handle_irc_commands 50

proc irc::irc_commands_comp {chatid compsvar wordstart line} {
    upvar 0 $compsvar comps

    if {!$wordstart} {
	lappend comps {/clear }
	lappend comps {/invite }
	lappend comps {/join }
	lappend comps {/leave }
	lappend comps {/msg }
	lappend comps {/nick }
	lappend comps {/part }
	lappend comps {/subject }
	lappend comps {/topic }
    }
}

hook::add generate_completions_hook [namespace current]::irc::irc_commands_comp

