# $Id: conferences.tcl,v 1.3 2005/08/14 16:25:27 aleksey Exp $

# JEP-0048 Bookmarks support (conference bookmarks in roster)
#
#   tkabber:bookmarks:groups description:
#
#   setting:
#   <query xmlns='jabber:iq:private'>
#	<storage xmlns='tkabber:bookmarks:groups'>
#	    <conference jid='talks@conference.jabber.ru'>
#		<group>Conferences</group>
#		<group>jabber.ru</group>
#	    </conference>
#	</storage>
#   </query>
#
#   getting:
#   <query xmlns='jabber:iq:private'>
#	<storage xmlns='tkabber:bookmarks:groups'/>
#   </query>
#


namespace eval conferences {
    # variable to store roster conference bookmarks
    array set bookmarks {}

    variable NS
    set NS(private) "jabber:iq:private"
    set NS(bookmarks) "storage:bookmarks"
    set NS(tkabber:groups) "tkabber:bookmarks:groups"
}

proc conferences::free_bookmarks {connid} {
    variable bookmarks

    array unset bookmarks $connid,*
}

hook::add disconnected_hook [namespace current]::conferences::free_bookmarks

proc conferences::request_bookmarks {connid} {
    variable NS
    variable bookmarks
    variable responds

    set responds($connid) 0
    array unset bookmarks $connid,*

    jlib::send_iq get \
	[jlib::wrapper:createtag query \
	     -vars [list xmlns $NS(private)] \
	     -subtags [list [jlib::wrapper:createtag storage \
				 -vars [list xmlns $NS(bookmarks)]]]] \
	-command [list [namespace current]::process_bookmarks $connid] \
	-connection $connid
    jlib::send_iq get \
	[jlib::wrapper:createtag query \
	     -vars [list xmlns $NS(private)] \
	     -subtags [list [jlib::wrapper:createtag storage \
				 -vars [list xmlns $NS(tkabber:groups)]]]] \
	-command [list [namespace current]::process_bookmarks $connid] \
	-connection $connid
}

hook::add connected_hook [namespace current]::conferences::request_bookmarks 20

proc conferences::process_bookmarks {connid res child} {
    variable NS
    variable bookmarks
    variable responds

    if {$res != "OK"} return

    incr responds($connid)

    jlib::wrapper:splitxml $child tag vars isempty cdata children

    foreach ch $children {
	jlib::wrapper:splitxml $ch tag1 vars1 isempty1 cdata1 children1

	if {[jlib::wrapper:getattr $vars1 xmlns] == $NS(bookmarks)} {
	    foreach bookmark $children1 {
		jlib::wrapper:splitxml $bookmark btag bvars bisempty bcdata bchildren

		if {$btag != "conference"} continue

		set jid [jlib::wrapper:getattr $bvars jid]
		set bookmarks($connid,jid,$jid) $jid

		set bookmarks($connid,name,$jid) [jlib::wrapper:getattr $bvars name]
		set bookmarks($connid,nick,$jid) ""
		set bookmarks($connid,password,$jid) ""
		if {![info exists bookmarks($connid,groups,$jid)]} {
		    set bookmarks($connid,groups,$jid) {}
		}

		set autojoin [jlib::wrapper:getattr $bvars autojoin]
		switch -- $autojoin {
		    1 { set bookmarks($connid,autojoin,$jid) 1 }
		    default { set bookmarks($connid,autojoin,$jid) 0 }
		}
		
		foreach bch $bchildren {
		    jlib::wrapper:splitxml \
			$bch tag2 vars2 isempty2 cdata2 children2
		    switch -- $tag2 {
			nick { set bookmarks($connid,nick,$jid) $cdata2 }
			password { set bookmarks($connid,password,$jid) $cdata2 }
		    }
		}
	    }
	} elseif {[jlib::wrapper:getattr $vars1 xmlns] == $NS(tkabber:groups)} {
	    foreach bookmark $children1 {
		jlib::wrapper:splitxml $bookmark btag bvars bisempty bcdata bchildren

		if {$btag != "conference"} continue

		set jid [jlib::wrapper:getattr $bvars jid]

		set groups {}
		foreach bch $bchildren {
		    jlib::wrapper:splitxml \
			$bch tag2 vars2 isempty2 cdata2 children2
		    switch -- $tag2 {
			group { lappend groups $cdata2 }
		    }
		}
		set bookmarks($connid,groups,$jid) $groups
	    }
	}
    }

    if {$responds($connid) < 2} return

    foreach idx [array names bookmarks $connid,jid,*] {
	set jid $bookmarks($idx)
	client:roster_push $connid $jid $bookmarks($connid,name,$jid) \
			   $bookmarks($connid,groups,$jid) \
			   bookmark "" conference ""
    }
    after idle [list [namespace current]::autojoin_groups $connid]
}

proc conferences::store_bookmarks {connid} {
    variable NS
    variable bookmarks

    set bookmarklist {}
    set grouplist {}
    foreach idx [array names bookmarks $connid,jid,*] {
	set jid $bookmarks($idx)
	set name $bookmarks($connid,name,$jid)
	set autojoin $bookmarks($connid,autojoin,$jid)
	
	set vars [list jid $jid name $name autojoin $autojoin]
	set subtags {}
	if {$bookmarks($connid,nick,$jid) != ""} {
	    lappend subtags [jlib::wrapper:createtag nick \
				 -chdata $bookmarks($connid,nick,$jid)]
	}
	if {$bookmarks($connid,password,$jid) != ""} {
	    lappend subtags [jlib::wrapper:createtag password \
				 -chdata $bookmarks($connid,password,$jid)]
	}
	lappend bookmarklist [jlib::wrapper:createtag conference \
				  -vars $vars \
				  -subtags $subtags]
	set vars [list jid $jid]
	set groups {}
	foreach group $bookmarks($connid,groups,$jid) {
	    lappend groups [jlib::wrapper:createtag group \
				-chdata $group]
	}
	lappend grouplist [jlib::wrapper:createtag conference \
			       -vars $vars \
			       -subtags $groups]
    }

    jlib::send_iq set \
	[jlib::wrapper:createtag query \
	     -vars [list xmlns $NS(private)] \
	     -subtags [list [jlib::wrapper:createtag storage \
				 -vars [list xmlns $NS(bookmarks)] \
				 -subtags $bookmarklist]]] \
	-command [list [namespace current]::store_bookmarks_result $connid] \
	-connection $connid
    jlib::send_iq set \
	[jlib::wrapper:createtag query \
	     -vars [list xmlns $NS(private)] \
	     -subtags [list [jlib::wrapper:createtag storage \
				 -vars [list xmlns $NS(tkabber:groups)] \
				 -subtags $grouplist]]] \
	-command [list [namespace current]::store_bookmarks_result $connid] \
	-connection $connid
}

proc conferences::store_bookmarks_result {connid res child} {

    if {$res == "OK"} return

    if {[winfo exists .store_bookmarks_error]} {
	destroy .store_bookmarks_error
    }
    MessageDlg .store_bookmarks_error -aspect 50000 -icon error \
	-message [format [::msgcat::mc "Storing conferences failed: %s"] \
			 [error_to_string $child]] \
	-type user -buttons ok -default 0 -cancel 0
}


proc conferences::add_conference_dialog {args} {
    variable gra_group
    variable gra_server
    variable gra_nick
    variable gra_password
    variable gra_autojoin
    variable gra_connid

    if {[lempty [jlib::connections]]} return

    set gw .addgroup
    catch { destroy $gw }

    set connid [lindex [jlib::connections] 0]
    set gra_server conference.[jlib::connection_server $connid]
    set gra_group ""
    set gra_password ""
    set gra_autojoin 0
    catch { unset gra_nick }

    foreach {key val} $args {
	switch -- $key {
	    -group { set gra_group $val }
	    -server { set gra_server $val }
	    -nick { set gra_nick $val }
	    -password { set gra_password $val }
	    -autojoin { set gra_autojoin $val }
	    -connection { set connid $val }
	}
    }

    if {![info exists gra_nick]} {
	set gra_nick [get_group_nick ${gra_group}@$gra_server ""]
    }
    set gra_connid [jlib::connection_jid $connid]

    Dialog $gw -title [::msgcat::mc "Add conference"] -separator 1 -anchor e \
	    -default 0 -cancel 1 -parent . -modal none

    set gf [$gw getframe]
    grid columnconfigure $gf 0 -weight 0
    grid columnconfigure $gf 1 -weight 1

    label $gf.lgroup -text [::msgcat::mc "Group:"]
    entry $gf.group -textvariable [namespace current]::gra_group
    label $gf.lserver -text [::msgcat::mc "Server:"]
    entry $gf.server -textvariable [namespace current]::gra_server
    label $gf.lnick -text [::msgcat::mc "Nick:"]
    entry $gf.nick -textvariable [namespace current]::gra_nick
    label $gf.lpassword -text [::msgcat::mc "Password:"]
    entry $gf.password -show * -textvariable [namespace current]::gra_password
    checkbutton $gf.autojoin -text [::msgcat::mc "Automatically join conference upon connect"] \
	-variable [namespace current]::gra_autojoin

    grid $gf.lgroup  -row 0 -column 0 -sticky e
    grid $gf.group   -row 0 -column 1 -sticky ew
    grid $gf.lserver -row 1 -column 0 -sticky e
    grid $gf.server  -row 1 -column 1 -sticky ew
    grid $gf.lnick -row 2 -column 0 -sticky e
    grid $gf.nick  -row 2 -column 1 -sticky ew
    grid $gf.lpassword -row 3 -column 0 -sticky e
    grid $gf.password  -row 3 -column 1 -sticky ew
    grid $gf.autojoin -row 4 -column 0 -sticky w -columnspan 2

    if {[llength [jlib::connections]] > 1} {
	foreach c [jlib::connections] {
	    lappend connections [jlib::connection_jid $c]
	}
	label $gf.lconnection -text [::msgcat::mc "Connection:"]
	ComboBox $gf.connection -textvariable [namespace current]::gra_connid \
				-values $connections

	grid $gf.lconnection -row 5 -column 0 -sticky e
	grid $gf.connection  -row 5 -column 1 -sticky ew
    }
    

    $gw add -text [::msgcat::mc "Add"] -command [list [namespace current]::add_conference $gw]
    $gw add -text [::msgcat::mc "Cancel"] -command [list destroy $gw]

    $gw draw $gf.group
}

proc conferences::add_conference {gw} {
    variable bookmarks
    variable gra_group
    variable gra_server
    variable gra_nick
    variable gra_password
    variable gra_autojoin
    variable gra_connid

    destroy $gw

    set jid ${gra_group}@$gra_server

    foreach c [jlib::connections] {
	if {[jlib::connection_jid $c] == $gra_connid} {
	    set connid $c
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route $jid]
    }

    if {[info exists bookmarks($connid,jid,$jid)]} {
	update_bookmark $connid $jid -name $gra_group -nick $gra_nick \
			-password $gra_password -autojoin $gra_autojoin \
			-groups [list Conferences]
	return
    }

    set bookmarks($connid,jid,$jid) $jid
    set bookmarks($connid,name,$jid) $gra_group
    set bookmarks($connid,nick,$jid) $gra_nick
    set bookmarks($connid,password,$jid) $gra_password
    set bookmarks($connid,autojoin,$jid) $gra_autojoin
    set bookmarks($connid,groups,$jid) [list Conferences]

    # TODO should we remove $jid from the roster if it is here?
    client:roster_push $connid $jid $bookmarks($connid,name,$jid) \
		       $bookmarks($connid,groups,$jid) \
		       bookmark "" conference ""
    store_bookmarks $connid
}

proc conferences::update_bookmark {connid jid args} {
    variable bookmarks

    if {![info exists bookmarks($connid,jid,$jid)]} return

    set store 0

    foreach {key val} $args {
	switch -- $key {
	    -name { set name $val }
	    -nick { set nick $val }
	    -password { set password $val }
	    -autojoin { set autojoin $val }
	    -groups { set groups $val }
	}
    }

    if {[info exists name] && $name != $bookmarks($connid,name,$jid)} {
	set bookmarks($connid,name,$jid) $name
	set store 1
    }
    if {[info exists nick] && $nick != $bookmarks($connid,nick,$jid)} {
	set bookmarks($connid,nick,$jid) $nick
	set store 1
    }
    if {[info exists password] && $password != $bookmarks($connid,password,$jid)} {
	set bookmarks($connid,password,$jid) $password
	set store 1
    }
    if {[info exists autojoin] && $autojoin != $bookmarks($connid,autojoin,$jid)} {
	set bookmarks($connid,autojoin,$jid) $autojoin
	set store 1
    }
    if {[info exists groups] && [lsort $groups] != [lsort $bookmarks($connid,groups,$jid)]} {
	set bookmarks($connid,groups,$jid) $groups
	set store 1
    }
    if {$store} {
	client:roster_push $connid $jid $bookmarks($connid,name,$jid) \
	    $bookmarks($connid,groups,$jid) bookmark "" conference ""
	store_bookmarks $connid
    }
}
	    
proc conferences::remove_bookmark {connid jid} {
    variable bookmarks

    client:roster_push $connid $jid $bookmarks($connid,name,$jid) \
		       $bookmarks($connid,groups,$jid) \
		       remove "" conference ""

    catch { unset bookmarks($connid,jid,$jid) }
    catch { unset bookmarks($connid,name,$jid) }
    catch { unset bookmarks($connid,nick,$jid) }
    catch { unset bookmarks($connid,password,$jid) }
    catch { unset bookmarks($connid,autojoin,$jid) }
    catch { unset bookmarks($connid,groups,$jid) }

    store_bookmarks $connid
}

proc conferences::rename_group {connid name new_name} {
    variable bookmarks
    
    set store 0
    foreach idx [array names bookmarks $connid,jid,*] {
	set jid $bookmarks($idx)
   
	set groups $bookmarks($connid,groups,$jid)
	if {[lcontain $groups $name] || \
		($name == $roster::undef_group_name && $groups == {})} {
	    set idx [lsearch -exact $groups $name]
	    if {$new_name != ""} {
		set groups [lreplace $groups $idx $idx $new_name]
	    } else {
		set groups [lreplace $groups $idx $idx]
	    }
	    set groups [lrmdups $groups]
	    client:roster_push $connid $jid $bookmarks($connid,name,$jid) \
			       $groups bookmark "" conference ""
	    set bookmarks($connid,groups,$jid) $groups
	    set store 1
	}
    }
    if {$store} {
	store_bookmarks $connid
    }
}

proc conferences::remove_bookmarks_group {connid name} {
    variable bookmarks

    set store 0
    foreach idx [array names bookmarks $connid,jid,*] {
	set jid $bookmarks($idx)

	set groups $bookmarks($connid,groups,$jid)
	if {(([llength $groups] == 1) && [lcontain $groups $name]) || \
		(($name == $roster::undef_group_name) && ($groups == {}))} {
	    
	    client:roster_push $connid $jid $bookmarks($connid,name,$jid) \
			       $groups remove "" conference ""

	    catch { unset bookmarks($connid,jid,$jid) }
	    catch { unset bookmarks($connid,name,$jid) }
	    catch { unset bookmarks($connid,nick,$jid) }
	    catch { unset bookmarks($connid,password,$jid) }
	    catch { unset bookmarks($connid,autojoin,$jid) }
	    catch { unset bookmarks($connid,groups,$jid) }
	    
	    set store 1
	} elseif {[lcontain $groups $name]} {
	    set idx [lsearch -exact $groups $name]
	    set groups [lreplace $groups $idx $idx]
	    
	    client:roster_push $connid $jid $bookmarks($connid,name,$jid) \
			       $groups bookmark "" conference ""
	    set bookmarks($connid,groups,$jid) $groups
	    
	    set store 1
	}
    }
    if {$store} {
	store_bookmarks $connid
    }
}

proc conferences::popup_menu {connid jid} {
    variable bookmarks

    if {[winfo exists [set m .confpopupmenu]]} {
        destroy $m
    }

    set args {}
    if {$bookmarks($connid,nick,$jid) != ""} {
	lappend args -nick $bookmarks($connid,nick,$jid)
    }
    if {$bookmarks($connid,password,$jid) != ""} {
	lappend args -password $bookmarks($connid,password,$jid)
    }

    menu $m -tearoff 0
    $m add command -label [::msgcat::mc "Join..."] \
	-command [list eval [list join_group_dialog \
				  -server [server_from_jid $jid] \
				  -group [node_from_jid $jid] \
				  -connection $connid] \
				  $args]
    return $m
}   

proc conferences::join_group {connid jid} {
    variable bookmarks
    
    set args {}
    if {$bookmarks($connid,nick,$jid) != ""} {
	lappend args -nick $bookmarks($connid,nick,$jid)
    }
    if {$bookmarks($connid,password,$jid) != ""} {
	lappend args -password $bookmarks($connid,password,$jid)
    }
    eval [list ::join_group $jid -connection $connid] $args
}

proc conferences::autojoin_groups {connid} {
    variable bookmarks

    foreach idx [array names bookmarks $connid,jid,*] {
	set jid $bookmarks($idx)
	if {$bookmarks($connid,autojoin,$jid)} {
	    join_group $connid $jid
	}
    }
}

