#!/bin/sh
# the next line restarts using the correct interpreter \
exec wish "$0" -name tkabber "$@"

# $Id: tkabber.tcl,v 1.232 2005/07/31 21:09:36 aleksey Exp $

set interface tk
namespace eval ifacetk {}

set aquaP 0
catch {
    switch -- [tk windowingsystem] {
	classic
	    -
	aqua {
	    set aquaP 1
            set tk_highlightthickness 0
            set tk_relief sunken
            set tk_borderwidth 0
	    set tk_modify Cmd
	    set tk_close Cmd-W

            rename ::bind ::bind_orig
            proc ::bind {args} {
                if {[llength $args] < 2} {
		    return [eval ::bind_orig $args]
		}
		if {[string first "<Control-" [set arg1 [lindex $args 1]]] \
		        == 0} {
            	    set arg1 "<Command-[string range $arg1 9 end]"
                }

                eval ::bind_orig [lreplace $args 1 1 $arg1]
	    }
	}
    }
}
if {!$aquaP} {
    set tk_highlightthickness [string equal $::tcl_platform(platform) "unix"]
    set tk_relief raised
    set tk_borderwidth 1
    set tk_modify Ctrl
    set tk_close Ctrl-F4
}

lappend auto_path [file dirname [info script]]

package require msgcat
if {[info exists ::env(LC_MESSAGES)]} {
    ::msgcat::mclocale $::env(LC_MESSAGES)
}

package require BWidget

tk appname tkabber

if {[package provide starkit] != ""} {
    set rootdir [file join $::starkit::topdir tkabber]
} else {
    set rootdir [file dirname [info script]]
}

proc get_snapshot {changelog} {
    set snapshot ""
    if {[catch { open $changelog } fd]} {
	return $snapshot
    }
    while {[gets $fd line] >= 0} {
	if {[regexp {(\d\d\d\d)-(\d\d)-(\d\d)} $line -> year month day]} {
	    set snapshot "-$year$month$day"
	    break
	}
    }
    close $fd
    return $snapshot
}

set version "0.9.8"
set toolkit_version "Tcl/Tk [info patchlevel]"
set debug_lvls {}

proc debugmsg {level msg} {
    global debug_lvls

    if {[lsearch -exact $debug_lvls $level] >= 0} {
	puts "$level: $msg"
    }
}

proc rescmd {id res ls} {
    puts "RESULT: $id $res $ls"
}

proc fullpath {args} {
    global rootdir
    return [eval file join [list $rootdir] $args]
}

proc pixmap {args} {
    global pixmaps_theme

    if {[cequal [cindex $pixmaps_theme end] /]} {
	set p [eval file join [list $pixmaps_theme] $args]
    } else {
	set p [eval fullpath pixmaps [list $pixmaps_theme] $args]
    }
    if {[file exists $p]} {
	return $p
    } else {
	return [eval fullpath pixmaps default $args]
    }
}

proc load_source {args} {
    set fullpath [eval fullpath $args]

    debugmsg tkabber "Loading $fullpath"
    uplevel #0 [list source $fullpath]
}

proc quit {{status 0}} {
    hook::run quit_hook
    catch { bind $::ifacetk::mf <Destroy> {} }
    destroy .
    exit $status
}

namespace eval ssj {}
load_source hooks.tcl

hook::add quit_hook logout 10
hook::add quit_hook {
    foreach chan [file channels] {
        if {[string first sock $chan] != -1} {
            catch { close $chan } res
            debugmsg tkabber "closed $chan '$res'"
        }
    }
} 100

load_source default.tcl
load_source ifacetk idefault.tcl

hook::add postload_hook postload
hook::add finload_hook finload

if {[info exists env(TKABBER_SITE_CONFIG)] && \
	[file exists $env(TKABBER_SITE_CONFIG)]} {
    source $env(TKABBER_SITE_CONFIG)
}

if {[file exists [file join ~ .tkabber config.tcl]]} {
    source [file join ~ .tkabber config.tcl]
}

if {![info exists load_default_xrdb] || $load_default_xrdb} {
    option readfile [fullpath ifacetk default.xrdb] startupFile

    switch -- $tcl_platform(platform) {
	unix {
	    option readfile [fullpath ifacetk unix.xrdb] startupFile
	}
    }
}

set sysenc [encoding system]
encoding system utf-8
::msgcat::mcload [file join $rootdir msgs]
foreach pr [::msgcat::mcpreferences] {
    set f [file join $rootdir msgs "$pr.rc"]
    if {[file exists $f]} {
	option read $f
	break
    }
}
foreach pr [::msgcat::mcpreferences] {
    set f [file join $::BWIDGET::LIBRARY "lang" "$pr.rc"]
    if {[file exists $f]} {
	option read $f
	break
    }
}
encoding system $sysenc
unset sysenc pr f

if {[catch { package require Tclx }]} {
    load_source Tclx.tcl
} else {
    random seed [expr {round(1000000000*rand())}]
}

package require jabberlib 0.8.4
load_source xmppmime.tcl

foreach {opt val} $argv {
    switch -- $opt {
	-mime {set mime_file $val}
	-user {set loginconf(user) $val}
	-password {set loginconf(password) $val}
	-resource {set loginconf(resource) $val}
	-port {set loginconf(port) $val}
	-autologin {set autologin $val}
	-chat {xmppmime::send_event [list chat $val]}
	-message {xmppmime::send_event [list message $val]}
	-conference {xmppmime::send_event [list groupchat $val]}
	-splash {set show_splash_window $val}
    }
}

if {[info exists mime_file]} {
    xmppmime::load $mime_file
}
if {[xmppmime::is_done]} exit

if {![info exists show_splash_window] || $show_splash_window} {
    load_source splash.tcl
}


proc ::LOG {text} {
    debugmsg jlib $text
}

proc ::HTTP_LOG {text} {
    debugmsg http $text
}

if {[catch { package require Img }]} {
    debugmsg tkabber \
	"unable to load the Img package, so no PNG/JPEG image support!

The IMG package is available at http://www.xs4all.nl/~nijtmans/img.html"
}

load_source custom.tcl
load_source utils.tcl
load_source plugins.tcl
load_source balloon.tcl
load_source presence.tcl
load_source iq.tcl
load_source roster.tcl
load_source itemedit.tcl
load_source messages.tcl
load_source textundo dkflib.tcl
load_source textundo textundo.tcl
load_source chats.tcl
load_source joingrdialog.tcl
load_source muc.tcl
load_source emoticons.tcl
load_source login.tcl
load_source browser.tcl
load_source disco.tcl
load_source userinfo.tcl
load_source datagathering.tcl
load_source negotiate.tcl
load_source mclistbox-1.02 mclistbox.tcl
load_source search.tcl
load_source register.tcl
load_source jidlink.tcl
load_source si.tcl
load_source filetransfer.tcl
load_source filters.tcl
load_source privacy.tcl
load_source gpgme.tcl

load_source ifacetk bwidget_workarounds.tcl
load_source aniemoteicons aniemoteicons.tcl
load_source ifacetk iface.tcl

plugins::load [file join plugins general]
plugins::load [file join plugins $tcl_platform(platform)]
plugins::load_dir [file join ~ .tkabber plugins]

hook::run postload_hook

load_source iface.tcl

hook::run finload_hook

