/****************************************************************************
    Copyright (C) 1987-2004 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#ifndef __memory_h
#define __memory_h

#define MEM_BYTEMAX	256
#define MEM_BYTEBITS	8
#define MEM_BYTEMASK	0xff

#define MEM_NODE	0
#define MEM_PAGE	1

typedef struct memory Memory;
typedef struct memnode MemNode;

typedef struct {
  int		motype;
} MemBase;

typedef struct {
  int		motype;
  unsigned 	baseAddr;		/* Base address of page */
  unsigned char *data1;			/* 0/1 data */
  unsigned char *datax;			/* Unknown bits */
} MemPage;

struct memnode {
  int		motype;
  void		*ptr[MEM_BYTEMAX];
};

struct memory {
  int		byte_shift;
  int		nbytes;
  int		bpw;
  MemNode	*root;
};

Memory *new_Memory(int abits,int dbits);
void delete_Memory(Memory*);
void Memory_lookup(Memory *M,unsigned A,unsigned char **D,unsigned char **U);
void Memory_flush(Memory*);

int Memory_readFile(Memory*,const char*); 
int Memory_writeFile(Memory*,const char*); 

int Memory_putLine(Memory *M,char *line);

Memory *SGate_getMem(SGate*);

#endif
