/****************************************************************************
    Copyright (C) 1987-2004 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Mon Dec  8 13:44:31 2003
****************************************************************************/
#include "tkgate.h"

static iconDimensions ff_iconDims[] = {
  {0,  0, 31, 31, 15, 15},
  {32, 0, 31, 31, 15, 15},
  {32, 32, 31, 31, 15, 15},
  {0,  32, 31, 31, 15, 15},
};
static int ff_iconBoldOffset = 64;

struct locate ff_in_loc[] = {
	{-16,0,-16,0,D_LEFT},
	{0,16,0,16,D_DOWN},
	{16,0,16,0,D_RIGHT},
	{0,-16,0,-16,D_UP},
};

struct locate ff_out_loc[] = {
	{16,-5,16,-5,D_RIGHT},
	{-5,-16,-5,-16,D_UP},
	{-16,5,-16,5,D_LEFT},
	{5,16,5,16,D_DOWN},
};

struct locate ff_nout_loc[] = {
	{16,5,16,5,D_RIGHT},
	{5,-16,5,-16,D_UP},
	{-16,-5,-16,-5,D_LEFT},
	{-5,16,-5,16,D_DOWN},
};

struct locate ff_ck_loc[] = {
	{0,16,0,16,D_DOWN},
	{16,0,16,0,D_RIGHT},
	{0,-16,0,-16,D_UP},
	{-16,0,-16,0,D_LEFT},
};

struct locate ff_en_loc[] = {
	{5,-16,5,-16,D_UP},
	{-16,-5,-16,-5,D_LEFT},
	{-5,16,-5,16,D_DOWN},
	{16,5,16,5,D_RIGHT},
};

struct locate ff_clr_loc[] = {
	{-5,-16,-5,-16,D_UP},
	{-16,5,-16,5,D_LEFT},
	{5,16,5,16,D_DOWN},
	{16,-5,16,-5,D_RIGHT},
};

static char *psFlipFlop[] = {
  "%",
  "% A flip-flop",
  "/psflipflop {",
  "  [[0 0][0 0][0 0][0 0]] adjstartgate",
  "  -15.5 -15.5 moveto",
  "  -15.5 15.5 lineto",
  "  15.5 15.5 lineto",
  "  15.5 -15.5 lineto",
  "  closepath stroke",
  "  -5 -15.5 moveto",
  "  0 -10.5 lineto",
  "  5 -15.5 lineto",
  "  stroke",
  "  7 rfont",
  "  (_C) -8 6 prshow",
  "  (_E) 2 6 prshow",
  "  (Q) 8 2 prshow",
  "  (_Q) 8 -8 prshow",
  "  (D) -14 -3 prshow",
  "  grestore",
  "} def",
  0
};

GGateInfo gate_ff_info = {
  FLIPFLOP,
  "Flip-Flop",
  "ff",0x0,
  "psflipflop",psFlipFlop,

  {{"f",	{"gmmem",5},		{"gmff",0,0,100},	"gat_make ff"},
   {0}},


  ff_iconDims,

  6,{{"Q",OUT,1,1,ff_out_loc},
     {"_Q",OUT,1,1,ff_nout_loc},
     {"D",IN,1,1,ff_in_loc},
     {"EN",IN,1,1,ff_en_loc},
     {"CLR",IN,1,1,ff_clr_loc},
     {"CK",IN,1,1,ff_ck_loc}},
  {{-17,15,RJ},{17,15,LJ},{17,15,LJ},{-17,15,RJ}},
  {1},

  {"setup","hold","CK-Q",0},
  
  Generic_Make,
  Generic_Init,
  Generic_Delete,
  Generic_GetExtents,
  Generic_HitDistance,
  Generic_Draw,
  Generic_Move,
  Generic_Replicate,
  Err_AddInput,
  Err_AddOutput,
  Err_AddInOut,
  Err_ChangePin,
  Nop_SimStateFunc,
  Nop_SimHitFunc,
  Generic_PSWrite,
  Generic_EditProps,
  Generic_VerSave
};


void init_ff()
{
  Pixmap P;

  P = Pixmap_registerFromFile("flipflop","flipflop.b");
  gateinfo_iconInit(&gate_ff_info,P,ff_iconDims,ff_iconBoldOffset);
  RegisterGate(&gate_ff_info);
}
