//: version "1.8.3"
//: property useExtBars = 0
//: property discardChanges = 1

module main;    //: root_module
wire w6;    //: /sn:0 {0}(232,502)(177,502){1}
//: {2}(175,500)(175,466)(187,466){3}
//: {4}(173,502)(141,502){5}
wire w7;    //: /sn:0 {0}(253,500)(263,500){1}
wire w2;    //: /sn:0 {0}(187,461)(141,461){1}
wire w5;    //: /sn:0 {0}(232,497)(218,497)(218,464)(208,464){1}
//: enddecls

  //: comment g61 /dolink:1 /link:"@T/edwire_tut.v" @(630,100) /sn:0 /anc:1
  //: /line:"Editing Wires"
  //: /end
  //: comment g8 /dolink:0 /link:"" @(250,481) /anc:1
  //: /line:"OR gate"
  //: /end
  or g4 (.I0(w5), .I1(w6), .Z(w7));   //: @(243,500) /sn:0 /anc:1 /w:[ 0 0 0 ]
  and g3 (.I0(w2), .I1(w6), .Z(w5));   //: @(198,464) /sn:0 /anc:1 /w:[ 0 3 1 ]
  //: frame g13 @(412,372) /sn:0 /wi:381 /ht:177 /tx:"Create Circuit Here"
  //: switch g2 (w6) @(124,502) /sn:0 /anc:1 /w:[ 5 ] /st:0
  //: switch g1 (w2) @(124,461) /sn:0 /anc:1 /w:[ 1 ] /st:0
  //: comment g16 /dolink:1 /link:"@T/module_tut.v" @(630,115) /sn:0 /anc:1
  //: /line:"Using Modules"
  //: /end
  //: comment g10 /dolink:0 /link:"" @(12,236) /anc:1
  //: /line:"5) Create the two switches the same way as the AND and OR gates, by setting a position and selecting"
  //: /line:"\"Switch\" from the \"I/O\" submenu of the \"Make\" menu, or by typing an \"s\"."
  //: /line:""
  //: /line:"6) Repeat step 4 to connect the output of the upper switch to the upper input of the AND gate."
  //: /line:""
  //: /line:"7) Repeat step 4 to connect the output of the lower switch to the lower input of the OR gate."
  //: /line:""
  //: /line:"8) Click and hold on the lower input of the AND gate to bring up the soldering iron.  Drag it down to the"
  //: /line:"middle of the wire connecting the lower switch and the OR gate and release the mouse button.  A solder joint"
  //: /line:"will be automatically created."
  //: /end
  //: comment g6 /dolink:0 /link:"" @(101,427) /anc:1
  //: /line:"Switches"
  //: /end
  //: comment g9 /dolink:0 /link:"" @(12,9) /anc:1
  //: /line:"1) In this example, you will build a circuit like the one shown below. Build your"
  //: /line:"circuit in the frame box area in the lower right corner of this window.  Start by"
  //: /line:"setting a position for the AND gate by clicking and holding the right mouse"
  //: /line:"button.  An \"X\" symbol will appear to mark the position."
  //: /line:""
  //: /line:"2) Now select \"AND\" from the \"Gate\" submenu of the \"Make\" popup (or from the menu"
  //: /line:"bar) to create an AND gate at the position you selected. Alternatively, you can use"
  //: /line:"the keyboard shortcut \"a\"."
  //: /line:""
  //: /line:"3) Now repeat the action, this time selecting a postion for the OR gate, placing"
  //: /line:"it to the right and below the position of the AND gate.  Create the OR gate by"
  //: /line:"selecting \"OR\" from the \"Gates\" submenu of the \"Make\" menu, or by typing an \"o\"."
  //: /line:""
  //: /line:"4) Connect the upper input wire of the OR gate to the output of the AND gate by"
  //: /line:"clicking and holding the free end of the AND gate output with the left mouse"
  //: /line:"button.  This will cause the mouse cursor to change to a soldering iron.  Now"
  //: /line:"drag the wire near the end of the upper input wire on the OR gate and release the"
  //: /line:"mouse button.  The wires will \"click\" together."
  //: /line:""
  //: /end
  //: comment g7 /dolink:0 /link:"" @(193,441) /anc:1
  //: /line:"AND gate"
  //: /end
  //: frame g15 @(600,25) /sn:0 /anc:1 /wi:213 /ht:149 /tx:"Tutorials"
  //: comment g20 /dolink:0 /link:"@T/create_tut.v" @(630,55) /sn:0 /anc:1
  //: /line:"Creating a Circuit"
  //: /end
  //: comment g17 /dolink:1 /link:"@T/sim_tut.v" @(630,130) /sn:0 /anc:1
  //: /line:"Combinational Simulation"
  //: /end
  //: comment g14 /dolink:1 /link:"@T/seqsim_tut.v" @(630,145) /sn:0 /anc:1
  //: /line:"Sequential Simulation"
  //: /end
  //: joint g5 (w6) @(175, 502) /anc:1 /w:[ 1 2 4 -1 ]
  //: comment g21 /dolink:1 /link:"@T/edit2_tut.v" @(630,85) /sn:0 /anc:1
  //: /line:"Group Editing Features"
  //: /end
  //: comment g22 /dolink:0 /link:"" @(605,55) /sn:0 /anc:1
  //: /line:"->"
  //: /end
  //: comment g0 /dolink:1 /link:"@T/edit1_tut.v" @(630,70) /sn:0 /anc:1
  //: /line:"Basic Editing Modes"
  //: /end
  //: comment g18 /dolink:1 /link:"@T/welcome_tut.v" @(630,40) /sn:0 /anc:1
  //: /line:"TkGate Introduction"
  //: /end

endmodule
