!	
! *  ISEM - Instructional Sparc EMulator and tkisem
! *  Copyright (C) 1993, 1994, 1995, 1996
! *	 Department of Computer Science,
! *       The University of New Mexico
! *
! *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
! *
! *
! *  This program is free software; you can redistribute it and/or modify
! *  it under the terms of the GNU General Public License as published by
! *  the Free Software Foundation; either version 2 of the License, or
! *  (at your option) any later version.
! *
! *  This program is distributed in the hope that it will be useful,
! *  but WITHOUT ANY WARRANTY; without even the implied warranty of
! *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
! *  GNU General Public License for more details.
! *
! *  You should have received a copy of the GNU General Public License
! *  along with this program; if not, write to the Free Software
! *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!
	.global trap_vect
	
	.global default			! default handler
	.global halt, putc, getc, getc_nb, putx, getx, uputs
	.global wover, wunder
	.global timer, uart
	
	.data
rcsid:	.asciz	"$Id: isem_rom.s 1.4 Tue, 31 Dec 1996 14:55:33 -0700 maccabe $";
	

	!
	! rom.s
	!
	! ROM code for ISEM --
	!
	! 11/2/94
	!	A. B. Maccabe
	!
	! ******************************************************************
	! WARNING:	you must link this code with the code in isem_vec.s
	!  using isem_ld and the linker script generic/isem_ld.txt, which
	!  is designed to page align the text segment in isem_vec.s.  
        !  The link line should look something like:
	!	isem_ld -T isem_ld.txt -o isem_rom isem_rom.o isem_vec.o
	! ******************************************************************
	!
	! This code supports the following traps
	!	0 -- terminate program
	!	1 -- putc
	!	2 -- getc (blocking version)
	!	3 -- getc_nb (nonblocking)
	!	4 -- putx
	!	5 -- getx
	!	6 -- puts
	!
	!
	! *********************************************************************
	! REGISTER USAGE:
	!	The following registers must not be altered during trap 
	!	handling:
	!	%g0, %g2-%g7	(%g1 can be altered, but it's not a great idea)
	!	%o0-%o7		these may be in use by another routine
	!	%i6		this is the application's sp
	!	%l2		holds the npc needed to return
	!
	!	In addition, fault and interrupt handlers should not alter:
	!	%g1		the application might be using this register
	!	%l1		holds the pc needed to return
	!	%i0-%i5, %i7	these are not inputs for a fault or interrupt
	!
	!	So, during trap handling we have:
	!		%g1
	!		%i0-%i5, %i7
	!		%l0, %l1, %l3-%l7
	!	during fault or interrupt handling we have:
	!		%l0, %l3-%l7
	!
	!  In general, we'll try to avoid trashing the global and
	!  output registers.  As such, the routines in this code
	!  do not follow standard SPARC conventions.  Instead, we
	!  adopt the following conventions:
	!	%i0 -- %i7	parameters (volatile)
	!	%l0 -- %l7	locals for the trap handler (non volatile)
	!
	! *********************************************************************
	!  WARNING -- it's critical that the output registers be left
	!   intact if you intend to continue running the current program
	!   so, you can't simply use the call instruction (it trashes %o7)
	!   to call other supervisor routines.
	! *********************************************************************
	!

		CONOUT		= 0x110000
		CONIN		= 0x110000
		HALT		= 0x120000
		TIMER		= 0x130000
		UARTSTATUS	= 0X140000 
		UARTCREG	= 0x140000
		UARTTXREG	= 0x140004
		UARTRXREG	= 0x140004

		.data
		.align	4
nreg_sets:
	.skip	4
Lrom_ver:	
	! $Format: "\t.ascii\t\"Release $ProjectVersion$ -- \""$
	.ascii	"Release 4.5.12 -- "
	.ascii	"Copyright (C) 1993-2001\n"
	.ascii  "Department of Computer Science, "
	.asciz	"The University of New Mexico\n"
LM0:	.asciz	"\n***** Default trap handlers installed *****\n"

	.text
	.global	start
start:
	! set up the window invalid mask and the cwp
	!  -- only use globals until the cwp is set!!!!!

	! first, we write all 1's to %wim
	set	-1, %r1
	mov	%r1, %wim
	nop				! wait
	nop				! wait
	nop				! wait
	mov	%wim, %r1

	! now, we count the number of register sets
	set	1, %r2			! the count of register sets
	srl	%r1, 1, %r1		! must have at least 2 sets
0:	
	srl	%r1, 1, %r1		! knock off another set
	cmp	%r1, 0
	bne	0b	
	inc	%r2			! in the delay slot -- always inc

	set	nreg_sets, %r1
	st	%r2, [%r1]

	! isem used to set CWP to NWINDOWS - 2 and set the last register
	! set as invalid -- we'll mimic this behavior -- just for grins....
	dec	%r2
	set	1, %r3
	sll	%r3, %r2, %r3
	mov	%r3, %wim		! setting the invalid bit

	dec	%r2
	mov	%psr, %r4
	andn	%r4, 0x1f, %r4		! clear the  cwp
	or	%r4, %r2, %r4
	mov	%r4, %psr
	
	! be sure to only use global registers in the next three instructions!
	set	trap_vect, %r1
	mov	%r1, %tbr

	! print the version message
	set	Lrom_ver, %i0
	call	puts
	nop

	set	LM0, %i0
	call	puts
	nop

	set	HALT, %r8
	st	%r8, [%r8]
	ba	start
	nop

	

	!---------------------------------------------------------------------
	!---------------------------------------------------------------------
	! the default trap handler
	!	print a termination message and abort the program
	!
	
	.data
Ldfmsg1:	.asciz	"\n********** Unhandled trap -- 0x"
Ldfmsg2:	.asciz	" -- execution terminated **********\n"
Ldfmsg3:	.asciz	" ---- PC = 0x"
Ldfmsg4:	.asciz	"    nPC = 0x"

Ltrpmsg_00:	.asciz	"\n *****UNKNOWN ????***** trap\n"
Ltrpmsg_01:	.asciz	"\n Instruction access exception trap\n"
Ltrpmsg_02:	.asciz	"\n Illegal instruction trap\n"
Ltrpmsg_03:	.asciz	"\n Privileged instruction trap\n"
Ltrpmsg_04:	.asciz	"\n Floating point disabled trap\n"
Ltrpmsg_05:	.asciz	"\n Register window overflow trap\n"
Ltrpmsg_06:	.asciz	"\n Register window underflow trap\n"
Ltrpmsg_07:	.asciz	"\n Unaligned address trap\n"
Ltrpmsg_08:	.asciz	"\n Floating point trap\n"
Ltrpmsg_09:	.asciz	"\n Data access trap\n"
Ltrpmsg_0a:	.asciz	"\n Tag overflow trap\n"
Ltrpmsg_0b:	.asciz	"\n Watch point detected trap\n"
	
Ltrpmsg_11:	.asciz	"\n Interrupt level 1 trap\n"
Ltrpmsg_12:	.asciz	"\n Interrupt level 2 trap\n"
Ltrpmsg_13:	.asciz	"\n Interrupt level 3 trap\n"
Ltrpmsg_14:	.asciz	"\n Interrupt level 4 trap\n"
Ltrpmsg_15:	.asciz	"\n Interrupt level 5 trap\n"
Ltrpmsg_16:	.asciz	"\n Interrupt level 6 trap\n"
Ltrpmsg_17:	.asciz	"\n Interrupt level 7 trap\n"
Ltrpmsg_18:	.asciz	"\n Interrupt level 8 trap\n"
Ltrpmsg_19:	.asciz	"\n Interrupt level 9 trap\n"
Ltrpmsg_1a:	.asciz	"\n Interrupt level 10 trap\n"
Ltrpmsg_1b:	.asciz	"\n Interrupt level 11 trap\n"
Ltrpmsg_1c:	.asciz	"\n Interrupt level 12 trap\n"
Ltrpmsg_1d:	.asciz	"\n Interrupt level 13 trap\n"
Ltrpmsg_1e:	.asciz	"\n Interrupt level 14 trap\n"
Ltrpmsg_1f:	.asciz	"\n Interrupt level 15 trap\n"
	
Ltrpmsg_20:	.asciz	"\n R register access error trap (parity error?)\n"
Ltrpmsg_21:	.asciz	"\n Instruction access error trap\n"
	
Ltrpmsg_24:	.asciz	"\n Coprocessor disabled trap\n"
Ltrpmsg_25:	.asciz	"\n Unimplemented FLUSH trap\n"
	
Ltrpmsg_28:	.asciz	"\n Coprocessor exception trap\n"
Ltrpmsg_29:	.asciz	"\n Data access error trap\n"
Ltrpmsg_2a:	.asciz	"\n Divide by zero trap\n"
Ltrpmsg_2b:	.asciz	"\n Data store error trap\n"
Ltrpmsg_2c:	.asciz	"\n Data access MMU miss trap\n"
	
Ltrpmsg_3c:	.asciz	"\n Instruction access MMU miss trap\n"
	
Ltrpmsg_80:	.asciz	"\n Trap instruction trap\n"

		.align 4
Ltrpmsg_tbl:	
	.word	Ltrpmsg_00
	.word	Ltrpmsg_01, Ltrpmsg_02, Ltrpmsg_03, Ltrpmsg_04, Ltrpmsg_05
	.word	Ltrpmsg_06, Ltrpmsg_07, Ltrpmsg_08, Ltrpmsg_09, Ltrpmsg_0a
	.word	Ltrpmsg_0b
	
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
		
	.word	Ltrpmsg_11, Ltrpmsg_12, Ltrpmsg_13, Ltrpmsg_14, Ltrpmsg_15
	.word	Ltrpmsg_16, Ltrpmsg_17, Ltrpmsg_18, Ltrpmsg_19, Ltrpmsg_1a
	.word	Ltrpmsg_1b, Ltrpmsg_1c, Ltrpmsg_1d, Ltrpmsg_1e, Ltrpmsg_1f
		
	.word	Ltrpmsg_20, Ltrpmsg_21
	
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	
	.word	Ltrpmsg_24, Ltrpmsg_25
	
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	
	.word	Ltrpmsg_28, Ltrpmsg_29, Ltrpmsg_2a, Ltrpmsg_2b, Ltrpmsg_2c
	
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	.word	Ltrpmsg_00
	
	.word	Ltrpmsg_3c
	
	.text
default:
	! print the initial message
	set	Ldfmsg1, %i0
	call	puts
	nop

	! print the trap number
	mov	%tbr, %i0
	srl	%i0, 4, %i0
	and	%i0, 0xff, %i0
	call	puthex
	nop

	! print the execution terminted message
	set	Ldfmsg2, %i0
	call	puts
	nop

	! recompute the trap number
	mov	%tbr, %i0
	srl	%i0, 4, %i0
	and	%i0, 0xff, %l0
	
	! print the trap specific message
	cmp	%l0, 0x3c
	bg	Lchk_trap
	nop

	! the appropriate message is in the table
	sll	%l0, 2, %l0
	set	Ltrpmsg_tbl, %i0
	add	%l0, %i0, %i0
	ba	Lprt_msg
	ld	[%i0], %i0

Lchk_trap:	
	! see if it's a trap instruction
	cmp	%l0, 0x80
	bge	Lis_trap
	nop

	! it's a bogus fault
	sethi	%hi(Ltrpmsg_00), %i0
	ba	Lprt_msg
	or	%i0, %lo(Ltrpmsg_00), %i0

Lis_trap:
	! it's an unhandled trap instruction
	set	Ltrpmsg_80, %i0

Lprt_msg:	
	! print the trap message
	call	puts
	nop

	! print the PC
	set	Ldfmsg3, %i0
	call	puts
	nop
	mov	%r17, %i0
	call	puthex
	nop

	! print the nPC
	set	Ldfmsg4, %i0
	call	puts
	nop
	mov	%r18, %i0
	call	puthex
	nop

	restore

	set	HALT, %r8
	st	%r8, [%r8]
	ba	start
	nop
	
	
	!----------------------------------------------------------------------
	! Window overflow handler .....
	!  we'll just save a single set of registers for the time being
	!
	!  WARNING, this code assumes that there are at least 3 register
	!   sets -- if there are only 2, it will cause the processor
	!   to enter an error state.
	
	.data
LM3:	.asciz	"Unaligned stack pointer -- execution aborted\n"
	.text
wover:
	! save the oldest set of user registers to the
	!  appropriate stack frame
	save				! use the oldest register set

	andcc	%sp, 0x7, %r0		! stack pointer must be 8 byte aligned
	be	1f
	nop

	set	LM3, %i0
	call	puts
	nop

	set	HALT, %i0
	st	%i0, [%i0]
	ba	start
	nop
	
	
1:	stda	%l0, [%sp]10
	add	%sp, 8, %l0
	stda	%l2, [%l0]10
	inc	8, %l0
	stda	%l4, [%l0]10
	inc	8, %l0
	stda	%l6, [%l0]10
	inc	8, %l0
	stda	%i0, [%l0]10
	inc	8, %l0
	stda	%i2, [%l0]10
	inc	8, %l0
	stda	%i4, [%l0]10
	inc	8, %l0
	stda	%i6, [%l0]10
	
	! make this the invalid register set
	mov	%psr, %l2
	and	%l2, 0x1f, %l2		! get the cwp (from the psr)
	set	1, %l3
	sll	%l3, %l2, %l3
	mov	%l3, %wim		! set the window invalid mask
	nop				! delay for three cycles
	nop
	nop

	! restore the original register set and return -- re-execute
	!  the save instruction that caused the fault
	restore
	jmpl	%r17, %g0
	rett	%r18
	
	
	!----------------------------------------------------------------------
	! Window underflow handler .....
	!  we'll just restore a single set of registers for the time being
	!
	!  WARNING, this code assumes that there are at least 4 register
	!   sets -- if there are 2 or fewer, it will cause the processor
	!   to enter an error state.
	
	.text
wunder:
	! at this point, we're two sets of registers from where we
	!  want to be.
	! first, we'll open up the register set we want to get into,
	!  then we'll get there using two restore instructions
	set	nreg_sets, %l0
	ld	[%l0], %l0

	mov	%psr, %l6
	and	%l6, 0x1f, %l5		! just the cwp
	add	%l5, 3, %l5
	cmp	%l0, %l5
	bgt	1f
	nop
	
	sub	%l5, %l0, %l5
	
1:	! %l5 holds the cwp we want to make invalid
	set	1, %l7
	sll	%l7, %l5, %l7
	
	mov	%l7, %wim
	nop				! wait until %wim has been updated
	nop
	nop
	
	restore
	restore
	
	!  now, we're in the correct set of registers and the
	!  stack pointer should be correct, we'll check the stack
	!  pointer and restore registers

	andcc	%sp, 0x7, %r0		! stack pointer must be 8 byte aligned
	be	2f
	nop

	set	LM3, %i0
	call	puts
	nop

	set	HALT, %i0
	st	%i0, [%i0]
	ba	start
	nop
	
2:	! restore the locals and inputs 
	add	%sp, 8, %l0
	ldda	[%l0]10, %l2
	inc	8, %l0
	ldda	[%l0]10, %l4
	inc	8, %l0
	ldda	[%l0]10, %l6
	inc	8, %l0
	ldda	[%l0]10, %i0
	inc	8, %l0
	ldda	[%l0]10, %i2
	inc	8, %l0
	ldda	[%l0]10, %i4
	inc	8, %l0
	ldda	[%l0]10, %i6
	ldda	[%sp]10, %l0
	
	! get back to the original set of registers so we can return
	save
	save
	
	! return -- re-execute the restore instruction that caused the fault
	jmpl	%r17, %g0
	rett	%r18
	
	
	!----------------------------------------------------------------------
	! Terminate program .........
	!	ta	0
	.data
LM4:	.asciz	"Program terminated normally\n"

	.text
halt:
	set	LM4, %i0
	call 	puts
	nop

	restore
	
	set	HALT, %r8
	st	%r8, [%r8]
	ba	start
	nop
	
	
	!----------------------------------------------------------------------
	! putc -- print a character to the consol
	!	ta	1
	.text
putc:
	set	CONOUT, %l0
	st	%i0, [%l0]

	! return to the instruction following the trap
	jmpl	%r18, %r0
	rett	%r18+4
	

	!----------------------------------------------------------------------
	! getc -- get a character from the consol -- BLOCKING
	!	ta	2
	.text
getc:
	set	0xffffffff, %l3
	set	CONIN, %l0
0:	ld	[%l0], %i0
	cmp	%i0, %l3
	be	0b
	nop

	! return to the instruction following the trap
	jmpl	%r18, %r0
	rett	%r18+4
	

	!----------------------------------------------------------------------
	! getc_nb -- get a character from the consol -- NON BLOCKING
	!	ta	3
	.text
getc_nb:
	set	CONIN, %l0
	ld	[%l0], %i0

	! return to the instruction following the trap
	jmpl	%r18, %r0
	rett	%r18+4
	

	!----------------------------------------------------------------------
	! putx -- put a hexadecimal value to the consol -- BLOCKING
	!	ta	4
	.text
putx:	
	mov	%o7, %l7
	call	puthex
	nop
	mov	%l7, %o7
	
	! return to the instruction following the trap
	jmpl	%r18, %r0
	rett	%r18+4
	

	!----------------------------------------------------------------------
	! getx -- get a hexadecimal value from the consol -- BLOCKING
	!	ta	5
	.text
getx:
	clr	%i0			! clear the result
	set	0xffffffff, %l3
	set	CONIN, %l0
	clr	%l5			! clear the digit count

	! read the next character from the consol
1:	ld	[%l0], %l4
	cmp	%l4, %l3
	be	1b
	nop
	
	! check for a hex digit
	cmp	%l4, '0'
	bl	4f		! value < '0', all done
	cmp	%l4, '9'
	ble,a	3f		! value between '0' and '9', deal with it
	sub	%l4, '0', %l4	! map to value .... '0'-->0

2:	or	%l4, 0x20, %l4	! map all letters to lower case
	cmp	%l4, 'a'
	bl	4f		! all done
	cmp	%l4, 'f'
	bg	4f		! all done

	sub	%l4, 'a'-10, %l4	! map 'a' --> 10, etc

3:
	inc	%l5		! count another digit
	sll	%i0, 4, %i0	! make room for this digit
	or	%i0, %l4, %i0	! put the digit in place
	ba	1b		! go back and try again
	nop
	
4:
	cmp	%l5, 0		! make sure we read at least one digit
	be	1b
	nop
	
	! return to the instruction following the trap
	jmpl	%r18, %r0
	rett	%r18+4

	
	!----------------------------------------------------------------------
	! uputs -- put a user string to the consol
	!	ta	6
	.text
uputs:	
	ba	1f
	set	CONOUT, %i1
	
0:
	st	%i2, [%i1]

1:	lduba	[%i0]10, %i2
	cmp	%i2, 0
	bne	0b
	inc	%i0
	
	! return to the instruction following the trap
	jmpl	%r18, %r0
	rett	%r18+4
	

	!----------------------------------------------------------------------
	! puthex -- print a hexidecimal value
	!	-- the value is in %i0
	.data
hexch:	.ascii "0123456789ABCDEF"

	.text
puthex:
	set	CONOUT, %i2
	set	hexch, %i3
	srl	%i0, 28, %i1		! 8th hex digit 
	sll	%i0, 4, %i0
	ldub	[%i3+%i1], %i4
	st	%i4, [%i2]
	srl	%i0, 28, %i1		! 7th hex digit 
	sll	%i0, 4, %i0
	ldub	[%i3+%i1], %i4
	st	%i4, [%i2]
	srl	%i0, 28, %i1		! 6th hex digit 
	sll	%i0, 4, %i0
	ldub	[%i3+%i1], %i4
	st	%i4, [%i2]
	srl	%i0, 28, %i1		! 5th hex digit 
	sll	%i0, 4, %i0
	ldub	[%i3+%i1], %i4
	st	%i4, [%i2]
	srl	%i0, 28, %i1		! 4th hex digit 
	sll	%i0, 4, %i0
	ldub	[%i3+%i1], %i4
	st	%i4, [%i2]
	srl	%i0, 28, %i1		! 3rd hex digit 
	sll	%i0, 4, %i0
	ldub	[%i3+%i1], %i4
	st	%i4, [%i2]
	srl	%i0, 28, %i1		! 2nd hex digit 
	sll	%i0, 4, %i0
	ldub	[%i3+%i1], %i4
	st	%i4, [%i2]
	srl	%i0, 28, %i1		! 1st hex digit 
	sll	%i0, 4, %i0
	ldub	[%i3+%i1], %i4
	st	%i4, [%i2]

	retl
	nop
	

	!----------------------------------------------------------------------
	! puts -- print a null terminated string on the consol
	!	-- the address of the string is in %i0
puts:
	ba	1f
	set	CONOUT, %i1
	
0:
	st	%i2, [%i1]

1:	ldub	[%i0], %i2
	cmp	%i2, 0
	bne	0b
	inc	%i0

	retl
	nop


	!----------------------------------------------------------------------
	! timer:
	!	the timer interrupt handler
	!
	.text
timer:
	! clear the timer interrupt -- all you need to do is read
	!   or write from the timer
	set	TIMER, %l4
	ld	[%l4], %g0

	! return to the user instruction that was just about to
	! execute before the interrupt was detected
	jmpl	%r17, %r0
	rett	%r18


	!----------------------------------------------------------------------
	! uart:
	!	the uart interrupt handler
	!
	.text
uart:
	set	UARTSTATUS, %l4		
	ld	[%l4], %l5		
	set	UARTCREG, %l6
	ld	[%l6], %l7		
	! uart returns to the user instruction that was just about to
	! execute before the uart interrupt was detected
	jmpl	%r17, %r0
	rett	%r18

