/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//
// $Id: InstrFmt.h 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $
//

//== InstrFmt.h =========================================================
//
// V1.0 - 15 JUN 92
//
// There are three instruction formats called IF1, IF2, and IF3.
//   *** See page 37 (Ch.4 - Instructions) of the Sparc Architecture Manual
//
// The op field determines the instruction format to use as follows:
//  	0       - format 1
//  	1       - format 2
// 	2 or 3  - format 3
//
// op2 - comprises bits 24 thru 22 in format 2 instructions. It selects
// the instruction as follows:
//      0  UNIMP
//      2  Bicc
//	4  SETHI
//	6  FBfcc
//	7  CBccc
//
// rd - For store instructions, this register selects an r register (or an
// f register pair) or an f register to be the source. For all other
// instructins, this field selects an r register, an f register or an f 
// register pair to be the destination.
//
// a - the a bit means annul in format 2 instructions. This bit changes the
// behavior of the instruction encountered immediately after a control 
// transfer.
//
// cond - This field selects the condition code for format 2 instructions
//
// imm22 - This field is a 22 bit contant value used by the SETHI instruction
//
// disp22 & disp30
// These fields are 30-bit and 22-bit sign-extended word displacements
// for PC-relative calls and branches respectively.
//
// op3 - The op3 field selects one of the format 3 opcodes.
//
// i - The i bit selects the type of the second ALU operand for non-FPop
// instructions. if i=0, the second operand is r[rs2]. If i=1, the second
// operand is sign-extended simm13.
//
// asi - This 8-bit field is the address space identifier generated by 
// load/store alternate instructions.
//
// rs1 - This field selects the first source operand from either the r
// registers or the f registers.
//
// rs2 - This field selects the second source operand from either the r
// registers or the f registers.
//
// simm13 - This field is a sign-extended 13-bit immediate value used as
// the second ALU operand when i = 1.
//
// opf - This 9-bit field identifies a floating point operate (FPop)
// instruction or a coprocessor operate (CPop) instruction. 
//

#ifndef _INSTRFMT_H
#define _INSTRFMT_H

struct IF1 {
    UInt32	op     :  2;		
    UInt32	disp30 : 30;
};

struct IF2a {
    UInt32	op     :  2;
    UInt32	rd     :  5;
    UInt32	op2    :  3;
    UInt32	imm22  : 22;
};


struct IF2b {
    UInt32	op     :  2;
    UInt32	a      :  1;
    UInt32	cond   :  4;
    UInt32	op2    :  3;
    UInt32	disp22 : 22;
};

struct IF3a {
    UInt32	op     :  2;
    UInt32	rd     :  5;
    UInt32	op3    :  6;
    UInt32	rs1    :  5;
    UInt32	i      :  1;
    UInt32	asi    :  8;
    UInt32	rs2    :  5;
};

struct IF3b {
    UInt32	op     :  2;
    UInt32	rd     :  5;
    UInt32	op3    :  6;
    UInt32	rs1    :  5;
    UInt32	i      :  1;
    UInt32	simm13 : 13;
};

struct IF3c {
    UInt32	op     :  2;
    UInt32	rd     :  5;
    UInt32	op3    :  6;
    UInt32	rs1    :  5;
    UInt32	opf    :  9;
    UInt32	rs2    :  5;
};


union InstUnion {
    UInt32	f0;		// access to entire 32bits
    IF1		f1;
    IF2a	f2a;
    IF2b	f2b;
    IF3a	f3a;
    IF3b	f3b;
    IF3c	f3c;
};

#endif
