/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//
// $Id: Memory.h 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $
//

//
// Memory.h -- declaration of the  Memory  class
//

#ifndef _Memory_h
#define _Memory_h

#include "st_dev.h"

class Memory : public StorageDevice {
public:
    // public Constructors / Destructors
    //
    Memory(SystemBus&);

    // public Member functions
    //
    virtual void	reset();
    virtual void	run();

    virtual UInt32	read(UInt32);
    virtual void	write(UInt32, int, UInt32);

private:
    Memory(const Memory&);	 // Declare away
    void operator = (const Memory&);	 // Declare away

    UInt32*		 data;
};

#endif /* _Memory_h */
