/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED
 = "$Id: Isem.cpp 1.2 Mon, 11 Nov 1996 14:11:38 -0700 maccabe $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <tk.h>

#include "config.h"

#include "tkisem.h"
#include "Config.h"
#include "sizedefs.h"
#include "sys_bus.h"
#include "MMU.h"
#include "globals.h"

#include "RegBlock.h"
#include "IU.h"
#include "FPU.h"

#include "Memory.h"

#include "Isem.h"
#include "Assert.h"

/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

#ifdef __WIN32__
BOOL APIENTRY
DllEntryPoint(hInst, reason, reserved)
    HINSTANCE hInst;		/* Library instance handle. */
    DWORD reason;		/* Reason this function is being called. */
    LPVOID reserved;		/* Not used. */
{
    return TRUE;
}
#endif

/*
 *----------------------------------------------------------------------
 *
 * Example_Init --
 *
 *	This procedure initializes the example command.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

int user_steps, user_mems, super_steps, super_mems;

// AssertFunction - This function is called by the "Assert" macro.
//
void AssertFunction(const char* msg, const char* file, int line) 
{
    fprintf( stderr, "Internal Error: '%s', file '%s', line %d\n", msg, 
	     file, line );
    Tcl_Exit(1);
    abort();                    // Not reached (hopefully!)
}


RegisterBlock*		RB;
IntegerUnit*		iu;
FloatingPointUnit*	fpu;
MMU*			mmu;

//   Construct the system bus.  The system bus divides
// the address space up by pages.  This makes accessing
// the correct device fairly efficient.
//
//   At some point in the future, the system bus will
// probably be responsible for managing interrupts, but
// for now it's just used for device manangement.
//
SystemBus*	sbus;

int ExceptionOccurred = 0;
int SuperStep = 0;

Tcl_Channel Input, Output;

EXPORT(int,Tkisem_Init)( Tcl_Interp *interp)
{
#ifdef MESSAGE
    cout << hex;
    cerr << hex;

    cout << endl;
    cout << "Instructional SPARC Emulator" << endl;
    cout << "ISEM - Instructional Sparc EMulator and tkisem"  <<endl;
    cout << "Copyright (C) 1993, 1994, 1995, 1996" << endl;
    cout << "Department of Computer Science," << endl;
    cout << "The University of New Mexico" << endl;
    cout << "ISEM comes with ABSOLUTELY NO WARRANTY" << endl << endl;

    extern char* DateString;
    cout << "ISEM Version " TKISEM_VERSION ": " << DateString << endl;
    cout << endl;
#endif

    // add isem specific commands to the interpreter
    Tcl_CreateCommand( interp, "isem_load", Isem_Load, NULL, NULL );
    Tcl_CreateCommand( interp, "isem_disasm", Isem_Disasm, NULL, NULL );

    Tcl_CreateCommand( interp, "isem_step", Isem_Step, NULL, NULL );
    Tcl_CreateCommand( interp, "isem_interp", Isem_Interp, NULL, NULL );
    Tcl_CreateCommand( interp, "isem_poll", Isem_Poll, NULL, NULL );
    Tcl_CreateCommand( interp, "isem_usteps", Isem_Usteps, NULL, NULL );
    Tcl_CreateCommand( interp, "isem_tsteps", Isem_Tsteps, NULL, NULL );
    Tcl_CreateCommand( interp, "isem_counts", Isem_Counts, NULL, NULL );

    Tcl_CreateCommand( interp, "isem_annul", Isem_Annul, NULL, NULL );
    Tcl_CreateCommand( interp, "isem_device", Isem_Dev, NULL, NULL );
    Tcl_CreateCommand( interp, "isem_gx", Isem_GX, NULL, NULL );
    Tcl_CreateCommand( interp, "isem_reg", Isem_Reg, NULL, NULL );
    Tcl_CreateCommand( interp, "isem_mem_rd", Isem_Mem_Rd, NULL, NULL );
    Tcl_CreateCommand( interp, "isem_mem_wr", Isem_Mem_Wr, NULL, NULL );
    Tcl_CreateCommand( interp, "isem_interrupt", Isem_Inter, NULL, NULL );

    //   Construct and install physical memory.  The size should
    // probably be restricted to an even number of pages.
    //
    sbus = new SystemBus();

    static Memory mem(*sbus);
    sbus->install(&mem);

    //   Construct the memory managment unit.  The MMU is the 
    // interface between the interger unit and the system bus.
    //
    mmu = new MMU(*sbus);

    //
    // divide physical memory into four equal pieces
    //
    int npages = (Config::PHYS_MEM_SIZE >> (Config::ISEM_PAGE_BITS - 10)) >> 2;
    int pageTableEntry;
    int i = 0;
    
    for (pageTableEntry = 0; i < npages; i++, pageTableEntry += 4)
	mmu->write(0, pageTableEntry, 0xF, i);

    for (pageTableEntry = 0; i < 2*npages; i++, pageTableEntry += 4)
	mmu->write(1, pageTableEntry, 0xF, i);

    for (pageTableEntry = 0; i < 3*npages; i++, pageTableEntry += 4)
	mmu->write(2, pageTableEntry, 0xF, i);

    for (pageTableEntry = 0; i < 4*npages; i++, pageTableEntry += 4)
	mmu->write(3, pageTableEntry, 0xF, i);

    //
    // Construct integer unit;
    //
    RB = new RegisterBlock(Config::NWINDOWS);
    iu = new IntegerUnit(Config::NWINDOWS, *sbus, *mmu, *RB);

    //
    // Construct floating point unit
    //
    fpu = new FloatingPointUnit();


    // ???? int catchint = signal(SIGINT, SIG_IGN) != SIG_IGN;
    // setbuf(stdout, NULL);

    // reset integer and floating point units
    //
    iu->reset();
    fpu->reset();

    // setup the Input and Output channels
    //
    // Sat Jan 13 18:17:15 2001 Ackley was:
    // Input = Tcl_MakeFileChannel( 0, 0, TCL_READABLE );
    //Input = Tcl_MakeFileChannel( 0, TCL_READABLE );
    //Output = Tcl_MakeFileChannel( (void *)1, TCL_WRITABLE );
    Input = Tcl_GetStdChannel(TCL_STDIN);
    Output = Tcl_GetStdChannel(TCL_STDOUT);

    Assert(Input,"Failed to make Input channel");
    Assert(Output,"Failed to make Output channel");

    Tcl_SetChannelOption( interp, Output, "-buffering", "none" );

    return Tcl_PkgProvide(interp, "isem", "1.0");
}
