/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED
 = "$Id: isemInt.cpp 1.2 Mon, 11 Nov 1996 14:11:38 -0700 maccabe $";

// -- isemInter.C -------------------------------------------------------------
//
// Raise or lower an interrupt
// 

#include <stdio.h>
#include <stdlib.h>             /* for strtoul */ 
#include <tk.h>

#include "config.h"

#include "sizedefs.h"
#include "sys_bus.h"

#include "globals.h"

int Isem_Inter( ClientData, Tcl_Interp *interp, int argc, char *argv[] ) {
    //
    // isem_interrupt level state
    //
    // raise or lower an interrupt line
    //
    if( argc != 3 ) {
	sprintf( interp->result, "isem_dev:  invalid number of arguments: %d",
		 argc );
	return TCL_ERROR;
    }

    int level, state;

    level = strtoul(argv[1],0,0);
    state = strtoul(argv[2],0,0);
    
    if( state == 0 ) {
	sbus->bp_IRL_lower(level);
    } else {
	sbus->bp_IRL_raise(level);
    }

    return TCL_OK;
}
