/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED
 = "$Id: isemMem.cpp 1.2 Mon, 11 Nov 1996 14:11:38 -0700 maccabe $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tk.h>

#include "config.h"

#include "sizedefs.h"
#include "MMU.h"

#include "globals.h"

int Isem_Mem_Rd( ClientData, Tcl_Interp *interp, int argc, char *argv[] ) {
    //
    // usage:
    //    isem_mem_rd ( super | user ) ( data | text ) address [address2]
    //

    int space;
    int istext = 0;

    if( strncmp( argv[1], "super", 5 ) == 0 ) {
	if( strcmp( argv[2], "data" ) == 0 ) {
	    space = AS_S_DATA;
	} else {
	    space = AS_S_TEXT;
	    istext = 1;
	}
    } else {
	if( strcmp( argv[2], "data" ) == 0 ) {
	    space = AS_U_DATA;
	} else {
	    space = AS_U_TEXT;
	    istext = 1;
	}
    }

    UInt32 address;
    address = strtoul( argv[3], 0, 0 );

    if( argc == 4 ) {
	UInt32 res = mmu->read( space, address );
	sprintf( interp->result, "0x%.8x", res );
    } else {
	UInt32 address2;
        address2 = strtoul( argv[4], 0, 0 );

	if( istext ) {
	    while( mmu->read( space, address2 ) == 0 ) {
		address2 -= 4;
	    }
	}

	for( unsigned i = address; i <= address2 ; i+=4 ) {
	    char buf[20];
	    UInt32 res = mmu->read( space, i );
	    sprintf( buf, "0x%.8x", res );
	    Tcl_AppendElement( interp, buf );
	}
    }


    return TCL_OK;
}


int Isem_Mem_Wr( ClientData, Tcl_Interp *interp, int argc, char *argv[] ) {
    //
    // usage:
    //    isem_mem_wr ( super | user ) ( data | text ) address value 
    //
    if( argc != 5 ) {
	sprintf( interp->result, "isem_mem_wr:  invalid number of "
		 "arguments: %d", argc );
	return TCL_ERROR;
    }

    int space;
    int istext = 0;
    int bitmask = 0xf;
    int value;

    if( strncmp( argv[1], "super", 5 ) == 0 ) {
	if( strcmp( argv[2], "data" ) == 0 ) {
	    space = AS_S_DATA;
	} else {
	    space = AS_S_TEXT;
	    istext = 1;
	}
    } else {
	if( strcmp( argv[2], "data" ) == 0 ) {
	    space = AS_U_DATA;
	} else {
	    space = AS_U_TEXT;
	    istext = 1;
	}
    }

    UInt32 address;
    address = strtoul( argv[3], 0, 0 );

    value = strtoul( argv[4], 0, 0 );

    mmu->write( space, address, bitmask, value );

    return TCL_OK;
}

