!
!     Simple Fibonacci Sequence Function
!     Author:  Dave Osborn
!     Remarks:  Program performs the Fibonacci Sequence
!               fib(N) = 1;   N <= 2
!               fib(N) = fib(N-1) + fib(N-2)
!
!               This program is intended as a simple test of a recursive
!               program on ISEM.  It also provides an example of how to
!               write a recursive assembly program on the SPARC.
!
	.data
prompt:	.asciz	"Starting\n"
p2:	.asciz	"got a number\n"
	.align	8
stack_top:
	.skip	2048		! allocate space for the stack
stack_bot:

	.text
	.proc
	.global main
main:
	set	stack_bot-96, %sp	! establish the stack and a minimum
					!  stack frame for the main function

	set	prompt, %o0
	ta	6

	ta	5			! read a number from input

	set	p2, %o0
	ta	6


	call    fib			! call fib(N)
	nop				! fill delay slot


	ta	4			! print the result
exit:
	ta	0			! terminate program

!
!     Fibonacci Subroutine.
!     Register Usage
!        i0   :     Number of the Fibonacci Sequence to compute.
!        l1   :     Local Temporary for storing intermediary result
!                   from first call.
!        o0   :     Local Copy of i0, also used to return the
!                   result of the computation.
!
fib:
	save    %sp,-96,%sp		! Save the window registers
	mov     %i0,%o0			! Load N for manipulation
	cmp     %o0,2			! N <= 2?
	bg      recurse			! Nope, recurse
	nop				! fill delay slot
	mov     0x1,%o0			! return 1
	b       finis			! we are done
	nop				! fill delay slot

recurse:
	sub     %o0,2,%o0		! N - 2
	call    fib,1			! call fib(N - 2)
	nop				! fill delay slot
	mov     %o0,%l1			! save result for later
	mov     %i0,%o0			! reload N
	sub     %o0,1,%o0		! N - 1
	call    fib,1			! call fib(N - 1)
	nop				! fill delay slot
	add     %o0,%l1,%o0		! fib(N - 1) + fib(N - 2)
	
finis:
	mov     %o0,%i0			! return result
	ret				! we're outta here
	restore				! restore old register window
