	
! user.s - this is the user level code used to test the timer device
!
!	this file should be loaded before the supervisor code has been
!	loaded. 
!
!
!	One word of caution.... make sure that the user level program
!		starts at location 0x20 -- or change the definition
!		of MAIN in the start_timer. code

	SAFE = 4000	! the address of a safe location in the user's
			! data segment -- the timer interrupt will
			! increment this value


	!----------------------------------------------------------------------
	! start:
	!	just wait for a wile and print the value in
	!	memory location 4
	!
	.text
	.global start
start:
	! clear the value in memory location 4000
	set	SAFE, %i0
	clr	[%i0]


	! set up the outer loop
	set	20, %l0
top_outer:	
	
	! inner delay loop
	set	400, %l1
	deccc	%l0
top_inner:
	bne	top_inner
	deccc	%l1

	! report the value in memory location 4000
	ld	[%i0], %o0
	ta	4
	
	deccc	%l0
	bne	top_outer
	nop
	
	ta	0

