[comment {-*- tcl -*- doctools manpage}]
[manpage_begin datefield n 0.2]
[copyright {Keith Vetter <keith@ebook.gemstar.com>}]
[moddesc {Tk datefield widget}]
[titledesc {Tk datefield widget}]
[require Tk]
[require datefield [opt 0.2]]
[description]

The [package datefield] package provides the datefield widget which
is an enhanced text entry widget for the purpose of date entry. Only
valid dates of the form MM/DD/YYYY can be entered.

[para]

The datefield widget is, in fact, just an entry widget with
specialized bindings. This means all the command and options for an
entry widget apply equally here.


[section COMMANDS]

[list_begin definitions]
[call [cmd ::datefield::datefield] [arg widgetpath] [opt [arg options]]]

Creates and configures a date field widget.

[list_end]


[section OPTIONS]

See the [cmd entry] manual entry for details on all available options.

[section EXAMPLE]
[example {
 package require datefield
 
 wm title . "Datefield example"
 proc DayOfWeek {args} {
     set now [clock scan $::myDate]
     set ::myDate2 [clock format $now -format %A]
 }
 trace variable myDate w DayOfWeek
 
 ::datefield::datefield .df -textvariable myDate
 label .l1 -text "Enter a date:"   -anchor e
 label .l2 -text "That date is a:" -anchor e
 label .l3 -textvariable myDate2 -relief sunken -width 12
 
 grid .l1 .df -sticky ew
 grid .l2 .l3 -sticky ew
 focus .df
}]

[see_also entry(n) clock(n)]
[keywords entry widget clock]
[manpage_end]
