[comment {-*- tcl -*- ntextBindings manpage}]
[manpage_begin ntextBindings n 1.0]
[moddesc   {Alternative Bindings for the Text Widget}]
[titledesc {Alternative Bindings for the Text Widget}]
[require Tcl 8.5]
[require Tk 8.5]
[require ntext [opt 1.0]]
[description]

The [package ntext] package provides a binding tag named [emph Ntext] for use by text widgets in place of the default [emph Text] binding tag.

[para]

The [emph Text] binding tag provides around one hundred bindings to the text widget (the exact number is platform-dependent).  A few of these behave in a way that is different from most contemporary text-editing applications.  [emph Ntext] aims to provide more familiar behaviour.
[para]
Features of the [emph Ntext] bindings that differ from the default [emph Text] bindings:

[list_begin itemized]

[item] Clicking near the end of a (logical) line moves the cursor to the end of that line [emph {(not the start of the next line)}].  If the widget is in [arg -wrap] [arg word] mode, the same rule applies to display lines.

[item] Double-clicking or dragging near the end of a (logical) line will highlight/select characters from the end of that line [emph {(not the next line, or the region at the end of the line where there are no characters)}].  If the widget is in [arg -wrap] [arg word] mode, the same rule applies to display lines.

[item] On windowing systems other than macOS Aqua, the [emph Home] key implements "Smart Home" (successive keypresses move the cursor to the start of the display line, then to the first non-whitespace character at the start of the logical line, then toggles between the beginning and end of leading whitespace); the [emph End] key implements "Smart End" (which is similar to "Smart Home").  On macOS Aqua, this functionality is provided by the operations <Command-Left> and <Command-Right>.

[item] When a selection exists, a "Paste" operation (e.g. <Control-v>) overwrites the selection (as most editors do), and does so on all platforms.

[item] On windowing systems other than macOS Aqua, the [emph Insert] key toggles between "Insert" and "Overwrite" modes for keyboard input.  [emph {(In contrast, the Text binding tag uses}] Insert [emph {as a method to paste the "primary selection", a task that can be accomplished instead by mouse middle-click.)}]

[item] The [emph Escape] key clears the selection.

[item] On the macOS Aqua windowing system, [emph Ntext] follows Aqua conventions for keyboard navigation.  Certain bindings related to vertical scrolling can be forced to behave in the same way as for the Windows and X11 windowing systems, by setting [var ::ntext::classicParagraphs] to [const 1] (see Section [sectref {CONFIGURATION OPTIONS}]).

[item] On the macOS Aqua windowing system, [emph Ntext] follows Aqua conventions for placement of the insert mark when keyboard navigation cancels a selection.  This behavior can be switched off by setting [var ::ntext::classicSelection] to [const 1] (see Section [sectref {CONFIGURATION OPTIONS}]).

[item] Selecting with <Shift-Button1> selects from the previous position of the insertion cursor. [emph {(In the Text binding tag, the selection anchor may be the position of the previous mouse click.)}]

[item] <Shift-Button1> operations do not alter the selection anchor. [emph {(In the Text binding tag, they do.)}]

[item] By default, the [emph Ntext] binding tag does not provide several of the Control-key bindings supplied by the [emph Text] binding tag.  Modern keyboards offer alternatives, such as cursor keys for navigation; modern applications often use the Control-key bindings for other purposes (e.g. <Control-p> for "print").

[list_end]

In the last three cases, the behavior of [emph Text] is often useful, so [emph Ntext] gives you the option of retaining it, by setting variables defined in the ::ntext namespace to 1 (instead of their default 0).  Explaining these features in more detail:

[list_begin itemized]
[item] If the mouse is clicked at position A, then the keyboard is used to move the cursor to B, then shift is held down, and the mouse is clicked at C: the [emph Text] binding tag gives a selection from A to C; the [emph Ntext] gives a selection from B to C.  If you want [emph Ntext] to behave like [emph Text] in this respect, set [var ::ntext::classicMouseSelect] to 1.

[item] The [emph Text] binding tag allows successive <Shift-Button-1> events to change both ends of the selection, by moving the selection anchor to the end of the selection furthest from the mouse click.  Instead, the [emph Ntext] binding tag fixes the anchor, and multiple Shift-Button-1 events can only move the non-anchored end of the selection.  If you want [emph Ntext] to behave like [emph Text] in this respect, set [var ::ntext::classicAnchor] to 1.  In both [emph Text] and [emph Ntext], keyboard navigation with the Shift key held down alters the selection and keeps the selection anchor fixed.

[item] The following "extra" [emph Text] bindings are switched off by default, but can be activated in [emph Ntext] by setting [var ::ntext::classicExtras] to 1: <Control-a>, <Control-b>, <Control-d>, <Control-e>, <Control-f>, <Control-h>, <Control-i>, <Control-k>, <Control-n>, <Control-o>, <Control-p>, <Control-t>, <Control-space>, <Control-Shift-space>.

[list_end]

[section {CONFIGURATION OPTIONS}]

[emph Ntext] provides alternatives to a number of behaviours of the classic [emph Text] binding tag.  Where there is an option, the [emph Ntext] behaviour is switched on by default, except for display-line indentation which is discussed on a separate page at [term ntextIndent].

[para]

The behaviour of [emph Ntext] may be configured application-wide by setting the values of a number of namespace variables:
[para]
[var ::ntext::classicAnchor]
[list_begin itemized]
[item]
   [const 0] - (default value) selects [emph Ntext] behaviour, i.e. the anchor point is fixed
[item]
   [const 1] - selects classic [emph Text] behaviour, i.e. the anchor point is variable
[list_end]
[para]
[var ::ntext::classicExtras]
[list_begin itemized]
[item]
   [const 0] - (default value) selects [emph Ntext] behaviour, i.e. several "extra" [emph Text] bindings are de-activated
[item]
   [const 1] - selects classic [emph Text] behaviour, i.e. the "extra" [emph Text] bindings are activated
[list_end]
[para]
[var ::ntext::classicMouseSelect]
[list_begin itemized]
[item]
   [const 0] - (default value) selects [emph Ntext] behaviour, i.e. the anchor point for mouse selection operations is moved by keyboard navigation
[item]
   [const 1] - selects classic [emph Text] behaviour
[list_end]

[para]
[var ::ntext::classicParagraphs]
[list_begin itemized]
[item]
   [const 0] - (default value) on macOS Aqua, certain keyboard bindings are made to behave in the same way as the Mac application TextEdit.  The bindings involve vertical scrolling of the screen and are <?Shift-?Option-(Up|Down)>.
[item]
   [const 1] - on macOS Aqua, certain keyboard bindings are made to behave in the same way as for the Windows and X11 windowing systems and the classic [emph Text], ignoring the conventions of Aqua.  The bindings involve vertical scrolling of the screen and are <?Shift-?Option-(Up|Down)>.
[list_end]

[para]
[var ::ntext::classicSelection]
[list_begin itemized]
[item]
   [const 0] - (default value on macOS Aqua) selects Mac-like behaviour, i.e. when a navigation keystroke cancels a selection, the insert mark first moves to the end of the selection determined by the navigation direction of the keystroke, and then the keystroke is applied.
[item]
   [const 1] - (default value except on macOS Aqua) selects PC-like behaviour (the same as classic [emph Text]), i.e. when a navigation keystroke cancels a selection, the insert mark is not moved before the keystroke is applied.
[list_end]
[para]
[var ::ntext::overwrite]
[list_begin itemized]
[item]
   [const 0] - (initial value) text typed at the keyboard is inserted into the widget
[item]
   [const 1] - text typed at the keyboard overwrites text already in the widget
[item]
   The value is toggled by the [emph Insert] key.
[list_end]

[para]
[var ::ntext::useBlockCursor]
[list_begin itemized]
[item]
   [const 0] - the block cursor will not be used.  When the widget is in [emph overwrite] mode (see [const ::ntext::overwrite]), the ordinary cursor will change color instead.
[item]
   [const 1] - the block cursor will be used when the widget is in [emph overwrite] mode (see [const ::ntext::overwrite]).
[item]
   The default value depends on the version of [const Tk].  In versions of [const Tk] earlier than [const 8.5.12], the sizing of the block cursor had a bug, and [var ::ntext::useBlockCursor] defaults to [const 0].  From [const 8.5.12] onwards the bug is fixed, and [var ::ntext::useBlockCursor] defaults to [const 1].
[list_end]

[section INTERNALS]

In order to remain independent of the version of [package Tk] (8.5 or 8.6), [package ntext] defines its own virtual events.  These new virtual events are used only in the [emph Ntext] binding tag, and therefore do not interfere with the real or virtual events used in other code.
[para]

These events include <<NtextCut>>, <<NtextCopy>>, <<NtextPaste>> which are used in place of <<Cut>>, <<Copy>>, <<Paste>> respectively.
[para]

The definition of the virtual event <<NtextCut>> (etc) is similar to that of <<Cut>> (etc) in [package Tk] 8.6.


[section BUGS]

This version of [package ntext] is intended to be compatible with all releases of [package Tk] 8.5 and 8.6, and with the branches [emph core-8-5-branch], [emph core-8-6-branch], and [emph trunk] in the source code repository for [package Tk].  Any incompatibility with any of these versions, for any [package Tk] windowing system, should be reported as a bug. Please report such in the category [emph ntext] of the [uri http://core.tcl.tk/tklib/reportlist {Tklib Trackers}].

[section EXAMPLE]

To use [emph Ntext] but keep classic [emph Text] 's variable-anchor feature:
[example {
package require ntext
text .t
set ::ntext::classicAnchor 1
bindtags .t {.t Ntext . all}
}]


[see_also ntext]
[see_also ntextIndent]
[see_also text bindtags]
[keywords text bindtags]
[manpage_end]
