[vset VERSION 1.0.2]
[comment {-*- tcl -*- doctools manpage}]
[manpage_begin khim n [vset VERSION]]
[keywords character]
[keywords i18n]
[keywords input]
[keywords international]
[keywords method]
[moddesc   {Kevin's Hacky Input Method}]
[titledesc {Provides key bindings for entering international characters on a keyboard that does not support them}]
[require Tcl]
[require khim [opt [vset VERSION]]]
[description]

This package provides a set of key bindings to allow
a user to enter arbitrary characters on a keyboard that
does not support them.  It works by designating some seldom-used key
of the keyboard as a "Compose" key (this key is distinct from any key
so labeled, and is often "Pause," "F12" or "L2"), and having the
"Compose" key, followed by a two-key sequence, have the effect of
inserting some character in a widget.
In addition, the "Compose" key, when struck twice in succession,
brings up a dialog containing a Unicode character map, allowing
arbitrary characters to be inserted.

[para]

The vast bulk of the package's functionality is implemented in a
single bindtag, [const KHIM].  An application can request that any
text or entry widget use the package to allow for entry of arbitrary
characters by placing this binding tag ahead of the [const Text] or
[const Entry] binding tag for the widget:

[example {
text .t -width 80 -height 24
bindtags .t {.t KHIM Text . all}
}]

Note that the [const KHIM] tag must precede the [const Text] or
[const Entry] class binding, or the package will not function
correctly.

[section "PROCEDURES"]

In addition to commands supporting the KHIM binding tag, the following
commands are exported from the package:

[list_begin definitions]

[call [cmd ::khim::getOptions] [arg path]]

Posts a top-level modal dialog with the path name [arg path] that
prompts the user for KHIM options.  The user is allowed to reconfigure
the key sequences for the "Compose" key, change the choice of key to
use for the "Compose" function, and enable/disable the KHIM key
bindings entirely.

[call [cmd ::khim::getConfig]]

Returns a Tcl script that restores the current configuration of KHIM:
the enabled/disabled state, the choice of "Compose" key, and the key
sequences that may be composed.  This script is designed to be
saved to a configuration file for use in a subsequent invocation of
the same application:

[example {
# Save KHIM configuration
set f [open ~/.khimrc w]
puts $f [::khim::getConfig]
close $f

# Restore KHIM configuration
source ~/.khimrc
}]

[call [cmd ::khim::setConfig] [arg version] [arg enabled] [arg compose] \
[arg map]]

Restores an earlier saved configuration.  Few, if any, applications
will call this command in any other way than to evaluate it as
returned from [cmd ::khim::getConfig].

[call [cmd ::khim::showHelp] [arg path]]

Displays a top-level dialog giving user-level help for KHIM; the
dialog will have the path name [arg path].

[list_end]

[section LOCALISATION]

[para]

Programmers who wish to make KHIM available in a non-English-speaking
locale may do so by providing a [const .msg] file with the appropriate
localised text.  The catalog requires the following messages:

[list_begin definitions]

[def [const Apply]]
Text that will appear on the "Apply" button in the dialog that sets
KHIM options.

[def [const Cancel]]
Text that will appear on the "Cancel" button in several dialogs.

[def [const Change]]
Text that will appear on the "Change" button, which alters the binding
of a pair of composed characters (creating or replacing as
appropriate).

[def [const Character]]
Text that will appear on the label of the entry widget that accepts a
character resulting from a composed sequence.

[def [const {{Compose Key}}]]
Window title for a dialog that prompts the user to strike the key that
will be used for the "Compose" key.

[def [const {{Compose key:}}]]
Label that identifies a component showing the "Compose" key choice in
the KHIM options dialog.

[def [const {{Composed sequence must be two characters long}}]]
Error message that is displayed if the user attempts to define a
"Compose" sequence that is shorter or longer than two characters.

[def [const Delete]]
Text for a button that deletes a "Compose" sequence.

[def [const Help...]]
Text for a button that displays the KHIM user help dialog.

[def [const HELPTEXT]]
Complete text for the user-level help for KHIM.  Refer to
[file en.msg] for the English-language version of the help.

[def [const {{Input key sequence}}]]
Text for a label of the entry widget that prompts the user for a
two-character sequence to use with the "Compose" key.

[def [const {{Insert Character}}]]
Window title of the dialog box that displays a Unicode character map
and prompts the user to select a character to insert.

[def [const {{Key sequences}}]]
Text for a label at the head of a listbox showing the composed
sequences that are currently bound.

[def [const {{KHIM Controls}}]]
Window title for the dialog box that prompts for KHIM settings.

[def [const {{KHIM Help}}]]
Window title for the window that display help text for KHIM.

[def [const OK]]
Label for the OK button on several dialogs.

[def [const {Select code page:}]]
Label for a spinbox that prompts the user for a Unicode code page number.

[def [const {SELECT COMPOSE KEY}]]
A message, which should be composed in short lines, prompting the user
to press the key that will become the "Compose" key in KHIM.

[def [const Unicode...]]
Text for a button that brings up the character map to select the
character to which a composed sequence binds.

[def [const {{Use KHIM}}]]
Text for a checkbutton that asks whether the user wishes to use KHIM
to manage composed key sequences.

[list_end]

[section ACKNOWLEDGMENTS]

KHIM was originally inspired by the key bindings that Brent Welch
developed for the 'sedit' editor used in the 'exmh' mail user agent.
The code for KHIM is entirely separate from that for 'sedit'.
[vset CATEGORY khim]
[include ../../support/devel/doc/feedback.inc]
[manpage_end]
