proc new_group_request { group reload } {
	global C_GROUP C_HOST
	global  GR_${group}_Master
	if { $C_GROUP == $group && !$reload} {
		.status.lbl configure -text "Allready in this Group."
		return 0
		}

	.groups configure -cursor watch
	SetStatus "+BUSY"

	.remote configure -state normal
	.remote delete 1.1 end
	.remote configure -state disabled

	.hosts configure -state normal
	.hosts delete 1.1 end
	.tlt configure -text "Hosts in $group"
	global GR_${group}_List
	foreach host [set GR_${group}_List] {
		if { $host != "" } {
			.hosts insert end $host item
			.hosts insert end " \n "
			}
		}
	.hosts configure -state disabled

	.shares configure -state normal
	.shares delete 1.1 end
	set_current C_HOST  .hosts  [set GR_${group}_Master ]
	set_current C_GROUP .groups $group
	.trmlt configure -text "Shares on $C_HOST"

	global UC_HOST UC_GROUP
	set UC_HOST  $C_HOST
	set UC_GROUP $C_GROUP
	global H_${C_HOST}_Shares
	global H_${C_HOST}_Browse
	if {[def H_${C_HOST}_Shares]} {
		foreach share [set H_${C_HOST}_Shares] {
			if { $share != ""} {
				.shares insert end $share item
				.shares insert end " \n "
				}
			}
		}
	if { [set H_${C_HOST}_Browse] == "failed" &&!$reload} {
		.shares insert end "<FAILED>"
		}
	.shares configure -state disabled

	set brz [ set H_${C_HOST}_Browse ]
	if { $brz == "host" || $brz == "no" || $reload } {
		viewhost $C_HOST $C_GROUP 0
		}
	SetStatus "-BUSY"
	.groups configure -cursor hand2
	}

proc new_host_request { host reload } {
global C_HOST C_GROUP
if { $C_HOST == $host && !$reload} {
	.status.lbl configure -text "Allready in this Host."
	return 0
	}
global H_${host}_Shares
global H_${host}_Browse
SetStatus "+BUSY"
.hosts configure -cursor watch

.remote configure -state normal
.remote delete 1.1 end
.remote configure -state disabled

.shares configure -state normal
.shares delete 1.1 end
set_current C_HOST .hosts $host
.trmlt configure -text "Shares on $C_HOST"
global UC_HOST UC_GROUP
set UC_HOST  $C_HOST
set UC_GROUP $C_GROUP
if {[def H_${host}_Shares]} {
	foreach share [set H_${host}_Shares] {
		if { $share != ""} {
			.shares insert end $share item
			.shares insert end " \n "
			}
		}
	}
if { [set H_${C_HOST}_Browse] == "failed" && !$reload} {
	.shares insert end "<FAILED>"
	}
.shares configure -state disabled
if { [ set H_${host}_Browse ] == "no" || $reload } {
        viewhost $host $C_GROUP 0
        }
SetStatus "-BUSY"

.hosts configure -cursor hand2

}

proc nmblookup_simple { host serv } {
	if { $serv == "" || $serv == "No" } {spawn -nottyinit nmblookup $host} else {spawn -nottyinit nmblookup $host -B $serv }
	set id $spawn_id
	expect {
		 -i $id "querying $host" {
		 	exp_continue
		 }
		 -i $id     "failed" {
			catch { close -i $id }
			wait  -i $id
			puts "ip not known"
			return "" 
			}
		 -i $id -re "(\[^\n\]*) $host" {
			puts $expect_out(1,string)
			catch { close -i $id }
			wait  -i $id
			set ip $expect_out(1,string)
			puts "ip is $ip"
			if { $ip == "255.255.255.255" } { set ip "" }
			return $ip
			}
		}
	catch { close -i $id }
	wait  -i $id
	return {}
	}

proc nmblookup { host } {
global H_${host}_IP
defifndef H_${host}_IP ""
set ip [set H_${host}_IP]
if {$ip == "No"} {return ""}
if {$ip != ""} {return $ip}

global BROADCAST
set ip [nmblookup_simple $host $BROADCAST]
if { $ip != ""} {
	set H_${host}_IP $ip
	return $ip
	}
catch {
	global C_GROUP
	global GR_${C_GROUP}_Master
	set master [set GR_${C_GROUP}_Master]
	global H_${master}_IP
	set gip [set H_${master}_IP]
	set ip [nmblookup_simple $host $gip]
	}
set H_${host}_IP $ip
if { $ip == "" } { set H_${host}_IP "No" }
return $ip
}

proc host_ping_request { host } {
	puts "pinging $host...."
	nmblookup $host
	}


proc password { msg } {
	global font spawn_id
        toplevel .pass
        label .pass.l -text "$msg" -font $font
        entry .pass.foo -font $font -textvariable password
        wm geometry .pass 300x50
        pack .pass.l   -side top -fill x
        pack .pass.foo -side top -fill x
	bind .pass.foo <Return> {
        	exp_send "$password\r"
		destroy .pass
		}

}

proc mount { host share } {
global H_${host}_IP netbiosname spawn_id USERNAME PASSWORD smbmountVer smbmountVariant smbmountNew smbmountOld mountparams MountRoot C_GROUP
set ip [set H_${host}_IP]
catch { exec mkdir $MountRoot/${host}}
catch { exec mkdir $MountRoot/${host}/$share }


if { $smbmountVer == 2 } {
   if { $smbmountVariant == 2 } {
      if { $ip == "" || $ip == "No" } {
	spawn $smbmountNew //$host/$share -U $USERNAME -W $C_GROUP -c "mount $MountRoot/$host/$share $mountparams"
      } {
	spawn $smbmountNew //$host/$share -U $USERNAME -I $ip -W $C_GROUP -c "mount $MountRoot/$host/$share $mountparams"
      }
   } {
      if { $ip == "" || $ip == "No" } {
	spawn $smbmountOld //$host/$share $MountRoot/${host}/$share -U $USERNAME $mountparams
      } {
	spawn $smbmountOld //$host/$share $MountRoot/${host}/$share -U $USERNAME -I $ip $mountparams
      }
   }
} {
   if { $ip == "" } {
	spawn $smbmountOld //$host/$share $MountRoot/${host}/$share -U $USERNAME -c $netbiosname $mountparams
   } {
	spawn $smbmountOld //$host/$share $MountRoot/${host}/$share -U $USERNAME -I $ip -c $netbiosname $mountparams
   }
}

set id $spawn_id
set repeat 0
expect {
	-i $id "Password" {
		#password "Enter Password"
		set passwd [makepasswd $host $share 2]
		exp_send "$passwd\r"
		exp_continue
		puts "Password sent..."
		}
	}
	catch { close -i $id }
	wait -i $id
puts Terminated
}

proc mount_all_request { HOST} {
	global H_${HOST}_Shares font H_${HOST}_Browse
	
	if { [set H_${HOST}_Browse] == "now" } {
		.status.lbl configure -text "Share list not ready for '$HOST'"
		return
		}
	if { [ndef H_${HOST}_Shares] } {
		.status.lbl configure -text "Can't get list of shares on '$HOST'"
		return
		}  
	
	if { [catch { toplevel .mnt_${HOST} }] != 0 } {
		raise .mnt_${HOST}
		return
		}
	wm title .mnt_${HOST} "Mount All on $HOST"
	frame .mnt_${HOST}.l
	frame .mnt_${HOST}.r
	set left .mnt_${HOST}.l
	set right .mnt_${HOST}.r
	foreach curr [set H_${HOST}_Shares] {
	   label ${left}.w${curr} -text $curr -font $font
	   global SH_PASS_${HOST}_${curr}
	   set SH_PASS_${HOST}_${curr} [makepasswd $HOST $curr 0]
	   entry ${right}.w${curr} -textvariable SH_PASS_${HOST}_${curr} -show "*" -font $font
	   pack ${left}.w${curr}  -side top  
	   pack ${right}.w${curr} -side top
	}
	button ${left}.button -text Mount -command "mount_all_command $HOST"
	button ${right}.button -text Cancel -command "destroy .mnt_$HOST"
	pack ${left}.button
	pack ${right}.button
	pack $left $right -side left
}

proc mount_all_command { HOST } {
	global PASSWORD H_${HOST}_Shares
	destroy .mnt_$HOST
	foreach curr [set H_${HOST}_Shares] {
		set PASSWORD 
		mount $HOST $curr
		}
	
}

