namespace eval dialog {
    variable dialog

    switch $tkWorld(ostype) {
	windows {
	    set dialog(borderwidth) 2
	    set dialog(height) 1
	    set dialog(width) 10
	}
	default {
	    set dialog(borderwidth) 1
	    set dialog(height) 1
	    set dialog(width) 5
	}
    }
}

proc dialog::create { w title {lob "Ok Reset Clear Help Close"} } {
    global tkWorld
    variable dialog

    # Build the toplevel dialog without grabbing focus if it
    # does not exists.
    if [winfo exists $w] {
	switch -- [wm state $w] {
	    normal {
		raise $w
	    }
	    withdrawn -
	    iconic {
		wm deiconify $w
	    }
	}
	focus $w
	return
    } 

    toplevel $w \
	    -borderwidth 1 \
	    -relief flat

    # Create the tabnotebook that will be used to hold everything.
    set tn [tabnotebook::create $w.tn]

    # Defind the command for each of the bottom frame buttons based
    # on the command name.
    regsub "." $w "" cmd

    # The bottom frame has the okay, reset, help and
    # cancel buttons
    set blist [frame $w.blist]
    foreach b $lob {
	set t $b
	set b [string tolower $b]
	button $blist.$b \
		-text $t \
		-borderwidth $dialog(borderwidth) \
		-width $dialog(width) \
		-height $dialog(height) \
		-command [list $cmd\:\:$b]
	switch $b {
	    ok {
		balloonhelp::for $blist.$b \
			"Insert the current command into the Command Center"
	    }
	    reset {
		balloonhelp::for $blist.$b \
			"Reset the values of the radio and checkbuttons"
	    }
	    clear {
		balloonhelp::for $blist.$b \
			"Clear the dialog entries"
	    }
	    help {
		balloonhelp::for $blist.$b \
			"View the online help for this command"
	    }
	    close {
		balloonhelp::for $blist.$b \
			"Close this command dialog"
	    }
	}
    }
    grid $blist.ok $blist.reset $blist.clear $blist.help $blist.close \
	    -sticky ew \
	    -padx 5 \
	    -pady 2

    pack $tn $blist \
	    -side top \
	    -padx 0 \
	    -pady 2 \
	    -fill x

    # Define theUnix  window manager options.
    switch $tkWorld(ostype) {
	windows -
	macintosh {
	    # Do nothing
	}
	default {
	    wm title $w  $title
	    wm iconbitmap $w \
		    @[file join $tkWorld(image_dir) cmd.xbm]
	    wm resizable $w 0 0
	}
    }

    # Return the name of the window indicating successful creation.
    return $w
}

# dialog::interior --
#
#   Method to return the interior tabnotebook frame of the parent
#   dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc dialog::interior { w } {
    return $w.tn
}

# dialog::destroy --
#
#   Method to destroy the named dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc dialog::destroy { w } {
    destroy $w
}