namespace eval log_window {
    # No private variables.
}

# log_window::home --
# log_window::end --
#
#   Method to set the view of the Log Window to the beginning/end.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc log_window::home { } {
    global tkWorld

    $tkWorld(log_window) see 1.0
}

proc log_window::end { } {
    global tkWorld

    $tkWorld(log_window) see end
}

# log_window::up --
# log_window::down --
#
#   Move the LW up/down a viewable page.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc log_window::up { } {
    global tkWorld

    $tkWorld(log_window) yview scroll -1 pages
}

proc log_window::down { } {
    global tkWorld

    $tkWorld(log_window) yview scroll +1 pages
}

# log_window::clear --
#
#   Method to remove the contents of the LW.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc log_window::clear { } {
    global tkWorld

    # Delete the text in the Log Window.
    $tkWorld(log_window) delete 1.0 end
}

# log_window::save --
#
#   Method to save the text in the Log window to a text file.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc log_window::save { } {
    global tkWorld

    # For the sake of variety, define a few default shell script types.
    set typelist {
	{"Text File" {.txt}}
	{"All Files" {*}}
    }

    # Get the filename from the user at startup
    set file_name [tk_getSaveFile \
	    -defaultextension ".txt" \
	    -filetypes $typelist \
	    -initialdir $tkWorld(user_home) \
	    -initialfile "report1" \
	    -title "Save File"]

    # Allow the user to cancel the operation.
    if ![string length $file_name] {
	return
    }

    # Open the file or display the error message.
    if [catch {open $file_name "w"} fid] {
	bell; tk_messageBox \
		-type ok \
		-message $fid \
		-icon info \
		-title "Save File Error"
	return
    }
    # Now dump the file contents without using $t dump becuase this
    # command keeps all of the special character intact which is not
    # useful in a shell script. Below is an example:
    #
    # User first types: wc -l tkworld.tcl
    # User changes to: wc -l tkWorld.tcl
    #
    # File contents:
    #
    #        wc -l tkW
    #        orld.tcl
    #
    # Not quite what we want so we use $t get instead.

    foreach line [split [$tkWorld(log_window) get 1.0 end] \n] {
	    puts $fid $line
    }

    close $fid
}

# log_window::resize --
#
#   Method to change either the height or the width of the LW.
#
# Args
#
#   type - Either the value width or height.
#   size - Numeric value for the type.
#
# Returns
#
#   None.

proc log_window::resize { type size } {
    global tkWorld

    # Either configure the height or the width, but nothing else
    switch $type {
	height -
	width  {
	    $tkWorld(log_window) configure -$type $size
	}
    }
}