/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#include "main.h"
#include "support.h"
#include "users.h"
#include "utils.h"
#include "lista.h"
#include "interface.h"
#include "callbacks.h"
#include "groups.h"
#include "conffile.h"

#include "jabby.h"


//int status_map[]={TLEN_STATUS_AVAILABLE,
//  TLEN_STATUS_CHATTY, TLEN_STATUS_DND,
//  TLEN_STATUS_AWAY, TLEN_STATUS_EXT_AWAY,
//  TLEN_STATUS_INVISIBLE, TLEN_STATUS_UNAVAILABLE};

static
gboolean hide_offline(struct user *user)
{
  if((preferences & PREF_HIDE_OFFLINE) &&
     (get_status(user) == STATUS_UNAVAILABLE))
    return TRUE;
  return FALSE;
}

void expanders_list_clear()
{
  GList *l;
  struct expander *e;

  for(l=expanders_list;l;l=l->next)
  {
    e=(struct expander*)l->data;
    g_free(e->name);
    g_free(e);
  }
  g_list_free(expanders_list);
  expanders_list=NULL;
}

//static
//void expanders_list_print()
//{
//  GList *l;
//  struct expander *e;
//
//  for(l=expanders_list;l;l=l->next)
//  {
//    e=(struct expander*)l->data;
//    printf("%s\n",e->name);
//  }
//}

static
struct expander* new_expander(gchar *name, gboolean expanded)
{
  struct expander *e;

  e=g_malloc(sizeof(*e));
  e->expanded=expanded;
  e->name=g_strdup(name);
  return e;
}

static
void add_expander(gchar *name, gboolean expanded)
{
  struct expander *e;

  e=new_expander(name, expanded);
  expanders_list=g_list_append(expanders_list,e);
}

static
void set_expanded(gchar *name, gboolean expanded)
{
  GList *l;
  struct expander *e;

  for(l=expanders_list;l;l=l->next)
  {
    e=(struct expander*)l->data;
    if(!strcmp(name,e->name))
    {
      e->expanded=expanded;
      return;
    }
  }
  add_expander(name, expanded);
}

//static
//void expanders_list_remove(gchar *name)
//{
//  GList *l;
//  struct expander *e;
//
//  for(l=expanders_list;l;l=l->next)
//  {
//    e=(struct expander*)l->data;
//    if(!strcmp(name,e->name))
//    {
//      g_free(e->name);
//      g_free(e);
//      expanders_list=g_list_remove(expanders_list,e);
//      return;
//    }
//  }
//}

static
void expanders_list_remove_dead()
{
  GList *l;
  struct expander *e;

  for(l=expanders_list;l;)
  {
    e=(struct expander*)l->data;
    l=l->next;
    if(!get_group(e->name))
    {
      g_free(e->name);
      g_free(e);
      expanders_list=g_list_remove(expanders_list,e);
    }
  }
}

static
gboolean expanded(gchar *name)
{
  GList *l;
  struct expander *e;

  for(l=expanders_list;l;l=l->next)
  {
    e=(struct expander*)l->data;
    if(!strcmp(name,e->name))
        return e->expanded;
  }
  return FALSE;
}

static
gint compare_func(gconstpointer a, gconstpointer b)
{
  struct user *u1, *u2;
  guint status1, status2;
  gchar *user1, *user2;

  u1 = (struct user*)a;
  u2 = (struct user*)b;
  status1 = get_status(u1);
  status2 = get_status(u2);
  if(status1 > status2)
    return 1;

  if(strlen(u1->name)) user1=g_strdup(u1->name);
  else user1=g_strdup(u1->jid);
  if(strlen(u2->name)) user2=g_strdup(u2->name);
  else user2=g_strdup(u2->jid);
  if(status1 == status2)
    return strcasecmp(user1, user2);

  return -1;
}

GList* sort_users(GList *l)
{
  return g_list_sort(l, compare_func);
}


//GtkTreeModel *create_model_blank(void)
//{
//  GtkListStore *store;
//
//  store = gtk_list_store_new(3, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING);
//
//  return GTK_TREE_MODEL (store);
//}

static
void create_model_add(GtkTreeStore *store, GList *l,
                      GtkTreeIter *child_iter, GtkTreeIter *iter)
{
  struct user *u;
  gchar *s, *s2;
//  GtkTreeIter desc_iter;

  while(l)
  {
    u=(struct user*) l->data;
    if(u->type != USER_AGENT)
    if(!hide_offline(u))
    if(!strcmp(u->subscription,"both") ||
       !strcmp(u->subscription,"to"))
    {
      gtk_tree_store_append (store, child_iter, iter);
      s=utf(u->name);
      if(!s)
        gtk_tree_store_set (store, child_iter,
                            0, u->status,
                            1, u->jid,
                            2, u->jid,
                            -1);
      else
      {
        gchar *d;

        d = user_description(u);
        if((preferences & PREF_INFO_MENU) && d)
        {
          gchar *a;
          a = g_markup_escape_text(d, strlen(d));
          s2 = g_strdup_printf("%s\n<span size='smaller'>%s</span>",
                               (strlen(s))?s:u->jid, a);
          g_free(a);
        }
        else
          s2 = g_strdup(strlen(s)?s:u->jid);
        g_free(d);
        gtk_tree_store_set (store, child_iter,
                            0, u->status,
                            1, s2,
                            2, u->jid,
                            -1);
        g_free(s);
        g_free(s2);
      }
    }
    l = l->next;
  }
}

static
GtkTreeModel *create_model(GList *list)
{
  GtkTreeStore *store;
  GtkTreeIter child_iter, iter;
  GList *l;
  struct user *u;
  struct group *g;
  gchar *s, *gr;
  gchar found, *path;
  gint i=0;

  store = gtk_tree_store_new(3, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING);
  //najpierw osoby zasubskrybowane
  if(preferences & PREF_GROUPS_LIST)
  {
    l=groups_list;
    for(i=0,l=groups_list;l;l=l->next,i++)
    {
      g=(struct group*)l->data;
      gr=g_strdup_printf("%s(%d/%d)",g->name,users_list_count_online(g->users),
                         users_list_count(g->users));
      s=utf(gr);
      g_free(gr);
      path=g_strdup_printf("%d",i);
      gtk_tree_store_append (store, &iter,NULL);
      gtk_tree_store_set (store, &iter,
                          0, 1,
                          1, s,
                          2, path,
                          -1);
//      g_free(s);//FIXME!!!
//      g_free(path);//FIXME!!!
      g->users=sort_users(g->users);
      create_model_add(store, g->users, &child_iter,&iter);
    }
  }
  else
    create_model_add(store, list, &child_iter,NULL);
//  gtk_tree_store_append (store, &iter,NULL);
//  gtk_tree_store_set (store, &iter,
//                      0, 0,
//                      1, "Kontakty",
//                      2, NULL,
//                      -1);
  //oczekiwanie na autoryzacje
  found=0;
  l=list;
  while(l)
  {
    u = (struct user*) l->data;
    if(((!strcmp(u->ask,"subscribe"))&&!strcmp(u->subscription,"none")) ||
       !strcmp(u->subscription,"from"))
    {
      if(!found)
      {
//        gtk_tree_store_append (store, &child_iter, &iter);
        gtk_tree_store_append (store, &iter, NULL);
        path=g_strdup_printf("%d",i++);
        gtk_tree_store_set (store, &iter,
                            0, 1,
                            1, "OCZEKIWANIE",
                            2, path,
                            -1);
//      g_free(path);//FIXME!!!
        found=1;
      }
//      gtk_tree_store_append (store, &child_iter, &iter);
      gtk_tree_store_append (store, &child_iter, &iter);
      s=utf(u->name);
      if(!s)
        gtk_tree_store_set (store, &child_iter,
                            0, u->status,
                            1, u->jid,
                            2, u->jid,
                            -1);
      else
      {
        gtk_tree_store_set (store, &child_iter,
                            0, u->status,
                            1, (strlen(s))?s:u->jid,
                            2, u->jid,
                            -1);
        g_free(s);
      }
    }
    l = l->next;
  }
  //brak autoryzacji
  found=0;
  l=list;
  while(l)
  {
    u = (struct user*) l->data;
    if(!strcmp(u->ask,""))
    if(!strcmp(u->subscription,"none"))
    {
      if(!found)
      {
//        gtk_tree_store_append (store, &child_iter, &iter);
        gtk_tree_store_append (store, &iter, NULL);
        path=g_strdup_printf("%d",i++);
        gtk_tree_store_set (store, &iter,
                            0, 1,
                            1, "BRAK AUTORYZACJI",
                            2, path,
                            -1);
//      g_free(path);//FIXME!!!
        found=1;
      }
//      gtk_tree_store_append (store, &child_iter, &iter);
      gtk_tree_store_append (store, &child_iter, &iter);
      s=utf(u->name);
      if(!s)
        gtk_tree_store_set (store, &child_iter,
                            0, u->status,
                            1, u->jid,
                            2, u->jid,
                            -1);
      else
      {
        gtk_tree_store_set (store, &child_iter,
                            0, u->status,
                            1, (strlen(s))?s:u->jid,
                            2, u->jid,
                            -1);
        g_free(s);
      }
    }
    l = l->next;
  }


  return GTK_TREE_MODEL (store);
}

void
func_pixbuf (GtkTreeViewColumn *tree_column,
             GtkCellRenderer   *cell,
             GtkTreeModel      *model,
             GtkTreeIter       *iter,
             gpointer           data)
{
  guint status;
  gchar *jid;
//  struct user *user;

  gtk_tree_model_get (model, iter,
                      0, &status,
                      -1);
  gtk_tree_model_get (model, iter,
                      2, &jid,
                      -1);
  if ((status==1) || (status==0))
    g_object_set (GTK_CELL_RENDERER (cell),
                  "visible", FALSE,
                  NULL);
  else
  {
    g_object_set (GTK_CELL_RENDERER (cell),
                  "visible", TRUE,
                  NULL);
//    user = get_user(jid);
    switch(get_type(jid))
    {
      case USER_TLEN:
        g_object_set (GTK_CELL_RENDERER (cell),
                      "pixbuf", gtk_image_get_pixbuf(GTK_IMAGE(icons[status])),
                      NULL);
        break;
      case USER_JABBER:
        g_object_set (GTK_CELL_RENDERER (cell),
                      "pixbuf",
                      gtk_image_get_pixbuf(GTK_IMAGE(j_icons[status-2])),
                      NULL);
        break;
      case USER_WP:
        g_object_set (GTK_CELL_RENDERER (cell),
                      "pixbuf",
                      gtk_image_get_pixbuf(GTK_IMAGE(wp_icons[status-2])),
                      NULL);
        break;
      case USER_GG:
        g_object_set (GTK_CELL_RENDERER (cell),
                      "pixbuf",
                      gtk_image_get_pixbuf(GTK_IMAGE(gg_icons[status-2])),
                      NULL);
        break;
    }
  }

}

void
func_text (GtkTreeViewColumn *tree_column,
             GtkCellRenderer   *cell,
             GtkTreeModel      *model,
             GtkTreeIter       *iter,
             gpointer           data)
{
  guint status;
  gchar *s;

  gtk_tree_model_get (model, iter,
                      0, &status,
                      -1);
  gtk_tree_model_get (model, iter,
                      1, &s,
                      -1);
  switch(status)
  {
    case 0://brak autoryzacji
      g_object_set (GTK_CELL_RENDERER (cell),
                  "font", "normal",
                  "scale", 0.7,
                  NULL);
      g_object_set (GTK_CELL_RENDERER (cell),
                  "text", s,
                  NULL);
      break;
    case 1://grupa
      g_object_set (GTK_CELL_RENDERER (cell),
                  "font", "bold",
                  "scale", 1.0,
                  NULL);
      g_object_set (GTK_CELL_RENDERER (cell),
                  "markup", NULL,
                  "text", s,
                  NULL);
      break;
    default://osoby
      g_object_set (GTK_CELL_RENDERER (cell),
                    "font", "normal",
                    "scale", 1.0,
                    NULL);
      g_object_set (GTK_CELL_RENDERER (cell),
                    "text", NULL,
                    "markup", s,
                    NULL);
  }
}

static
void add_columns(GtkTreeView *treeview)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
//  GtkTreeModel *model = gtk_tree_view_get_model (treeview);


  renderer = gtk_cell_renderer_pixbuf_new();
//  column = gtk_tree_view_column_new_with_attributes (NULL,
//                                                     renderer,
//                                                     0,
//                                                     NULL);
  column = gtk_tree_view_column_new();
  gtk_tree_view_column_pack_start(column, renderer, FALSE);
  gtk_tree_view_column_set_cell_data_func (column, renderer,
                                           func_pixbuf, NULL, NULL);

  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_column_pack_start(column, renderer, FALSE);
  gtk_tree_view_column_set_cell_data_func (column, renderer,
                                           func_text, NULL, NULL);
  gtk_tree_view_append_column (treeview, column);

}

void safe_expanded(GtkTreeView *treeview)
{
  GList *list;
  int i;
  struct group *g;
  GtkTreePath *treepath;
  gchar *path;

  for(i=0,list=groups_list;list;list=list->next,i++)
  {
    g=(struct group*)list->data;
    path=g_strdup_printf("%d",i);
    treepath=gtk_tree_path_new_from_string(path);
    set_expanded(g->name, gtk_tree_view_row_expanded(treeview,treepath));
    g_free(path);
  }
}

static
void reload_expanded(GtkTreeView *treeview)
{
  GList *list;
  int i;
  struct group *g;
  GtkTreePath *treepath;
  gchar *path;

  for(i=0,list=groups_list;list;list=list->next,i++)
  {
    g=(struct group*)list->data;
    path=g_strdup_printf("%d",i);
    treepath=gtk_tree_path_new_from_string(path);
    if(expanded(g->name))
      gtk_tree_view_expand_row(treeview,treepath,TRUE);
    gtk_tree_path_free(treepath);
    g_free(path);
  }
}

void refresh_list(GtkTreeView *treeview, GList **l, gboolean sort)
{
  GtkTreeModel *model;

  if(sort)
    *l=sort_users(*l);
  model=create_model(*l);
  gtk_tree_view_set_model(treeview, model);
  if(preferences & PREF_GROUPS_LIST)
    reload_expanded(treeview);
  g_object_unref (G_OBJECT (model));
}

static
GtkWidget *create_treeview(GtkWidget *cont)
{
  GtkWidget *treeview, *widget;

  widget=gtk_viewport_new (NULL, NULL);
  gtk_widget_show (widget);
  gtk_container_add (GTK_CONTAINER (cont), widget);

  treeview = gtk_tree_view_new ();
  gtk_widget_show (treeview);
  gtk_container_add (GTK_CONTAINER (widget), treeview);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview), FALSE);
  g_signal_connect (G_OBJECT (treeview), "row_activated",
                      G_CALLBACK (on_treeview_row_activated),
                      NULL);
  g_signal_connect (G_OBJECT (treeview), "button_release_event",
                      G_CALLBACK (on_treeview_button_release_event),
                      NULL);
  g_signal_connect (G_OBJECT (gtk_tree_view_get_selection(GTK_TREE_VIEW(
                                                                   treeview))),
                    "changed",
                      G_CALLBACK (on_treeview_select_row),
                      NULL);
  return treeview;
}

void refresh_gui()
{
  GtkWidget *treeview,*vbox1;
  GList *l;
  struct user *u;
  struct group *g;
  GtkWidget *widget;
  GtkWidget *scroll;
  gchar *s,*s2;
  gint i;

  vbox1 = lookup_widget(window1,"vbox");
  if(groups_list)
  {
    if((preferences & PREF_GROUPS_LIST) && treeview1)
      safe_expanded(GTK_TREE_VIEW(treeview1));
    groups_list_clear();
  }
  //bez obslugi grup lub lista
  if((preferences & PREF_GROUPS_NONE) ||
     (preferences & PREF_GROUPS_LIST))
  {
    if(notebook1)
    {
      gtk_widget_destroy(notebook1);
      notebook1=NULL;
    }
    if(!treeview1)
    {
      scroll = gtk_scrolled_window_new (NULL, NULL);
      gtk_widget_show (scroll);
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                      GTK_POLICY_AUTOMATIC,
                                      GTK_POLICY_AUTOMATIC);
      gtk_box_pack_start (GTK_BOX (vbox1), scroll, TRUE, TRUE, 0);
      treeview1=create_treeview(scroll);
      scroll1=scroll;
      add_columns(GTK_TREE_VIEW(treeview1));
    }
    if(preferences & PREF_GROUPS_NONE)
    {
      refresh_list(GTK_TREE_VIEW(treeview1),&users_list, TRUE);
      gtk_widget_realize(treeview1);
      gtk_tree_view_columns_autosize (GTK_TREE_VIEW(treeview1));
      return;
    }
  }
  if(!(preferences & PREF_GROUPS_LIST))
  {
    if(scroll1)
    {
      safe_expanded(GTK_TREE_VIEW(treeview1));
      gtk_widget_destroy(scroll1);
      scroll1=treeview1=NULL;
    }

    if(!notebook1)
    {
      notebook1 = gtk_notebook_new ();
      gtk_widget_show (notebook1);
      gtk_box_pack_start (GTK_BOX (vbox1), notebook1, TRUE, TRUE, 0);
      //  GTK_WIDGET_UNSET_FLAGS (notebook1, GTK_CAN_FOCUS);
      gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook1), TRUE);
    }
    if(preferences & PREF_GROUPS_TABS_LEFT)
      gtk_notebook_set_tab_pos(GTK_NOTEBOOK (notebook1), GTK_POS_LEFT);
    else
      gtk_notebook_set_tab_pos(GTK_NOTEBOOK (notebook1), GTK_POS_TOP);
  }
  users_list=sort_users(users_list);
//  model=create_model(users_list);
//  gtk_tree_view_set_model(GTK_TREE_VIEW(treeview), model);
//  g_object_unref (G_OBJECT (model));
  l=users_list;
  while(l)
  {
    u=(struct user*) l->data;
    if(!get_group(u->group))
      add_group(u->group);
    if(strlen(u->group) > 0)
      add_togroup(u->group,u);
    l=l->next;
  }
  if(!(preferences & PREF_GROUPS_LIST))
  {
    prepend_group("Wszyscy");
    for(l=users_list;l;l=l->next)
    {
      u=(struct user*) l->data;
      add_togroup("Wszyscy",u);
    }
  }
  else
  {
    prepend_group("Kontakty");
    for(l=users_list;l;l=l->next)
    {
      u=(struct user*) l->data;
      if(!strlen(u->group))
        add_togroup("Kontakty",u);
    }
    expanders_list_remove_dead();
//    expanders_list_print();
    refresh_list(GTK_TREE_VIEW(treeview1),&users_list, FALSE);
    gtk_widget_realize(treeview1);
    gtk_tree_view_columns_autosize (GTK_TREE_VIEW(treeview1));
    return;
  }
  l=groups_list;
  for(i=1;l;i++)
  {
    g=(struct group *)l->data;
    g->num=i;
    scroll = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_show (scroll);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    s=g_strdup_printf("%s(%d/%d)",g->name,users_list_count_online(g->users),
                      users_list_count(g->users));
    s2=utf(s);
    g_free(s);
    widget=gtk_label_new(s2);
    g_free(s2);
    s=g_strdup_printf("labelgroup%d",i);
    GLADE_HOOKUP_OBJECT(window1, widget, s);
    g_free(s);
    gtk_widget_show(widget);
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook1),scroll,widget);
    treeview=create_treeview(scroll);
    add_columns(GTK_TREE_VIEW(treeview));
    refresh_list(GTK_TREE_VIEW(treeview),&g->users, FALSE);
    g->treeview=treeview;
    l=l->next;
  }
  if(beep)
    gdk_beep();
  beep=0;
}
