/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
  DO NOT EDIT!
  THIS FILE IS GENERATED BY Unihan.txt:
    ftp://ftp.unicode.org/Public/UNIDATA/Unihan.zip
*/


#include "tomoe-unihan.h"
#include "tomoe-unihan-data.h"

void
_tomoe_unihan_create (GPtrArray *array)
{
    gint i, infos_size;

    infos_size = G_N_ELEMENTS (tomoe_unihan_infos);
    g_ptr_array_set_size (array, infos_size);
    array->len = infos_size;

    for (i = 0; i < infos_size; i++) {
        TomoeUnihanInfo info;
        TomoeChar *chr;
        gint j, len;

        info = tomoe_unihan_infos[i];

        chr = tomoe_char_new ();
        tomoe_char_set_utf8 (chr, info.utf8);

        if (info.n_strokes)
            tomoe_char_set_n_strokes (chr, info.n_strokes);

        len = info.readings_size;
        for (j = 0; j < len; j++) {
            TomoeReading *reading;
            TomoeUnihanReading reading_info;

            reading_info = info.readings[j];
            reading = tomoe_reading_new (reading_info.type,
                                         reading_info.reading);
            tomoe_char_add_reading (chr, reading);
            g_object_unref (reading);
        }

        len = info.radicals_size;
        for (j = 0; j < len; j++) {
            tomoe_char_add_radical (chr, info.radicals[j]);
        }

        len = info.variants_size;
        for (j = 0; j < len; j++) {
            tomoe_char_set_variant (chr, info.variants[j]);
        }

        len = info.meta_data_size;
        for (j = 0; j < len; j++) {
            TomoeUnihanMetaData meta_data;

            meta_data = info.meta_data[j];
            tomoe_char_register_meta_data (chr, meta_data.key, meta_data.value);
        }

        array->pdata[i] = chr;
    }
}
