-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2008  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

package Externals.Simple is

   -- Equivalent of `cat D'.
   procedure Cat (D : in String);

   -- Equivalent of `cat D1 > D2'.
   procedure Cat_Out (D1 : in String;
                      D2 : in String);

   -- Equivalent of `cat > D'.
   procedure Cat_Stdin_Out (D : in String);

   -- Equivalent of `cat D1 >> D2'.
   procedure Cat_Append (D1 : in String;
                         D2 : in String);

   -- Equivalent of `chmod P D'.
   procedure Chmod (P : in String;
                    D : in String);

   -- Equivalent of `clear'.
   procedure Clear;

   -- Equivalent of `date >> D'.
   procedure Date_Append (D : in String);

   -- Date string YmdHMS.
   function Date_String return String;

   -- date A >> D
   procedure Date_1_Append(A, D : in String);

   -- Diff --brief.  Returns true for `there are changes', false for
   -- `no changes'.
   function Diff_Brief (F1 : in String;
                        F2 : in String) return Boolean;

   -- Equivalent of `dos2unix -u D'.
   procedure Dos2Unix_U (D : in String);

   -- Equivalent of `dos2unix D'.
   procedure Dos2Unix (D : in String);

   -- Equivalent of `echo E >> D'.
   procedure Echo_Append (E : in String;
                          D : in String);

   -- Equivalent of `echo -n E >> D'.
   procedure Echo_Append_N (E : in String;
                            D : in String);

   -- Equivalent of `echo E > D'.
   procedure Echo_Out (E : in String;
                       D : in String);

   -- Equivalent of `echo -n E > D'.
   procedure Echo_Out_N (E : in String;
                         D : in String);

   -- Equivalent of `grep -i T <D1 >D2'.
   function Grep_I_InOut (T : in String;
                          D1 : in String;
                          D2 : in String) return Integer;

   -- Equivalent of `mkdir -p D'
   procedure Mkdir_P (D : in String);

   -- Equivalent of `mv -f D1 D2'
   procedure Mv_F (D1 : in String;
                   D2 : in String);

   -- View a file with a pager.
   procedure Pager (F : in String);

   -- Remove a specified file (rm -f F).
   procedure Rm_File (F : in String);

   -- Remove all the temporary files.
   procedure Rm_Tempfiles;

   -- Remove temporary files for this run.
   procedure Rm_Tempfiles_PID;

   -- Remove all the cache files.
   procedure Rm_Cachefiles;

   -- General sed invocation.  Only accepts a SINGLE argument.
   procedure Sed_InOut (A      : in String;
                        Source : in String;
                        Target : in String);

   -- Equivalent of `stty sane'.
   procedure Stty_Sane;

   -- Equivalent of `system'.
   function System (Argv : in UBS) return Integer;
   function System (Argv : in String) return Integer;

   -- Equivalent of `test -d D'
   function Test_D (D : in String) return Boolean;

   -- Equivalent of `test -f D'
   function Test_F (D : in String) return Boolean;

   -- Equivalent of `test -r D'
   function Test_R (D : in String) return Boolean;

   -- Equivalent of `test -p D'
   function Test_P (D : in String) return Boolean;

   -- Equivalent of `test -s D'
   function Test_S (D : in String) return Boolean;

   -- Guess content type of F using `file'.
   function Guess_Content_Type (F : in String) return String;

   -- Use locale charmap to get the current keymap.
   function Get_Charmap return String;

   -- Convert charmaps within a single file (F) from charset CF to
   --  charset CT.
   procedure Convert_Charmap (F, CF, CT : in String);

end Externals.Simple;
