// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                and Bison Ravi (francois.belisle@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include "BayesClassifier.h"
#include "log_add.h"

namespace Torch {


BayesClassifier::BayesClassifier(BayesClassifierMachine* machine_,DataSet* data_)
  : Trainer(machine_,data_)
{

  bayesmachine = (BayesClassifierMachine*)machine;
  n_classes = bayesmachine->n_trainers;
  
  classes = (int**) xalloc(n_classes * sizeof(int*));
  for(int i = 0;i < n_classes ;i++)
    classes[i] = (int*) xalloc(data->n_examples * sizeof(int));
  classes_n = (int*)xalloc(n_classes * sizeof(int));
}

BayesClassifier::~BayesClassifier()
{
  for(int i = 0;i < n_classes;i++)
    free(classes[i]);

  free(classes);
  free(classes_n);
}

void BayesClassifier::train(List* measurers)
{
  message("BayesClassifier: Training");

  // attribute the classes
  for (int i=0;i<n_classes;i++)
    classes_n[i] = 0;

  for (int i=0;i<data->n_examples;i++) {
    data->setExample(i);
    int c = bayesmachine->class_format->getTargetClass(data->targets);
    classes[c][classes_n[c]++] = i;
  }

  // eventually compute prior given training set
  if (bayesmachine->allocated_log_priors) {
    for (int i=0;i<n_classes;i++)
      if (classes_n[i] > 0)
        bayesmachine->log_priors[i] = - log((real)classes_n[i]);
      else
        bayesmachine->log_priors[i] = LOG_ZERO;
  }
  
  for(int c = 0;c < n_classes;c++) {
    data->pushSubset(classes[c],classes_n[c]);
    bayesmachine->trainers[c]->machine->reset();
    if (bayesmachine->trainers_measurers)
      bayesmachine->trainers[c]->train(bayesmachine->trainers_measurers[c]);
    else
      bayesmachine->trainers[c]->train(NULL);
    data->popSubset();
  }

  if (measurers) {
    test(measurers);
  }
}


}

