// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                and Bison Ravi (francois.belisle@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef BAYES_CLASSIFIER_MACHINE_INC
#define BAYES_CLASSIFIER_MACHINE_INC

#include "Machine.h"
#include "Trainer.h"
#include "ClassFormat.h"

namespace Torch {

/** BayesClassifierMachine is the machine used by the #BayesClassifier#
    trainer to perform a Bayes Classification using different distributions.
    The output corresponds to the class that is the most probable
    (using prior AND posterior information).

    @author Samy Bengio (bengio@idiap.ch)
    @author Bison Ravi (francois.belisle@idiap.ch)
 */
class BayesClassifierMachine : public Machine
{
  public:
    
    /// the number of classes corresponds to the number of #Trainer#
    int n_trainers; 

    /// the actual trainers.
    Trainer** trainers; 

    /** the log_prior probabilities of each class. default: log_priors are
        taken as the log of the proportions in the training set.
    */
    real* log_priors; 
    
    /// contains the log posterior probability plus the log prior of the class
    real* log_posteriors;
    List* list_log_posteriors;

    /// used to know if log_priors where given or allocated
    bool allocated_log_priors;

    /// the format of the data
    ClassFormat* class_format;

    /// the measurers for each individual trainer
    List** trainers_measurers; 

    /** creates a machine for BayesClassifier trainers, given a vector of
        trainers (one per class), an associate measurer for each trainer,
        a class_format that explains how the classes are coded, and an eventual
        vector (of size #n_trainers_#) containing the log of the class priors.
    */
    BayesClassifierMachine( Trainer**, int n_trainers_, List** trainers_measurers_ , ClassFormat* class_format_, real* log_priors_=NULL);
    virtual ~BayesClassifierMachine();

    /** definition of virtual functions of #Machine# */
    virtual void forward( List* inputs );
    virtual void reset();
    virtual void loadFILE( FILE* );
    virtual void saveFILE( FILE* );

};


}

#endif
