// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef DICTIONARY_INC
#define DICTIONARY_INC

#include "general.h"
#include "Object.h"

namespace Torch {

/** This class contains the dictionary of accepted words for 
    a speech recognition experiment, such as the one used by SpeechHMM.
    It contains a list of words, each word being a list of phonemes.

    @author Samy Bengio (bengio@idiap.ch)
*/
class Dictionary : public Object
{
  public:
    /// the vector of words, which are represented by vectors of phonemes
    int** words;
    /// the length of each word (number of phonemes)
    int* word_length;
    /// the number of words in the dictionary
    int n_words;
    /// for each word, the literal transcription
    char** words_string;
    /// the index of the "silence" word
    int silence_word;

    /// the phonemes
    char** phonemes;
    /// the number of different phonemes
    int n_phonemes;

    ///
    Dictionary();

    /** creates a Dictionary given a filename containing the words, as well
        as a vector of phonemes
    */
    Dictionary(char* filename, char** phonemes, int n_phonemes);

    /// this methods return the index of the given word, if found
    virtual int findWord(char* word);

    /// this methods return the index of the given phoneme, if found
    virtual int findPhoneme(char* phoneme);

    virtual ~Dictionary();
};


}

#endif
