// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef DISTR_MACHINE_INC
#define DISTR_MACHINE_INC

#include "Distribution.h"

namespace Torch {

/** This class can be used to implement a conditional distribution P(y|x;theta).
    It is represented as a machine followed by a distribution. The
    machine, given some inputs "x", computes the parameters "theta"
    of the distribution, then given these parameters, the distribution
    computes its log probability.

    @author Samy Bengio (bengio@idiap.ch)
*/
class DistrMachine : public Distribution
{
  public:
    /// the output distribution
    Distribution *distribution;

    /// the machine that produces the parameters of distribution
    GradientMachine *machine;

    /// to interface the input
    List input_machine;

    /// to keep the derivative of the parameters for the machine alpha
    real *der_params_distribution;
    
    /// creates a DistrMachine given a machine and and output distribution
    DistrMachine(Distribution* distribution_,GradientMachine *machine_);

    virtual void reset();
    virtual int numberOfParams();
    virtual void allocateMemory();
    virtual void freeMemory();
    virtual void loadFILE(FILE *file);
    virtual void saveFILE(FILE *file);


    virtual real frameLogProbability(real *observations, real *inputs, int t);
    virtual void iterInitialize();
    virtual void sequenceInitialize(List* inputs);
    virtual void frameBackward(real *observations, real *alpha, real *inputs, int t);
    virtual void frameExpectation(real *observations, real *inputs, int t);

    virtual ~DistrMachine();
};


}

#endif
