// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef EDIT_DISTANCE_MEASURER_INC
#define EDIT_DISTANCE_MEASURER_INC

#include "Measurer.h"
#include "EditDistance.h"
#include "DataSet.h"

namespace Torch {

/** This class can be used to measure and print an #EditDistance# object.
    It is used for instance in speech recognition experiments.

    @author Samy Bengio (bengio@idiap.ch)
*/
class EditDistanceMeasurer : public Measurer
{
  public:
    /// the #EditDistance# to measure
    EditDistance *edit;

    /// an accumulator of #EditDistance# objects, to compute statistics
    EditDistance *sum;

    /// do we print the edit distance for each example?
    bool print_ex;

    ///
    EditDistanceMeasurer(EditDistance *edit_, DataSet *data_, FILE *file_, bool print_ex_ = false);
    ///
    EditDistanceMeasurer(EditDistance *edit_, DataSet *data_, const char *filename, bool print_ex_ = false);

    virtual void init();
    virtual void reset();
    virtual void measureEx();
    virtual void measureIter();

    virtual ~EditDistanceMeasurer();
};


}

#endif
