// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef FIXED_MACHINE_DISTRIBUTION_INC
#define FIXED_MACHINE_DISTRIBUTION_INC

#include "Distribution.h"
#include "Machine.h"

namespace Torch {

/** This class uses one of the outputs of a given pre-trained machine as an
    estimate of a probability (used in the method #frameLogProbability#. It 
    can normalize it using an optional prior value. This class can therefore 
    be used in conjunction with HMMs to implement the HMM/ANN hybrid model...

    @author Samy Bengio (bengio@idiap.ch)
*/
class FixedMachineDistribution : public Distribution
{
  public:

    /** The (already trained) Machine that computes the probability.
        We suppose that the outputs of the machines are positive and
        sum to 1. One possibility is to use softmax outputs
    */
    Machine* machine;

    /// which output should we take
    int output_number;

    /// prior probability used to normalize the machine output
    real prior;

    /// temporary List used to compute machine forward
    List machine_inputs;

    /** this distribution is created with an already trained machine, the
        index of the output corresponding to this distribution, and an eventual
        prior.
    */
    FixedMachineDistribution(Machine* machine_,int output_number_ = 0,real prior_ = 1.);

    virtual void reset();
    virtual int numberOfParams();

    virtual real frameLogProbability(real *observations, real *inputs, int t);

    virtual ~FixedMachineDistribution();
};


}

#endif
