// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// nll criterion.
// simply returns the negative log likelihood

#ifndef NLL_CRITERION_INC
#define NLL_CRITERION_INC

#include "Criterion.h"
#include "SeqDataSet.h"

namespace Torch {

/** This criterion can be used to train #Distribution# object using
    the #GMTrainer# trainer. It then maximizes the log likelihood of the
    data.

    The #forward# method always return its input, which is the negative log
    likelihood, while the #backward# method sets the gradient to -1.

    @author Samy Bengio (bengio@idiap.ch)
*/
class NllCriterion : public Criterion
{
  public:

    ///
    NllCriterion();

    virtual void reset();
    virtual void forward(List *inputs);
    virtual void backward(List *inputs, real *alpha);
    virtual ~NllCriterion();
};


}

#endif
