// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef PARZEN_DISTRIBUTION_INC
#define PARZEN_DISTRIBUTION_INC

#include "Distribution.h"

namespace Torch {

/** This class can be used to model a Parzen density estimator with
    a Gaussian kernel:

    $ p(x) = \frac{1}{N}\sum_i \frac{1}{(2 \Pi var)^{d/2}} \exp(- \frac{||x - x_i||^2}{2 var})$

    where the sum is done on the whole training set.

    @author Samy Bengio (bengio@idiap.ch)
*/
class ParzenDistribution : public Distribution
{
  public:
    /// the variance used
    real var;

    /// the dataset
    SeqDataSet* data;

    /// the indices of the training examples
    int *real_examples;
    int n_real_examples;

    /** in order to faster the computation, we can do some "pre-computation"
        pre-computed sum_log_var + n_obs * log_2_pi
    */
    real sum_log_var_plus_n_obs_log_2_pi;
    /// pre-computed -0.5 / var
    real minus_half_over_var;

    ParzenDistribution(SeqDataSet* data_, real var_);

    virtual void reset();
    virtual int numberOfParams();
    virtual void allocateMemory();
    virtual void freeMemory();

    virtual void setVar(real var_);

    virtual real frameLogProbability(real *observations, real *inputs, int t);
    virtual real frameLogProbabilityOneFrame(real *observations, real *mean);

    virtual void eMSequenceInitialize(List* inputs);
    virtual void sequenceInitialize(List* inputs);

    virtual void frameExpectation(real *observations, real *inputs, int t);

    virtual ~ParzenDistribution();
};


}

#endif
