// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "ClassLLCriterion.h"

namespace Torch {

ClassLLCriterion::ClassLLCriterion(ClassFormat *class_format_)
{
  class_format = class_format_;
  n_inputs = class_format->getNumberOfClasses();
}

void ClassLLCriterion::reset()
{
  for(int i = 0; i < n_inputs; i++)
    beta[i] = 0;
  beta_on = 0;
}

void ClassLLCriterion::forward(List *inputs)
{
  int the_class = class_format->getTargetClass(data->targets);

  List *inputs_ = inputs;
  while(inputs_->n <= the_class)
  {
    the_class -= inputs_->n;
    inputs_ = inputs_->next;
  }
  *(real*)outputs->ptr = - ((real*)inputs_->ptr)[the_class];
}

void ClassLLCriterion::backward(List *inputs, real *alpha)
{
  int the_class = class_format->getTargetClass(data->targets);
  beta[beta_on] = 0;
  beta[the_class] = -1;
  beta_on = the_class;
}

ClassLLCriterion::~ClassLLCriterion()
{
}

}

