// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef CRITERION_INC
#define CRITERION_INC

#include "GradientMachine.h"
#include "DataSet.h"

namespace Torch {

/** #Criterion# class for #GMTrainer#.
    A #Criterion# computes an error with its inputs
    and a dataset #data#.

    It knows how to backpropagate this error.

    A #Criterion# shouldn't be connected to the inputs of
    another #GradientMachine#.
    ne doit pas se connecter sur l'entree d'une

    By default, the number of outputs for a #Criterion#
    is fixed to one. It \emph{must} contain the error:
    This one is used by the #GMTrainer# for the
    stopping criterion.

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class Criterion : public GradientMachine
{
  public:

    /// #DataSet# used to compute the error.
    DataSet *data;

    ///
    Criterion();

    /** Set #data# to #data_#. The criterion
        should be able to react to this function.
    */
    virtual void setDataSet(DataSet *data_);

    //-----

    virtual int numberOfParams();
    virtual ~Criterion();
};


}

#endif
