// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "DataSet.h"

namespace Torch {

DataSet::DataSet()
{
  n_targets = 0;
  targets = NULL;

  n_inputs = 0;
  inputs = NULL;

  n_examples = 0;
  n_real_examples = 0;

  select_examples = false;  
  selected_examples = NULL;

  subsets = NULL;
  n_examples_subsets = NULL;
  n_subsets = 0;
}

void DataSet::init()
{
  Object::init();

  n_examples = n_real_examples;

  selected_examples = (int *)xalloc(sizeof(int)*n_examples);
  for(int i = 0; i < n_examples; i++)
    selected_examples[i] = i;
}

void DataSet::pushSubset(int *subset_, int n_examples_)
{
  subsets = (int **)xrealloc(subsets, sizeof(int *)*(n_subsets+1));
  n_examples_subsets = (int *)xrealloc(n_examples_subsets, sizeof(int)*(n_subsets+1));
  subsets[n_subsets] = subset_;
  n_examples_subsets[n_subsets] = n_examples_;
  n_subsets++;

  selected_examples = (int *)xrealloc(selected_examples, sizeof(int)*n_examples_);
  for(int t = 0; t < n_examples_; t++)
  {
    int index = subset_[t];
    for(int s = n_subsets-2; s >= 0; s--)
      index = subsets[s][index];
    selected_examples[t] = index;
  }

  select_examples = true;
  n_examples = n_examples_;  
}

void DataSet::popSubset()
{
  //Rq: xrealloc renvoie NULL si freed
  subsets = (int **)xrealloc(subsets, sizeof(int *)*(n_subsets-1));
  n_examples_subsets = (int *)xrealloc(n_examples_subsets, sizeof(int)*(n_subsets-1));
  n_subsets--;
    
  if(n_subsets == 0)
  {
    select_examples = false;
    n_examples = n_real_examples;

    selected_examples = (int *)xrealloc(selected_examples, sizeof(int)*n_examples);
    for(int i = 0; i < n_examples; i++)
      selected_examples[i] = i;
  }
  else
  {
    int n_examples_ = n_examples_subsets[n_subsets-1];
    int *subset_ = subsets[n_subsets-1];
    selected_examples = (int *)xrealloc(selected_examples, sizeof(int)*n_examples_);
    for(int t = 0; t < n_examples_; t++)
    {
      int index = subset_[t];
      for(int s = n_subsets-2; s >= 0; s--)
        index = subsets[s][index];
      selected_examples[t] = index;
    }
    n_examples = n_examples_;
  }
}

void DataSet::setExample(int t)
{
  if(select_examples)
    setRealExample(selected_examples[t]);
  else
    setRealExample(t);
}

//=== Definitions juste la si ca vous gonfle
//=== de ne pas les definir
void DataSet::reset()
{
}

DataSet::~DataSet()
{
  free(subsets);
  free(n_examples_subsets);
  free(selected_examples);
}

}

