// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef SUM_MACHINE_INC
#define SUM_MACHINE_INC

#include "GradientMachine.h"

namespace Torch {

/** This machine simply adds up its input vectors. Formally speaking,
    $outputs[i] = \sum_j inputs_j[i]$ where $i$ spans the size of the
    vectors and $j$ spans the number of input vectors.

    @author Samy Bengio (bengio@idiap.ch)
*/
class SumMachine : public GradientMachine
{
  public:

    /// the number of input vectors
    int n_machines;

    /// 
    SumMachine(int n_units, int n_machines_);

    virtual int numberOfParams();
    virtual void forward(List *inputs);
    virtual void backward(List *inputs, real *alpha);

    virtual ~SumMachine();
};


}

#endif
