// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef LOG_ADD_INC
#define LOG_ADD_INC

#include "general.h"

namespace Torch {

/** Some simple functions for log operations.

    @author Samy Bengio (bengio@idiap.ch)
*/
//@{
#define LOG_2_PI 1.83787706640934548355
//#define LOG_ZERO -INF
#define LOG_ZERO -1e10
#define LOG_ONE 0

#define MINUS_LOG_THRESHOLD -18.42

/** log_add(log_a,log_b) = log(a+b) = log(exp(log_a)+exp(log_b))
    but done in a smart way so that if log_a or log_b are large
    but not their difference the computation works correctly.
*/
real log_add(real log_a,real log_b);

/// log_sub(log_a,log_b) = log(a-b)
real log_sub(real log_a,real log_b);
//@}

}

#endif

