// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MATRIX_INC
#define MATRIX_INC

/* Includes when you're using the "matrix" package.

   @author Ronan Collobert (collober@iro.umontreal.ca)
*/

#include "Mat.h"
#include "Mat_operations.h"
#include "Perm.h"
#include "Perm_operations.h"
#include "Vec.h"
#include "mx_low_level.h"
#include "mx_lu_factor.h"
#include "mx_solve.h"
#include "mx_householder.h"
#include "mx_hessenberg.h"
#include "mx_givens.h"
#include "mx_sym_eig.h"

namespace Torch {


}

#endif
