/*
 *  TouchFreezeApp.cpp
 *
 *  Copyright (C) 2007, 2008  Stefan Kombrink
 *  Copyright (C) 2008 Pau Garcia i Quiles
 *
 *  This file is part of TouchFreeze.
 *
 *  TouchFreeze is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TouchFreeze is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with touchfreeze; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *  On Debian GNU/Linux systems, the complete text of the GNU General
 *  Public License can be found in the /usr/share/common-licenses/GPL file.
 */


#include <QtGui>

#include "TouchFreezeApp.h"
#include "TouchFreezeUI.h"

#include "SynDaemon.h"

#include <QString>
#include <QProcess>

TouchFreezeApp::TouchFreezeApp( int& argc, char* argv[] ) : QApplication( argc, argv )
{
  if ( !QSystemTrayIcon::isSystemTrayAvailable() )
  {
     qDebug( "there's no system tray. Use KDE or GNOME, please!" );
     quit();
  }

  mSynDaemon = new SynDaemon( this );
  qDebug() << "using typing delay of" << mSynDaemon->delay() << "ms";
    
  mUI = new TouchFreezeUI();

  setActiveWindow( mUI );

  connect( mSynDaemon, SIGNAL( startTyping() ), this, SLOT( onStartTyping() ) );
  connect( mSynDaemon, SIGNAL( stopTyping() ), this, SLOT( onStopTyping() ) );
  
  QProcess* pSynclient = new QProcess( this );

  pSynclient->start( "whereis -b synclient" );
  pSynclient->waitForFinished();
  mClientBin=pSynclient->readAllStandardOutput();
  mClientBin.remove(0, 1 + mClientBin.indexOf(' '));
  mClientBin = mClientBin.trimmed();
  
  qDebug() << mClientBin;
  
  // TODO!! Error check & treatment!
  
  QStringList clArgs;
  clArgs.append("-V");

  pSynclient->start( mClientBin, clArgs );
  pSynclient->waitForFinished();
  
  QString driverStr=pSynclient->readAllStandardOutput();
  
  mUI->setup( driverStr, mClientBin, mSynDaemon->delay() );
  
  pSynclient->start( mClientBin+" -l|grep TouchpadOff" );
  pSynclient->waitForFinished();
  
  mInitialState = pSynclient->readAllStandardOutput().toInt();
  qDebug() << "initial state is TouchpadOff=" << mInitialState;
  
  connect( mUI, SIGNAL( delayChanged( unsigned int ) ), mSynDaemon, SLOT( setDelay( unsigned int ) ) );
  connect( mUI, SIGNAL( useDelayChanged( bool )), mSynDaemon, SLOT( setDaemonActive( bool ) ) );
  connect( mUI, SIGNAL( enableTouchPadChanged( bool )), mSynDaemon, SLOT( setTouchPadActive( bool ) ) );
  
  connect( mUI, SIGNAL( cancelled() ), this, SLOT( onCancel() ) );
  connect( mUI, SIGNAL( applied() ), this, SLOT( onApply() ) );

}

void TouchFreezeApp::onCancel()
{
    mSynDaemon->rollbackSettings();
    mUI->updateGUI( mSynDaemon->delay(), mSynDaemon->isDaemonActive(), mSynDaemon->isTouchPadActive() );
}

void TouchFreezeApp::onApply()
{
    mSynDaemon->commitSettings();
}

TouchFreezeApp::~TouchFreezeApp()
{
    onStopTyping();
}


void TouchFreezeApp::setTouchpad(bool on)
{
  if (on) enableTouchpad();
  else disableTouchpad();
}

void TouchFreezeApp::enableTouchpad()
{
  qDebug( "enable touchpad" );
  QProcess p( this );

  QProcess::execute( mClientBin + " TouchpadOff=0" );
  mSynDaemon->setTouchPadActive(true);
  
  mUI->updateGUI( mSynDaemon->delay(), mSynDaemon->isDaemonActive(), mSynDaemon->isTouchPadActive() );
}

void TouchFreezeApp::disableTouchpad()
{
  qDebug( "disable touchpad" );

  QProcess::execute( mClientBin + " TouchpadOff=1" );
  mSynDaemon->setTouchPadActive(false);
  
  mUI->updateGUI( mSynDaemon->delay(), mSynDaemon->isDaemonActive(), mSynDaemon->isTouchPadActive() );
}

void TouchFreezeApp::onStartTyping()
{
  qDebug( "start typing" );

  QProcess::execute( mClientBin + " TouchpadOff=2" ); 
}

void TouchFreezeApp::onStopTyping()
{
  qDebug( "stop typing" );
  QProcess::execute(mClientBin+QString(" TouchpadOff=%1").arg(mInitialState));
}


