" Vim syntax file
" Language:	tpp - Text Presentation Program
" Maintainer:	Gerfried Fuchs <alfie@ist.org>
" Filenames:	*.tpp
" Last Change:	30 September 2004
" URL:		http://alfie.ist.org/projects/vim/syntax/tpp.vim
" License:	BSD
"
" Comments are very welcome - but please make sure that you are commenting on
" the latest version of this file.
" SPAM is _NOT_ welcome - be ready to be reported!

" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

"" list of the legal switches/options
syn match tppAbstractOptionKey contained "^--\%(author\|title\|date\) *" nextgroup=tppValue
syn match tppPageLocalOptionKey contained "^--\%(heading\|center\|right\|sleep\|huge\|exec\|newpage\) *" nextgroup=tppValue
syn match tppPageLocalSwitchKey contained "^--\%(horline\|-\|\%(begin\|end\)\%(\%(shell\)\?output\|slide\%(left\|right\|top\|bottom\)\)\|\%(bold\|rev\|ul\)\%(on\|off\)\|withborder\)"
syn match tppColorOptionKey contained "^--\%(\%(bg\|fg\)\?color\) *"
syn match tppTimeOptionKey contained "^--sleep *"

syn match tppValue contained ".*"
syn match tppColor contained "\%(white\|yellow\|red\|green\|blue\|cyan\|magenta\|black\)"
syn match tppTime contained "\d\+"

syn region tppPageLocalSwitch start="^--" end="$" contains=tppPageLocalSwitchKey oneline
syn region tppPageLocalOption start="^--\%(heading\|center\|right\|sleep\|huge\|exec\|newpage\)" end="$" contains=tppPageLocalOptionKey oneline
syn region tppColorOption start="^--\%(\%(bg\|fg\)\?color\)" end="$" contains=tppColorOptionKey,tppColor oneline
syn region tppTimeOption start="^--sleep" end="$" contains=tppTimeOptionKey,tppTime oneline
syn region tppAbstractOption start="^--\%(author\|title\|date\)" end="$" contains=tppAbstractOptionKey oneline

" Define the default highlighting.
" For version 5.7 and earlier: only when not done already
" For version 5.8 and later: only when an item doesn't have highlighting yet
if version >= 508 || !exists("did_tpp_syn_inits")
  if version < 508
    let did_tpp_syn_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command -nargs=+ HiLink hi def link <args>
  endif

  HiLink tppAbstractOptionKey		Keyword
  HiLink tppPageLocalOptionKey		Keyword
  HiLink tppPageLocalSwitchKey		Keyword
  HiLink tppColorOptionKey		Keyword
  HiLink tppTimeOptionKey		Keyword
  HiLink tppValue			String
  HiLink tppColor			String
  HiLink tppTime			String
  HiLink tppAbstractOption		Error
  HiLink tppPageLocalOption		Error
  HiLink tppPageLocalSwitch		Error
  HiLink tppColorOption			Error
  HiLink tppTimeOption			Error

  delcommand HiLink
endif

let b:current_syntax = "tpp"

" vim: ts=8 sw=2
