<?cs include "header.cs" ?>
<?cs include "macros.cs" ?>

<div id="ctxtnav" class="nav"></div>

<div id="content" class="attachment">

<?cs if:attachment.mode == 'new' ?>
 <h1><a href="<?cs var:attachment.parent.href?>"><?cs
   var:attachment.parent.name ?></a> に添付ファイルを登録</h1>
 <form id="attachment" method="post" enctype="multipart/form-data" action="">
  <div class="field">
   <label>ファイル:<br /><input type="file" name="attachment" /></label>
  </div>
  <fieldset>
   <legend>添付ファイル情報</legend>
   <?cs if:trac.authname == "anonymous" ?>
    <div class="field">
     <label>メールアドレスまたはユーザ名:<br />
     <input type="text" name="author" size="30" value="<?cs
       var:attachment.author?>" /></label>
    </div>
   <?cs /if ?>
   <div class="field">
    <label>ファイルについての説明 (非必須):<br />
    <input type="text" name="description" size="60" /></label>
   </div>
   <br />
   <div class="options">
    <label><input type="checkbox" name="replace" />
    同名の添付ファイルが存在していた場合、置き換える</label>
   </div>
   <br />
  </fieldset>
  <div class="buttons">
   <input type="hidden" name="action" value="new" />
   <input type="hidden" name="type" value="<?cs var:attachment.parent.type ?>" />
   <input type="hidden" name="id" value="<?cs var:attachment.parent.id ?>" />
   <input type="submit" value="添付ファイルを登録" />
   <input type="submit" name="cancel" value="取り消し" />
  </div>
 </form>
<?cs elif:attachment.mode == 'delete' ?>
 <h1><a href="<?cs var:attachment.parent.href ?>"><?cs
   var:attachment.parent.name ?></a>: <?cs var:attachment.filename ?></h1>
 <p><strong>本当に削除してもよろしいですか?</strong><br />
 削除すると元に戻すことができません。</p>
 <div class="buttons">
  <form method="post" action=""><div id="delete">
   <input type="hidden" name="action" value="delete" />
   <input type="submit" name="cancel" value="取り消し" />
   <input type="submit" value="添付ファイルを削除" />
  </div></form>
 </div>
<?cs elif:attachment.mode == 'list' ?>
 <h1><a href="<?cs var:attachment.parent.href ?>"><?cs
   var:attachment.parent.name ?></a></h1><?cs
  call:list_of_attachments(attachment.list, attachment.attach_href) ?>
<?cs else ?>
 <h1><a href="<?cs var:attachment.parent.href ?>"><?cs
   var:attachment.parent.name ?></a>: <?cs var:attachment.filename ?></h1>
 <table id="info" summary="説明"><tbody><tr>
   <th scope="col">
    ファイル <?cs var:attachment.filename ?>, <?cs var:attachment.size ?> 
    (登録者: <?cs var:attachment.author ?>,  登録時期: <?cs var:attachment.age ?> 前)
   </th></tr><tr>
   <td class="message"><?cs var:attachment.description ?></td>
  </tr>
 </tbody></table>
 <div id="preview"><?cs
  if:attachment.preview ?>
   <?cs var:attachment.preview ?><?cs
  elif:attachment.max_file_size_reached ?>
   <strong>HTMLプレビュー出来ません</strong>。ファイルサイズが
   <?cs var:attachment.max_file_size  ?> バイトを超えています。閲覧するためには <a href="<?cs
     var:attachment.raw_href ?>">ファイルをダウンロード</a> してください。<?cs
  else ?>
   <strong>HTMLプレビューで対応していないファイル形式です。</strong> 閲覧するためには
   <a href="<?cs var:attachment.raw_href ?>">ファイルをダウンロードしてください。</a><?cs
  /if ?>
 </div>
 <?cs if:attachment.can_delete ?><div class="buttons">
  <form method="get" action=""><div id="delete">
   <input type="hidden" name="action" value="delete" />
   <input type="submit" value="添付ファイルを削除" />
  </div></form>
 </div><?cs /if ?>
<?cs /if ?>

</div>
<?cs include "footer.cs"?>
