<?cs include:"header.cs"?>
<?cs include:"macros.cs"?>

<div id="ctxtnav" class="nav"></div>

<div id="content" class="milestone">
 <?cs if:milestone.mode == "new" ?>
 <h1>マイルストーンを登録</h1>
 <?cs elif:milestone.mode == "edit" ?>
 <h1>マイルストーン <?cs var:milestone.name ?> を編集</h1>
 <?cs elif:milestone.mode == "delete" ?>
 <h1>マイルストーン <?cs var:milestone.name ?> を削除</h1>
 <?cs else ?>
 <h1>マイルストーン <?cs var:milestone.name ?></h1>
 <?cs /if ?>

 <?cs if:milestone.mode == "edit" || milestone.mode == "new" ?>
  <script type="text/javascript">
    addEvent(window, 'load', function() {
      document.getElementById('name').focus();
    });
  </script>
  <form id="edit" action="<?cs var:milestone.href ?>" method="post">
   <input type="hidden" name="id" value="<?cs var:milestone.name ?>" />
   <input type="hidden" name="action" value="edit" />
   <div class="field">
    <label>マイルストーン名称:<br />
    <input type="text" id="name" name="name" size="32" value="<?cs
      var:milestone.name ?>" /></label>
   </div>
   <fieldset>
    <legend>スケジュール</legend>
    <label>完了期限:<br />
     <input type="text" id="duedate" name="duedate" size="<?cs
       var:len(milestone.date_hint) ?>" value="<?cs
       var:milestone.due_date ?>" title="日付フォーマット: <?cs var:milestone.date_hint ?>" />
     <em>日付フォーマット: <?cs var:milestone.date_hint ?></em>
    </label>
    <div class="field">
     <label>
      <input type="checkbox" id="completed" name="completed"<?cs
        if:milestone.completed ?> checked="checked"<?cs /if ?> />
      完了にする:<br />
     </label>
     <label>
      <input type="text" id="completeddate" name="completeddate" size="<?cs
        var:len(milestone.date_hint) ?>" value="<?cs
        alt:milestone.completed_date ?><?cs
         var:milestone.datetime_now ?><?cs
        /alt ?>" title="日付フォーマット: <?cs
        var:milestone.datetime_hint ?>" />
      <em>日付フォーマット: <?cs var:milestone.datetime_hint ?></em>
     </label><?cs
     if:len(milestones) ?>
     <br/>
     <input type="checkbox" id="retarget" name="retarget" checked="checked"
            onclick="enableControl('target', this.checked)"/>
     <label>
      このマイルストーンの未解決チケットを他のマイルストーンに関連付ける
      <select id="target" name="target">
       <option value="">None</option><?cs
       each:name = milestones ?>
       <option><?cs var:name ?></option><?cs
       /each ?>
      </select>
     </label><?cs
     /if ?>
     <script type="text/javascript">
       var completed = document.getElementById("completed");
       var retarget = document.getElementById("retarget");
       var enableCompletedDate = function() {
         enableControl("completeddate", completed.checked);
         enableControl("retarget", completed.checked);
         enableControl("target", completed.checked && retarget.checked);
       };
       addEvent(window, "load", enableCompletedDate);
       addEvent(completed, "click", enableCompletedDate);
     </script>
    </div>
   </fieldset>
   <div class="field">
    <fieldset class="iefix">
     <label for="description">マイルストーンについての説明 (<a tabindex="42" href="<?cs
       var:trac.href.wiki ?>/WikiFormatting">WikiFormatting</a> を使用できます):</label>
     <p><textarea id="description" name="description" class="wikitext" rows="10" cols="78">
<?cs var:milestone.description_source ?></textarea></p>
    </fieldset>
   </div>
   <div class="buttons">
    <?cs if:milestone.mode == "new"
     ?><input type="submit" value="登録" /><?cs
    else
     ?><input type="submit" value="保存" /><?cs
    /if ?>
    <input type="submit" name="cancel" value="取り消し" />
   </div>
   <script type="text/javascript" src="<?cs
     var:htdocs_location ?>js/wikitoolbar.js"></script>
  </form>
 <?cs elif:milestone.mode == "delete" ?>
  <form action="<?cs var:milestone.href ?>" method="post">
   <input type="hidden" name="id" value="<?cs var:milestone.name ?>" />
   <input type="hidden" name="action" value="delete" />
   <p><strong>このマイルストーンを本当に削除してもいいですか?</strong></p>
   <input type="checkbox" id="retarget" name="retarget" checked="checked"
       onclick="enableControl('target', this.checked)"/>
   <label for="target">このマイルストーンのチケットを他のマイルストーンに関連付ける</label>
   <select name="target" id="target">
    <option value="">None</option><?cs
     each:other = milestones ?><?cs if:other != milestone.name ?>
      <option><?cs var:other ?></option><?cs 
     /if ?><?cs /each ?>
   </select>
   <div class="buttons">
    <input type="submit" name="cancel" value="取り消し" />
    <input type="submit" value="削除" />
   </div>
  </form>
 <?cs else ?>
 <?cs if:milestone.mode == "view" ?>
  <div class="info">
   <p class="date"><?cs
    if:milestone.completed_date ?>
     <?cs var:milestone.completed_delta ?> 前に完了 (<?cs var:milestone.completed_date ?>)<?cs
    elif:milestone.due_date ?><?cs
     if:milestone.late ?>
      <strong>完了期限から <?cs var:milestone.due_delta ?> 遅れ</strong><?cs
     else ?>
      あと <?cs var:milestone.due_delta ?> で完了期限<?cs
     /if ?> (<?cs var:milestone.due_date ?>)<?cs
    else ?>
     完了期限が設定されていません<?cs
    /if ?>
   </p><?cs
   with:stats = milestone.stats ?><?cs
    if:#stats.total_tickets > #0 ?>
     <table class="progress">
      <tr>
      <td class="closed" style="width: <?cs
        var:#stats.percent_closed ?>%">
        <a href="<?cs
        var:milestone.queries.closed_tickets ?>" title="<?cs
        var:#stats.total_tickets ?> 個中 <?cs
        var:#stats.closed_tickets ?> 個のチケットが解決済み"></a></td>
      <td class="open" style="width: <?cs
        var:#stats.percent_active ?>%">
        <a href="<?cs
        var:milestone.queries.active_tickets ?>" title="<?cs
        var:#stats.total_tickets ?> 個中 <?cs
        var:#stats.active_tickets ?> 個のチケットが未解決"></a>
      </tr>
     </table>
     <p class="percent"><?cs var:#stats.percent_closed ?>%</p>
     <dl>
      <dt>解決済みのチケット:</dt>
      <dd><a href="<?cs var:milestone.queries.closed_tickets ?>"><?cs
        var:stats.closed_tickets ?></a></dd>
      <dt>未解決のチケット:</dt>
      <dd><a href="<?cs var:milestone.queries.active_tickets ?>"><?cs
        var:stats.active_tickets ?></a></dd>
     </dl><?cs
    /if ?><?cs
   /with ?>
  </div>
  <form id="stats" action="" method="get">
   <fieldset>
    <legend>
     <select id="by" name="by" onchange="this.form.submit()"><?cs
     each:group = milestone.stats.available_groups ?>
      <option value="<?cs var:group.name ?>" <?cs
        if:milestone.stats.grouped_by == group.name ?> selected="selected"<?cs
        /if ?>><?cs var:group.label ?></option><?cs
     /each ?></select>
     <label for="by">別チケットのステータス</label>
     <noscript><input type="submit" value="更新" /></noscript>
    </legend>
    <table summary="<?cs
      var:milestone.stats.grouped_by ?>別に集計したマイルストーンの進捗状況"><?cs
     each:group = milestone.stats.groups ?>
      <tr>
       <th scope="row"><a href="<?cs
         var:group.queries.all_tickets ?>"><?cs var:group.name ?></a></th>
       <td style="white-space: nowrap"><?cs if:#group.total_tickets ?>
        <table class="progress" style="width: <?cs
          var:#group.percent_total * #80 / #milestone.stats.max_percent_total ?>%">
         <tr>
          <td class="closed" style="width: <?cs
            var:#group.percent_closed ?>%"><a href="<?cs
            var:group.queries.closed_tickets ?>" title="<?cs
           var:group.total_tickets ?> 個中 <?cs
           var:group.closed_tickets ?> 個のチケットが解決済み"></a>
          </td>
          <td class="open" style="width: <?cs
            var:#group.percent_active ?>%"><a href="<?cs
            var:group.queries.active_tickets ?>" title="<?cs
           var:group.total_tickets ?> 個中 <?cs
           var:group.active_tickets ?> 個のチケットが未解決"></a>
          </td>
         </tr>
        </table>
        <p class="percent"><?cs var:group.closed_tickets ?>/<?cs
         var:group.total_tickets ?></p>
       <?cs /if ?></td>
      </tr><?cs
     /each ?>
    </table><?cs /if ?>
   </fieldset>
  </form>
  <div class="description"><?cs var:milestone.description ?></div><?cs
  if:trac.acl.MILESTONE_MODIFY || trac.acl.MILESTONE_DELETE ?>
   <div class="buttons"><?cs
    if:trac.acl.MILESTONE_MODIFY ?>
     <form method="get" action=""><div>
      <input type="hidden" name="action" value="edit" /><?cs
      if:milestone.id_param ?>
       <input type="hidden" name="id" value="<?cs var:milestone.name ?>" /><?cs
      /if ?>
      <input type="submit" value="マイルストーン情報を編集" accesskey="e" />
     </div></form><?cs
    /if ?><?cs
    if:trac.acl.MILESTONE_DELETE ?>
     <form method="get" action=""><div>
      <input type="hidden" name="action" value="delete" /><?cs
      if:milestone.id_param ?>
       <input type="hidden" name="id" value="<?cs var:milestone.name ?>" /><?cs
      /if ?>
      <input type="submit" value="マイルストーンを削除" />
     </div></form><?cs
    /if ?>
   </div><?cs
  /if ?><?cs
 /if ?>

 <div id="help">
  <strong>Note:</strong> ロードマップについてのヘルプは <a href="<?cs
    var:trac.href.wiki ?>/TracRoadmap">TracRoadmap</a> を参照してください。
 </div>

</div>
<?cs include:"footer.cs"?>
