/* menuMode.cc
   The inital menu with game options and highscores

   Copyright (C) 2000  Mathias Broxvall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "general.h"
#include "gameMode.h"
#include "mainMode.h"
#include "menuMode.h"
//#include "SDL/SDL_ttf.h"
#include "SDL/SDL_opengl.h"
#include "font.h"
#include "glHelp.h"
#include "SDL/SDL_image.h"
#include "highScore.h"
#include "hofMode.h"
#include "settingsMode.h"
#include "setupMode.h"
#include "helpMode.h"

using namespace std;

MenuMode *MenuMode::menuMode=NULL;

#define MENU_NEWGAME  0
#define MENU_QUIT     1
#define MENU_SETTINGS 2
#define MENU_HOF      3
#define MENU_HELP     4
#define MENU_LAST     5

#define Y_BASE      155
#define Y_DELTA     50

SDL_Surface *MenuMode::menuLow[MENU_LAST], *MenuMode::menuHigh[MENU_LAST];
SDL_Surface *MenuMode::header;

void MenuMode::init() {
  char str[256];
  int i;

  menuMode = new MenuMode();

  sprintf(str,"%s/images/header.png",SHARE_DIR);
  header = IMG_Load(str);
  if(!header) { printf("Error: Failed to load %s\n",str); exit(0); }

  for(i=0;i<MENU_LAST;i++) {
	sprintf(str,"%s/images/menu%d.png",SHARE_DIR,i);
	menuLow[i] = IMG_Load(str);
	if(!menuLow[i]) { printf("Error: Failed to load %s\n",str); exit(0); }
	sprintf(str,"%s/images/menuHigh%d.png",SHARE_DIR,i);
	menuHigh[i] = IMG_Load(str);
	if(!menuHigh[i]) { printf("Error: Failed to load %s\n",str); exit(0); }
  }
}
MenuMode::MenuMode() { selection = -1; }

void MenuMode::display() {
  char str[256];
  int i,w,h;

  glPushAttrib(GL_ENABLE_BIT);
  glClearColor(0.0,0.0,0.0,0.0);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glColor3f(1.0,1.0,1.0);
  drawSurface(header,(screenWidth-550)/2,20,550,100);

  for(i=0;i<MENU_LAST;i++) {
	SDL_Surface *surface;
	if(i == selection)
	  surface = menuHigh[i];
	else
	  surface = menuLow[i];
	drawSurface(surface,(i%2)?screenWidth-surface->w:0,screenHeight-Y_BASE+Y_DELTA*(i/2),surface->w,surface->h);
  }

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(40,640.0/480.0,1.0,1e20);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  gluLookAt(0.0, 12.0, 1.5,
	    0.0, 6.0,  0.0,
	    0.0, -1.0,  0.0);
  glDisable(GL_LIGHTING);
  glDisable(GL_CULL_FACE);
  glDisable(GL_DEPTH_TEST);
  glShadeModel(GL_SMOOTH);
  glEnable(GL_TEXTURE_2D);
  glEnable(GL_BLEND);

  glBindTexture(GL_TEXTURE_2D, texture);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
  glBegin(GL_TRIANGLE_STRIP);

  glColor4f(0.0,0.0,0.0,0.0);
  glTexCoord2f(texMaxX, offset+texMinY); glVertex3f(+1.2, -1.5,0.0);
  glTexCoord2f(texMinX, offset+texMinY); glVertex3f(-1.2, -1.5,0.0);

  glColor4f(255./256.,243./256.,15./256.,1.0);
  //glColor4f(1.0,1.0,0.2,1.0);
  glTexCoord2f(texMaxX, offset+texMinY+texDY*6./10.); glVertex3f(+1.2,4.5,0.0);
  glTexCoord2f(texMinX, offset+texMinY+texDY*6./10.); glVertex3f(-1.2,4.5,0.0);
  glTexCoord2f(texMaxX, offset+texMinY+texDY*9./10.); glVertex3f(+1.2,7.5,0.0);
  glTexCoord2f(texMinX, offset+texMinY+texDY*9./10.); glVertex3f(-1.2,7.5,0.0);

  glColor4f(0.0,0.0,0.0,0.0);
  glTexCoord2f(texMaxX, offset+texMaxY); glVertex3f(+1.2,8.5,0.0);
  glTexCoord2f(texMinX, offset+texMaxY); glVertex3f(-1.2,8.5,0.0);
  glEnd();

  drawMousePointer();
  displayFrameRate();
  glPopAttrib();

  sprintf(str,"v%s",VERSION);
  Font::drawRightSimpleText(0, str, screenWidth-15, screenHeight-15, 10., 10., 0.50, 0.50, 0.50, 0.75);
  //draw2DString(infoFont,str,screenWidth-60,screenHeight-10,64,64,64);  
}
void MenuMode::key(int key) {
  /*  if(key == SDLK_RIGHT) {
	selection++;
	if(selection >= MENU_LAST) selection = 0;	
  } else if(key == SDLK_LEFT) {
	selection--;
	if(selection < 0) selection = MENU_LAST-1; 
  } else if(key == SDLK_RETURN || key == SDLK_KP_ENTER || key == ' ')
  doSelection();*/
}
void MenuMode::doSelection() {
  switch(selection) {
  case MENU_QUIT: exit(0); break;
  case MENU_NEWGAME: GameMode::activate(SetupMode::setupMode); Font::delAllText(); break;
  case MENU_HOF: GameMode::activate(HallOfFameMode::hallOfFameMode); Font::delAllText(); break;
  case MENU_SETTINGS: GameMode::activate(SettingsMode::settingsMode); Font::delAllText(); break;
  case MENU_HELP: GameMode::activate(HelpMode::helpMode); Font::delAllText(); break;
  }
}
inline Real abs(Real v) {return v>0.0?v:-v;}

void MenuMode::idle(Real td) {
  int w,h,i,x,y;
  int mouseX,mouseY;

  tickMouse(td);
  SDL_GetMouseState(&x,&y);
  Uint8 *keystate = SDL_GetKeyState(NULL);
  if(keystate[SDLK_LEFT]) { x-=(int)(150/fps); SDL_WarpMouse(x,y); }
  if(keystate[SDLK_RIGHT]) { x+=(int)(150/fps); SDL_WarpMouse(x,y); }
  if(keystate[SDLK_UP]) { y-=(int)(150/fps); SDL_WarpMouse(x,y); }
  if(keystate[SDLK_DOWN]) { y+=(int)(150/fps); SDL_WarpMouse(x,y); }
  if(keystate[SDLK_SPACE] || keystate[SDLK_RETURN]) doSelection();

  Uint8 mouseState=SDL_GetMouseState(&mouseX,&mouseY);

  /* This controls the scrolling text */
  offset += 0.015 * td;
  if(offset > 0.7) offset = -0.77;

  for(i=0;i<MENU_LAST;i++)
	if(mouseY >= screenHeight - Y_BASE+Y_DELTA*(i/2) && 
	   mouseY <= screenHeight - Y_BASE+Y_DELTA*(i/2) + 64 &&
	   mouseX >= ((i%2)?screenWidth-menuHigh[i]->w:0) &&
	   mouseX <= ((i%2)?screenWidth:menuHigh[i]->w))
	  selection = i;
}
void MenuMode::mouseDown(int mouseState,int x,int y) {doSelection();}

#define STORY_LINES 15
const char *story[STORY_LINES] = {
  "Trackballs is a simple game similar to",
  "the classical game Marble Madness, on the",
  "Amiga, in the 80's. By steering a marble",
  "ball through a labyrinth filled with",
  "vicious hammers, pools of acid and other",
  "obstacles the player collects points.",
  "When the ball reaches the destination you",
  "continue on the next, more difficult, level",
  " ",
  " - unless, of course, the time runs out.",
  " ",
  " ",
  "You steer the ball using the mouse and by",
  "pressing >spacebar< you can jump a short",
  "distance."
};

#define CREDIT_LINES 6
const char *credits[CREDIT_LINES][3] = {
  {" ","Credits"," "},
  {"Programming", " ", "Mathias Broxvall"},
  {"co-programming", " ", "Yannick perret"},
  {"Artwork and Music", " ", "Dietrich Radel"},
  {"Sfx", " ", "Benoit Rouits"},
  {"", " ", "Joshua Harding"},
};

void MenuMode::activated() { 
  int i,w,h;
  GLfloat texcoord[4];
  SDL_Color fgColor={255,255,255};
  SDL_Surface *text;
  SDL_Rect rect;
  char str[256];

  rect.w = 400; rect.h = 20;
  offset = -0.77;
  selection=-1; 
  SDL_Surface *surface = SDL_CreateRGBSurface(SDL_SWSURFACE,400,800,screen->format->BitsPerPixel,
											  screen->format->Rmask,screen->format->Gmask,screen->format->Bmask,screen->format->Amask);
  /* STORY */
  for(i=0;i<STORY_LINES;i++) {
	text = TTF_RenderText_Blended(scrollFont, story[i], fgColor);
	rect.x = 0;
	rect.y = 20*i;
	SDL_BlitSurface(text,NULL,surface,&rect);
	SDL_FreeSurface(text);
  }

  /* HIGHSCORES */
  text = TTF_RenderText_Blended(scrollFont, "> High Scores <", fgColor);
  rect.x = (300-text->w)/2;
  rect.y = 400;
  SDL_BlitSurface(text,NULL,surface,&rect);
  SDL_FreeSurface(text);
  for(i=0;i<10;i++) {
	text = TTF_RenderText_Blended(scrollFont, HighScore::highScore->names[0][i], fgColor);
	rect.x = 0;
	rect.y = 420+i*20;
	SDL_BlitSurface(text,NULL,surface,&rect);	
	SDL_FreeSurface(text);

	sprintf(str,"%d points",HighScore::highScore->points[0][i]);
	text = TTF_RenderText_Blended(scrollFont, str, fgColor);
	rect.x = 300-text->w;
	rect.y = 420+i*20;
	SDL_BlitSurface(text,NULL,surface,&rect);	
	SDL_FreeSurface(text);
  }

  /* CREDITS */
  for(i=0;i<CREDIT_LINES;i++) {
	text = TTF_RenderText_Blended(scrollFont, credits[i][0], fgColor);
	rect.x = 0;
	rect.y = 680+i*20;
	SDL_BlitSurface(text,NULL,surface,&rect);	
	SDL_FreeSurface(text);

	text = TTF_RenderText_Blended(scrollFont, credits[i][1], fgColor);
	rect.x = (300-text->w)/2;
	rect.y = 680+i*20;
	SDL_BlitSurface(text,NULL,surface,&rect);	
	SDL_FreeSurface(text);
	
	text = TTF_RenderText_Blended(scrollFont, credits[i][2], fgColor);
	rect.x = 300-text->w;
	rect.y = 680+i*20;
	SDL_BlitSurface(text,NULL,surface,&rect);	
	SDL_FreeSurface(text);
  }


  texture = LoadTexture(surface, texcoord);
  SDL_FreeSurface(surface);

  texMaxX = texcoord[0];
  texMinY = texcoord[1];
  texMinX = texcoord[2];
  texMaxY = texcoord[3];
  texDY = texMaxY - texMinY;
}
void MenuMode::deactivated() { 
  glDeleteTextures(1,&texture);
}
