/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2013 Martin Brehm
                  2012-2013 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#include "ltspec.h"
#include <math.h>
#include "tools.h"
#include "globalvar.h"


CLTSpec::CLTSpec()
{
}


CLTSpec::~CLTSpec()
{
}


void CLTSpec::Parse(int res)
{
	int ti;

	m_fLSpecMinExp = AskFloat("      Enter smallest lifetime for spectrum (in ps): [%.4f] ",g_fTimestepLength/1000.0,g_fTimestepLength/1000.0);
	m_fLSpecMaxExp = AskFloat("      Enter largest lifetime for spectrum (in ps): [%.4f] ",g_fTimestepLength/1000.0*res*5.0,g_fTimestepLength/1000.0*res*5.0);
	ti = ((int)ceil(log10(m_fLSpecMaxExp/m_fLSpecMinExp)));
	mprintf("\n      The spectral range spans over %d orders of magnitude of time.\n\n",ti);
	m_iLSpecPoints = AskUnsignedInteger("      Enter number of lifetime spectrum data points: [%d] ",ti*25,ti*25);
_lspagain:
	m_iLSpecData = AskUnsignedInteger("      How many data points to use for fitting: [%d] ",m_iLSpecPoints*2,m_iLSpecPoints*2);
	if (m_iLSpecData < m_iLSpecPoints)
	{
		eprintf("      Error: You cannot have more fit parameters than data points.\n");
		goto _lspagain;
	}
	m_iMaxLMIter = AskUnsignedInteger("      How many iterations to allow for the Levenberg-Marquardt fitting? [200] ",200);
	m_bLSpecDataLin = AskYesNo("      Distribute fit sample points linearly (y) or logarithmically (n) over interval? [no] ",false);
	m_fLSpecZeroWeight = AskFloat("      Which weight to use for first data point? [1] ",1.0);
	m_bEvolve = AskYesNo("      Save evolution of spectrum during iterations (y/n)? [no] ",false);
}


void CLTSpec::ComputeSpectrum(const char *pre1, const char *post1, const char *post2, const char *post3, CDF *df)
{
	char buf[256];

	sprintf(buf,"%s_lspectrum_N%d_P%d_I%d_%s_zero%.0f_%s%s%s",pre1,m_iLSpecData,m_iLSpecPoints,m_iMaxLMIter,m_bLSpecDataLin?"lin":"log",m_fLSpecZeroWeight,post1,post2,post3);
	df->Fit_ExpSpectrum(m_iLSpecPoints,m_fLSpecMinExp,m_fLSpecMaxExp,buf,m_iLSpecData,m_iMaxLMIter,m_bLSpecDataLin,m_fLSpecZeroWeight,m_bEvolve);
	sprintf(buf,"%s_lsfit_N%d_P%d_I%d_%s_zero%.0f_%s%s%s.csv",pre1,m_iLSpecData,m_iLSpecPoints,m_iMaxLMIter,m_bLSpecDataLin?"lin":"log",m_fLSpecZeroWeight,post1,post2,post3);
	mprintf("    Saving lifetime spectrum fit as \"%s\"...\n",buf);
	df->Write("",buf,"",false);
	mprintf("\n");
}
